<?php 

function frannamag_container_layout_options( $wp_customize ) {

    $wp_customize->add_section( 'frannamag_container_layout_section', array(
        'title'                 =>  esc_html__( 'Main container', 'frannamag' ),
        'priority'              =>  10,
        'panel'                 =>  'frannamag_layout_panel'
    ) );

    //Main Menu social_icons
    $wp_customize->add_setting( 'frannamag_container_layout_setting', array(
        'default'               =>  '2',
        'sanitize_callback'     =>  'wp_kses_post'
    ) );

    $wp_customize->add_control( new frannamag_Image_Select_Container_control(
        $wp_customize,
        'frannamag_container_layout_setting',
        array(
            'label'             =>  esc_attr__( 'Main container layout', 'frannamag' ),
            'section'           =>  'frannamag_container_layout_section',
            'settings'          =>  'frannamag_container_layout_setting',
        )
    ) );

}