<?php

function frannamag_blog_layout_options($wp_customize)
{
    $wp_customize->add_section('frannamag_blog_layout_section', array(
        'title'                 =>  esc_html__('Blog Layout', 'frannamag'),
        'priority'              =>  20,
        'panel'                 =>  'frannamag_layout_panel'
    ));

    $wp_customize->add_setting('frannamag_blog_layout_setting', array(
        'default'               =>  '1',
        'sanitize_callback'     =>  'wp_kses_post'
    ));

    $wp_customize->add_control(new frannamag_Image_Select_Blog_control(
        $wp_customize,
        'frannamag_blog_layout_setting',
        array(
            'label'             =>  esc_html__('Select Layout', 'frannamag'),
            'section'           =>  'frannamag_blog_layout_section',
            'settings'          =>  'frannamag_blog_layout_setting',
        )
    ));
}
