<?php 
/**
 * Adding custom controls classes to the customizer
 */

if ( class_exists( 'WP_Customize_Control' ) ) :
    // Frontpage layout
    class frannamag_Image_Select_Home_control extends WP_Customize_Control {

        public $type = 'image_select';

        public function enqueue(){
            wp_enqueue_style( 'custom-controls-css', get_template_directory_uri().'/inc/customizer/css/custom-controls.css');
        }

        public function render_content(){
            ?>
                <div class="customize_image_select">
                <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                <p><?php echo wp_kses_post($this->description); ?></p>
                    <div class="img-container">
                        <label class="customize-layout">
                            <input type="radio" name="<?php echo esc_attr($this->id); ?>" value="1" data-customize-setting-link="<?php echo esc_attr($this->id); ?>" <?php checked('1', esc_attr($this->value()) );?>/>
                            <img src="<?php echo esc_url( get_template_directory_uri() ).'/dist/images/image-radio-2.png'?>" alt="<?php esc_attr_e('Default Layout', 'frannamag'); ?>" title="<?php esc_attr_e('Default Layout', 'frannamag'); ?>" />
                            <span class="customize-layout__frontpage"><?php esc_html_e( 'Default', 'frannamag' ); ?></span>
                        </label>
                        <label class="customize-layout">
                            <input type="radio" name="<?php echo esc_attr($this->id); ?>" value="2" data-customize-setting-link="<?php echo esc_attr($this->id); ?>" <?php checked('2', esc_attr($this->value()) );?>/>
                            <img src="<?php echo esc_url( get_template_directory_uri() ).'/dist/images/image-radio-5.png'?>" alt="<?php esc_attr_e('Home Banner', 'frannamag'); ?>" title="<?php esc_attr_e('Home Banner', 'frannamag'); ?>" />
                            <span class="customize-layout__frontpage"><?php esc_html_e( 'Banner', 'frannamag' ); ?></span>
                        </label>
                        <label class="customize-layout">
                            <input type="radio" name="<?php echo esc_attr($this->id); ?>" value="3" data-customize-setting-link="<?php echo esc_attr($this->id); ?>" <?php checked('3', esc_attr($this->value()) );?>/>
                            <img src="<?php echo esc_url( get_template_directory_uri() ).'/dist/images/image-radio-6.png'?>" alt="<?php esc_attr_e('Grid two columns', 'frannamag'); ?>" title="<?php esc_attr_e('Grid two columns', 'frannamag'); ?>" />
                            <span class="customize-layout__frontpage"><?php esc_html_e( 'Grid two columns', 'frannamag' ); ?></span>
                        </label>
                        <label class="customize-layout">
                            <input type="radio" name="<?php echo esc_attr($this->id); ?>" value="4" data-customize-setting-link="<?php echo esc_attr($this->id); ?>" <?php checked('4', esc_attr($this->value()) );?>/>
                            <img src="<?php echo esc_url( get_template_directory_uri() ).'/dist/images/image-radio-7.png'?>" alt="<?php esc_attr_e('Grid three columns', 'frannamag'); ?>" title="<?php esc_attr_e('Grid three columns', 'frannamag'); ?>" />
                            <span class="customize-layout__frontpage"><?php esc_html_e( 'Grid three columns', 'frannamag' ); ?></span>
                        </label>
                    </div>
                </div>
            <?php
        } 
    }

endif;