<?php
/**
 * FrannaMag Theme Customizer
 *
 * @package FrannaMag
 */

 /**
  * Load Custom Theme options Files
  */

// Custom Controls
get_template_part( 'inc/customizer/custom-controls/class-checkbox-controls' );
get_template_part( 'inc/customizer/custom-controls/class-separator-controls' );
get_template_part( 'inc/customizer/custom-controls/class-container-layout' );
get_template_part( 'inc/customizer/custom-controls/class-frontpage-layout' );
get_template_part( 'inc/customizer/custom-controls/class-blog-layout' );
get_template_part( 'inc/customizer/custom-controls/class-custom-notice' );

// Theme Option
get_template_part( 'inc/customizer/theme-options/theme-options-panel' );
get_template_part( 'inc/customizer/theme-options/theme-options' );
get_template_part( 'inc/customizer/theme-options/navbar-social-icons' );
get_template_part( 'inc/customizer/theme-options/social-share-buttons' );
get_template_part( 'inc/customizer/theme-options/footer-widgets' );

// Layout
get_template_part( 'inc/customizer/layout/layout-panel' );
get_template_part( 'inc/customizer/layout/container-layout' );
get_template_part( 'inc/customizer/layout/home-layout' );
get_template_part( 'inc/customizer/layout/blog-layout' );

get_template_part( 'inc/customizer/sanitizations' );

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function frannamag_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'frannamag_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'frannamag_customize_partial_blogdescription',
			)
		);
	}

	// Custom Theme Options
	frannamag_theme_options_panel_customizer( $wp_customize );
	frannamag_theme_options_display( $wp_customize );
	frannamag_navbar_social_media_options( $wp_customize );
	frannamag_social_share_options( $wp_customize );
	frannamag_footer_widgets_display_options( $wp_customize );

	// Layout
	frannamag_layout_panel_customizer( $wp_customize );
	frannamag_container_layout_options( $wp_customize );
	frannamag_home_layout_options( $wp_customize );
	frannamag_blog_layout_options( $wp_customize );

}
add_action( 'customize_register', 'frannamag_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function frannamag_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function frannamag_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function frannamag_customize_preview_js() {
	wp_enqueue_script( 'frannamag-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), FMag_VERSION, true );
}
add_action( 'customize_preview_init', 'frannamag_customize_preview_js' );
