<?php 

/**
 * Adds Class_Widget widget.
 */
class frannamag_Category_Two_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'post_style_2', // Base ID
			esc_html__( 'Posts Style 2', 'frannamag' ), // Name
			array( 'description' => esc_html__( 'Display posts in frontpage', 'frannamag' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }

        global $post;

        $title      = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $number     = ! empty( $instance['number'] ) ? $instance['number'] : 2 ;
        $type       = isset( $instance['type'] ) ? $instance['type'] : 'latest';
        $category   = isset( $instance['category'] ) ? $instance['category'] : '';

        $args_post_two = array(
            'posts_per_page'      => $number,
            'post_type'           => 'post'
        );

        // Display from chosen category.
        if ( $type == 'category' ) {
            $args_post_two['category__in'] = $category;
        }

        $post_cat_two   =   new WP_Query( $args_post_two );
    ?>

        <!-- Widget Category Two Post Starts -->

            <?php if( $post_cat_two->have_posts() ) : ?>

                <div class="widget-category-two">

                    <?php while( $post_cat_two->have_posts() ): $post_cat_two->the_post(); ?>
                        
                        <div class="category-two-content">

                            <?php if ( has_post_thumbnail() ) : ?>
                                <div class="img-container">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php frannamag_post_thumbnail(); ?>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <div class="text-container">

                                <div class="entry-meta">
                                    <?php
                                        frannamag_posted_on();
                                    ?>
                                </div><!-- .entry-meta -->

                              <h4 class="entry-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                              </h4>

                                <p class="entry-summary">
                                    <?php the_excerpt(); ?>
                                </p>

                            </div>

                          </div>
                        
                    <?php endwhile; wp_reset_postdata(); ?>

                </div><!-- .widget-category-two -->

            <?php endif; ?>

        <!-- Widget Category two Post Ends -->

    <?php
		echo $args['after_widget'];
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
            $title      = ! empty( $instance['title'] ) ? $instance['title'] : '';
            $number     = ! empty( $instance['number'] ) ? $instance['number'] : 2 ;
            $type       = isset( $instance['type'] ) ? $instance['type'] : 'latest';
            $category   = isset( $instance['category'] ) ? $instance['category'] : '';
        ?>
        
		<p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'frannamag' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of Posts:', 'frannamag' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" min="2">
        </p>

        <p>
			<input type="radio" <?php checked( $type, 'latest' ) ?> id="<?php echo $this->get_field_id( 'type' ); ?>" name="<?php echo $this->get_field_name( 'type' ); ?>" value="latest" /><?php _e( 'Show latest Posts', 'frannamag' ); ?>
			<br />
			<input type="radio" <?php checked( $type, 'category' ) ?> id="<?php echo $this->get_field_id( 'type' ); ?>" name="<?php echo $this->get_field_name( 'type' ); ?>" value="category" /><?php _e( 'Show posts from a category', 'frannamag' ); ?>
            <br />
        </p>

		<p>
			<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e( 'Select category', 'frannamag' ); ?>
				:</label>
			<?php wp_dropdown_categories( array(
				'show_option_none' => ' ',
				'name'             => $this->get_field_name( 'category' ),
				'selected'         => $category,
			) ); ?>
		</p>
        
		<?php 
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? frannamag_sanitize_widget_nohtml( $new_instance['title'] ) : '';
		$instance['number'] = ( ! empty( $new_instance['number'] ) ) ? frannamag_sanitize_widget_number( $new_instance['number'] ) : '';
		$instance['type'] = ( ! empty( $new_instance['type'] ) ) ? frannamag_sanitize_widget_select( $new_instance['type'] ) : '';
		$instance['category'] = ( ! empty( $new_instance['category'] ) ) ? frannamag_sanitize_widget_select( $new_instance['category'] ) : '';

		return $instance;
	}

}