<?php 
/**
 * Load Custom Widgets files
 */
get_template_part( 'inc/custom-widgets/widget-cat-one' );
get_template_part( 'inc/custom-widgets/widget-cat-two' );
get_template_part( 'inc/custom-widgets/widget-cat-three' );
get_template_part( 'inc/custom-widgets/widget-recent-posts' );
get_template_part( 'inc/custom-widgets/sanitize-widgets' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function frannamag_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Main Sidebar', 'frannamag' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'frannamag' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
    );
    
    register_sidebar(
		array(
			'name'          => esc_html__( 'Frontpage Sidebar', 'frannamag' ),
			'id'            => 'frontpage-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'frannamag' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
    );

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer widget one', 'frannamag' ),
			'id'            => 'footer-widget-one',
			'description'   => esc_html__( 'Add widgets here.', 'frannamag' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
    );

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer widget two', 'frannamag' ),
			'id'            => 'footer-widget-two',
			'description'   => esc_html__( 'Add widgets here.', 'frannamag' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
    );

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer widget three', 'frannamag' ),
			'id'            => 'footer-widget-three',
			'description'   => esc_html__( 'Add widgets here.', 'frannamag' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
    );

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer widget four', 'frannamag' ),
			'id'            => 'footer-widget-four',
			'description'   => esc_html__( 'Add widgets here.', 'frannamag' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		)
    );
    
    // Register Custom Widgets
    register_widget( 'frannamag_Category_One_Widget' );
    register_widget( 'frannamag_Category_Two_Widget' );
    register_widget( 'frannamag_Category_Three_Widget' );
    register_widget( 'frannamag_Recent_Posts_Widget' );
}
add_action( 'widgets_init', 'frannamag_widgets_init' );