<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package FrannaMag
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div id="page" class="site">

	<?php
        $layout_class		=	get_theme_mod('frannamag_container_layout_setting', '2');

        if (get_theme_mod('frannamag_container_layout_setting', '2') == 1) {
            $layout_class	=	'large';
        } else {
            $layout_class	=	'';
        }
    ?>

	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'frannamag'); ?></a>

	<header id="masthead" class="site-header">

		<?php if (get_theme_mod('frannamag_top_menu_display_setting', true)): ?>
		<!-- .top-header -->
		<div class="top-header">

			<div class="wrapper <?php echo esc_attr($layout_class); ?>">

				<div class="top-header-menu">
					<?php
                        if (has_nav_menu('top-header')) {
                            wp_nav_menu(array(
                                'theme_location'	=>	'top-header',
                                'menu_class'		=>	'menu',
                                'depth'				=>	1,
                            ));
                        }
                    ?>
				</div>

				<div class="top-header-search">
					<?php get_search_form(); ?>
				</div>

				<?php if (get_theme_mod('frannamag_navbar_social_icons_display_setting', false)): ?>
					<div class="social-icons-container">
						<?php if (get_theme_mod('frannamag_facebook_setting')): ?>
							<a target="_blank" href="<?php echo esc_url(get_theme_mod( 'frannamag_facebook_setting', 'https://www.facebook.com/webthemevault/' )); ?>" title="<?php esc_attr_e('Facebook', 'frannamag'); ?>"><i class="fab fa-facebook-f facebook" aria-label="<?php esc_html__('Facebook Icon', 'frannamag'); ?>"></i></a>
						<?php endif; ?>
						<?php if (get_theme_mod('frannamag_instagram_setting')): ?>
							<a target="_blank" href="<?php echo esc_url(get_theme_mod( 'frannamag_instagram_setting' )); ?>" title="<?php esc_attr_e('Instagram', 'frannamag'); ?>"><i class="fab fa-instagram instagram" aria-label="<?php esc_html__('Instagram Icon', 'frannamag'); ?>"></i></a>
						<?php endif; ?>
						<?php if (get_theme_mod('frannamag_twitter_setting')): ?>
							<a target="_blank" href="<?php echo esc_url(get_theme_mod( 'frannamag_twitter_setting' )); ?>" title="<?php esc_attr_e('Twitter', 'frannamag'); ?>"><i class="fab fa-twitter twitter" aria-label="<?php esc_html__('Twitter icon', 'frannamag'); ?>"></i></a>
						<?php endif; ?>
					</div><!-- .social-icons-container -->
				<?php endif; ?>

				<?php if (get_theme_mod('frannamag_top_menu_date_display_setting', true)) : ?>
					<div class="date-container">
						<p><?php echo esc_html(date_i18n(get_option('date_format'))); ?></p>
					</div>
				<?php endif; ?>

			</div><!-- .wrapper -->

		</div>
		<!-- .top-header end -->
		<?php endif; ?>

		<!-- .custom-header-container -->
		<div class="custom-header-container">
			<div class="wrapper <?php echo esc_attr($layout_class); ?>">
				<?php the_header_image_tag(); ?>
			</div>
		</div>
		<!-- .custom-header-container -->

		<nav id="navigation" class="navbar navbar-expand-lg" role="navigation">

			<div class="container <?php echo esc_attr($layout_class); ?>">

				<!-- Site Branding -->
				<div class="site-branding navbar-brand">
					<?php
					if (has_custom_logo()):
						the_custom_logo();
					else:
						if (is_front_page() && is_home()) :
							?>
							<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
							<?php
						elseif (is_front_page()) :
							?>
							<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
							<?php
						else :
							?>
							<p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></p>
							<?php
						endif;
						$frannamag_description = get_bloginfo('description', 'display');
						if ($frannamag_description || is_customize_preview()) :
							?>
							<p class="site-description"><?php echo $frannamag_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped?></p>
						<?php endif;
					endif; ?>
				</div><!-- .site-branding -->

				<!-- Main Menu -->
				<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavigation" aria-controls="mainNavigation" aria-expanded="false" aria-label="<?php esc_attr_e('Toggle navigation', 'frannamag'); ?>">
					<div class="bi bi-three-dots menu-toggler-icon"></div>
				</button>

				<div class="collapse navbar-collapse" id="mainNavigation">

					<?php
						if (has_nav_menu('primary')) {
							wp_nav_menu(
								array(
									'theme_location' 	=>	'primary',
									'container'			=>	false,
									'menu_id'			=>	'main-menu',
									'menu_class'		=>	'sm sm-simple site-navigation',
									'depth'				=>	3
								)
							);
						}
					?>
					<?php
						if (get_theme_mod('frannamag_menu_cart_display_setting', false)) :
							if (class_exists('WooCommerce')) {
								frannamag_woocommerce_cart_link();
							}
						endif;
					?>

				</div>

			</div>

		</nav>

	</header><!-- #masthead -->

	<div id="content" class="site-content" role="main">

		<div class="wrapper <?php echo esc_attr($layout_class); ?>">

			<?php if (is_front_page() && ! is_home()): ?>
				<?php get_template_part('template-parts/content', 'home-layout'); ?>
			<?php endif; ?>
