<?php
/**
 * FrannaMag functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package FrannaMag
 */

if (! defined('FMag_VERSION')) {
    // Replace the version number of the theme on each release.
    define('FMag_VERSION', '1.0.8');
}

/**
 * Load Setup File
 */
require get_template_directory() . '/inc/theme-setup.php';

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
require get_template_directory() . '/inc/custom-widgets/main.php';

/**
 * Load scripts and styles.
 */
require get_template_directory() . '/inc/enqueue.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load admin notices.
 */
require get_template_directory() . '/inc/notices/admin-notices.php';

/**
 * Load Custom Queries
 */
require get_template_directory() . '/inc/post-search-queries.php';

/**
 * Load Custom Filters
 */
require get_template_directory() . '/inc/filters.php';

/**
 * Load Custom Functions file
 */
require get_template_directory() . '/inc/theme-functions.php';

/**
 * Load Custom Post Navigation file
 */
require get_template_directory() . '/inc/post-navigation.php';

/**
 * Load Recommended Plugins File
 */
require get_template_directory() . '/plugins/plugins.php';

/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
    require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Load WooCommerce compatibility file.
 */
if (class_exists('WooCommerce')) {
    require get_template_directory() . '/inc/woocommerce.php';
}

/**
 * Bootstrap Nav Walker
 */
if (! file_exists(get_template_directory() . '/inc/class-wp-bootstrap-navwalker.php')) {
    // File does not exist... return an error.
    return new WP_Error('class-wp-bootstrap-navwalker-missing', __('It appears the class-wp-bootstrap-navwalker.php file may be missing.', 'frannamag'));
} else {
    // File exists... require it.
    require_once get_template_directory() . '/inc/class-wp-bootstrap-navwalker.php';
}
