<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package FrannaMag
 */

?>
	<?php
        $layout_class	=	get_theme_mod( 'frannamag_container_layout_setting', '2' );

        if (get_theme_mod( 'frannamag_container_layout_setting', '2') == 1 ) {
            $layout_class	=	'large';
        } else {
            $layout_class	=	'';
        }
    ?>

		</div><!-- .wrapper -->

	</div><!-- #content -->

	<footer id="colophon" class="site-footer" role="contentinfo">

		<?php if ( get_theme_mod("frannamag_footer_widgets_display_setting", false )): ?>

			<div class="footer-widgets">

				<div class="wrapper <?php echo esc_attr($layout_class); ?>">
					<div class="footer-widget-one">
						<?php
                            if (is_active_sidebar('footer-widget-one')) {
                                dynamic_sidebar('footer-widget-one');
                            }
                        ?>
					</div>
		
					<div class="footer-widget-two">
						<?php
                            if (is_active_sidebar('footer-widget-two')) {
                                dynamic_sidebar('footer-widget-two');
                            }
                        ?>
					</div>
				
					<div class="footer-widget-three">
						<?php
                            if (is_active_sidebar('footer-widget-three')) {
                                dynamic_sidebar('footer-widget-three');
                            }
                        ?>
					</div>
				
					<div class="footer-widget-four">
						<?php
                            if (is_active_sidebar('footer-widget-four')) {
                                dynamic_sidebar('footer-widget-four');
                            }
                        ?>
					</div>
				</div>
				
			</div><!-- .footer-widgets -->

		<?php endif; ?>

		<div class="footer-bottom">

			<div class="wrapper <?php echo esc_attr($layout_class); ?>">

				<div class="footer-bottom-left">
					<div class="copyright">
						<p>
							<?php
                                printf(
                                    /* translators: %: Theme Name */
                                    esc_html__('Theme %1$s by %2$s', 'frannamag'),
                            '<a target="_blank" href="'. esc_url('https://webthemevault.xyz/wp-themes/frannamag/') .'">'. esc_html(ucfirst('frannamag')) .'</a>',
                            esc_html('Pitshou Kalombo')
                        );
                            ?>
							<span class="sep">|</span>
							<?php
                                printf(
                                    /* translators: %: CMS Name */
                                    esc_html__('Powered by %s', 'frannamag'),
                                esc_html__('WordPress', 'frannamag')
                            );
                            ?>
						</p>
					</div>
				</div>

				<div class="footer-bottom-right">
					<?php
                        if (has_nav_menu('footer')) {
                            wp_nav_menu(array(
                                'theme_location'	=>	'footer',
                                'menu_class'		=>	'menu',
                                'depth'				=>	1
                            ));
                        }
                    ?>
				</div>

			</div>
			
		</div>

	</footer><!-- #colophon -->

	<button id="scroll-to-top">
		<i class="bi bi-arrow-up scroll-to-top" aria-hidden="true"></i>
		<span class="screen-reader-text" aria-hidden="true"><?php esc_html__('Scroll to Top', 'frannamag'); ?></span>
	</button>
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
