<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package FrannaMag
 */

?>


	<footer id="colophon" class="site-footer" role="contentinfo">
		<div class="wrapper">

			<div class="footer-bottom">

				<div class="footer-bottom-left">
					<div class="copyright">
						<p>
							<?php
								printf( 
									/* translators: %: Theme Name */
									esc_html__( 'Theme %1$s by %2$s', 'frannamag' ), '<a target="_blank" href="'. esc_url( 'https://webthemevault.xyz/wp-themes/frannamag/' ) .'">'. esc_html( ucfirst( 'frannamag' ) ) .'</a>', esc_html( 'Pitshou Kalombo' ) );
							?>
							<span class="sep">|</span>
							<?php
								printf( 
									/* translators: %: CMS Name */
									esc_html__( 'Powered by %s', 'frannamag' ), esc_html__( 'WordPress', 'frannamag' ) );
							?>
						</p>
					</div>
				</div>

				<div class="footer-bottom-right">
					<?php
						if( has_nav_menu( 'footer' ) ) {
							wp_nav_menu( array(
								'theme_location'	=>	'footer',
								'menu_class'		=>	'menu',
								'depth'				=>	1
							) );
						}
					?>
				</div>
				
			</div>
			
		</div>
	</footer><!-- #colophon -->

<?php wp_footer(); ?>

</body>
</html>
