<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package FrannaMag
 */

get_header( '404' );
?>

	 <div class="not-found-main-container">

        <div class="wrapper">

            <div class="not-found-content text-center">

                <div class="not-found-header">
					<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'frannamag' ); ?></h1>
				</div>

                <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'frannamag' ); ?></p>

                <?php get_search_form(); ?>

				<div class="or">
					<?php esc_html_e( 'Or', 'frannamag' ); ?>
				</div>

                <div class="read-more-btn-container">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="home-btn btn read-more-btn btn-2"><?php esc_html_e( 'Go to Homepage', 'frannamag' ); ?></a>
                </div>

            </div>

        </div><!-- .wrapper -->

    </div><!-- .not-found-main-container -->

<?php
get_footer( '404' );
