<?php
/**
 * Title: Page pattern for business
 * Slug: frameword-lite/page-business
 * Categories: frameword-lite
 * Block Types: core/post-content
 */
?>

<!-- wp:group {"style":{"spacing":{"padding":{"right":"0","left":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:0;padding-left:0"><!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"0"},"padding":{"top":"var:preset|spacing|sm","bottom":"var:preset|spacing|sm"}}}} -->
<div class="wp-block-columns" style="padding-top:var(--wp--preset--spacing--sm);padding-bottom:var(--wp--preset--spacing--sm)"><!-- wp:column {"verticalAlignment":"center","width":"60%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:60%"><!-- wp:heading {"level":1,"className":"is-style-frameword-text-wrap-balance"} -->
<h1 class="wp-block-heading is-style-frameword-text-wrap-balance"><?php _e('Hire the best specialists without hustle with our service', 'frameword-lite'); ?></h1>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs"}}},"className":"is-style-frameword-text-wrap-balance","fontSize":"usual"} -->
<p class="is-style-frameword-text-wrap-balance has-usual-font-size" style="margin-top:var(--wp--preset--spacing--xs);margin-bottom:var(--wp--preset--spacing--xs)"><strong><?php _e('Frameword', 'frameword-lite'); ?> </strong><?php _e('welcomes you to a world where finding and hiring the best specialists is seamless and stress-free. Elevate your team\'s capabilities with our curated talent pool and streamlined recruitment process.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xs"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"accent","textColor":"buttons-font","style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs"}},"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
<div class="wp-block-button" style="font-style:normal;font-weight:500"><a class="wp-block-button__link has-buttons-font-color has-accent-background-color has-text-color has-background wp-element-button" style="padding-top:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs)"><?php _e('Schedule a Call', 'frameword-lite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->

<!-- wp:paragraph {"textColor":"font-text","fontSize":"tiny"} -->
<p class="has-font-text-color has-text-color has-tiny-font-size">👈 <?php _e('Get free 30-mins consultation', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"40%"} -->
<div class="wp-block-column" style="flex-basis:40%"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"16px"}}} -->
<figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""  style="border-radius:16px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"var:preset|spacing|3xl","bottom":"var:preset|spacing|3xl"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--3-xl);margin-bottom:var(--wp--preset--spacing--3-xl)"><!-- wp:heading {"textAlign":"center","fontSize":"medium"} -->
<h2 class="wp-block-heading has-text-align-center has-medium-font-size"><?php _e('Why Choose Our Specialist Hiring Service?', 'frameword-lite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"backgroundColor":"background-hard","textColor":"font-light","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-font-light-color has-background-hard-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)"><!-- wp:image {"width":"40px","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|duotone-reverse"},"border":{"radius":"0px"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/icon-1.svg" alt="" style="border-radius:0px;width:40px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php _e('Seamless Recruitment Process', 'frameword-lite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--xxs)"><?php _e('Say goodbye to the traditional hiring headaches. We streamline the process to connect you with the best specialists effortlessly.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"backgroundColor":"background-hard","textColor":"font-light","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-font-light-color has-background-hard-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)"><!-- wp:image {"width":"40px","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|duotone-reverse"},"border":{"radius":"0px"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/icon-2.svg" alt="" style="border-radius:0px;width:40px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php _e('Curated Talent Pool', 'frameword-lite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--xxs)"><?php _e('Our extensive network boasts top-notch specialists across various domains. We handpick candidates to ensure you get the cream of the crop.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"backgroundColor":"background-hard","textColor":"font-light","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-font-light-color has-background-hard-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)"><!-- wp:image {"width":"40px","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|duotone-reverse"},"border":{"radius":"0px"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/icon-3.svg" alt="" style="border-radius:0px;width:40px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php _e('Expertise Across Industries', 'frameword-lite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--xxs)"><?php _e('Whether you need IT professionals, marketing gurus, or finance wizards, we\'ve got you covered. Our specialists span a multitude of industries.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}}},"backgroundColor":"background-hard","textColor":"font-light","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-font-light-color has-background-hard-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)"><!-- wp:image {"width":"40px","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|duotone-reverse"},"border":{"radius":"0px"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/icon-4.svg" alt="" style="border-radius:0px;width:40px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php _e('Time-Efficient Solutions', 'frameword-lite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--xxs)"><?php _e('Save time without compromising on quality. We understand the urgency of hiring, and our process is designed for swift and effective results.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xl","bottom":"var:preset|spacing|xl"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--xl);padding-bottom:var(--wp--preset--spacing--xl)"><!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|xl"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"33.33%"} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:group {"style":{"position":{"type":"sticky","top":"0px"},"spacing":{"padding":{"top":"var:preset|spacing|sm"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--sm)"><!-- wp:heading {"textAlign":"left","fontSize":"medium"} -->
<h2 class="wp-block-heading has-text-align-left has-medium-font-size"><?php _e('How It Works', 'frameword-lite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","style":{"spacing":{"margin":{"top":"var:preset|spacing|xs"}}},"className":"is-style-frameword-text-wrap-balance"} -->
<p class="has-text-align-left is-style-frameword-text-wrap-balance" style="margin-top:var(--wp--preset--spacing--xs)"><?php _e('Streamlined Steps, Exceptional Results: Your Path to Specialist Hiring Simplicity', 'frameword-lite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"accent","textColor":"buttons-font","style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs"}},"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
<div class="wp-block-button" style="font-style:normal;font-weight:500"><a class="wp-block-button__link has-buttons-font-color has-accent-background-color has-text-color has-background wp-element-button" style="padding-top:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs)"><?php _e('Get started', 'frameword-lite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"66.66%","style":{"spacing":{"padding":{"top":"var:preset|spacing|sm"}}}} -->
<div class="wp-block-column" style="padding-top:var(--wp--preset--spacing--sm);flex-basis:66.66%"><!-- wp:columns {"style":{"border":{"radius":"10px"},"spacing":{"padding":{"right":"var:preset|spacing|50","left":"var:preset|spacing|50"}}},"backgroundColor":"background-soft"} -->
<div class="wp-block-columns has-background-soft-background-color has-background" style="border-radius:10px;padding-right:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:column {"width":"78%"} -->
<div class="wp-block-column" style="flex-basis:78%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong>1. <strong><?php _e('Submit Your Job Opening', 'frameword-lite'); ?></strong></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php _e('Fill out a simple form outlining your hiring needs.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"style":{"border":{"radius":"10px"},"spacing":{"padding":{"right":"var:preset|spacing|50","left":"var:preset|spacing|50"}}},"backgroundColor":"background-soft"} -->
<div class="wp-block-columns has-background-soft-background-color has-background" style="border-radius:10px;padding-right:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:column {"width":"78%"} -->
<div class="wp-block-column" style="flex-basis:78%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong>2. <strong><strong><?php _e('Tailored Matching', 'frameword-lite'); ?></strong></strong></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php _e('Our advanced algorithms and expert recruiters match your requirements with the perfect candidates.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"style":{"border":{"radius":"10px"},"spacing":{"padding":{"right":"var:preset|spacing|50","left":"var:preset|spacing|50"}}},"backgroundColor":"background-soft"} -->
<div class="wp-block-columns has-background-soft-background-color has-background" style="border-radius:10px;padding-right:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:column {"width":"78%"} -->
<div class="wp-block-column" style="flex-basis:78%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong>3. <strong><strong><strong><?php _e('Review and Select', 'frameword-lite'); ?></strong></strong></strong></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php _e('Access detailed profiles of matched specialists. Choose the ones that align with your goals.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"style":{"border":{"radius":"10px"},"spacing":{"padding":{"right":"var:preset|spacing|50","left":"var:preset|spacing|50"}}},"backgroundColor":"background-soft"} -->
<div class="wp-block-columns has-background-soft-background-color has-background" style="border-radius:10px;padding-right:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:column {"width":"78%"} -->
<div class="wp-block-column" style="flex-basis:78%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong>4. <strong><strong><strong><strong><?php _e('Start Building Your Team', 'frameword-lite'); ?></strong></strong></strong></strong></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php _e('Once you\'ve made your selections, kickstart your project with a team of specialists ready to make an impact.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:heading {"textAlign":"center","fontSize":"medium"} -->
<h2 class="wp-block-heading has-text-align-center has-medium-font-size"><?php _e('Testimonials', 'frameword-lite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}}},"backgroundColor":"background-soft","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-background-soft-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50)"><!-- wp:image {"id":66,"scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":["#111","#888"]}}} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/quote.png" alt="" class="wp-image-66" style="object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php _e('We don\'t just design, we bring your vision to life. Specializing in UI, UX, Web, and Mobile. Your dream is our next project.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|sm"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:image {"width":"60px","height":"undefinedpx","sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"100px"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""  style="border-radius:100px;width:60px;height:undefinedpx"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"tiny"} -->
<p class="has-tiny-font-size"><strong><?php _e('Name Surname', 'frameword-lite'); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#8b8a8a"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"tiny"} -->
<p class="has-text-color has-tiny-font-size" style="color:#8b8a8a;margin-top:0;margin-bottom:0"><?php _e('Silicon Valley', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}}},"backgroundColor":"background-soft","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-background-soft-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50)"><!-- wp:image {"id":66,"scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":["#111","#888"]}}} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/quote.png" alt="" class="wp-image-66" style="object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php _e('We don\'t just design, we bring your vision to life. Specializing in UI, UX, Web, and Mobile. Your dream is our next project.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|sm"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:image {"width":"60px","height":"undefinedpx","sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"100px"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""  style="border-radius:100px;width:60px;height:undefinedpx"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"tiny"} -->
<p class="has-tiny-font-size"><strong><?php _e('Name Surname', 'frameword-lite'); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#8b8a8a"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"tiny"} -->
<p class="has-text-color has-tiny-font-size" style="color:#8b8a8a;margin-top:0;margin-bottom:0"><?php _e('Silicon Valley', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}}},"backgroundColor":"background-soft","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-background-soft-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50)"><!-- wp:image {"id":66,"scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":["#111","#888"]}}} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/quote.png" alt="" class="wp-image-66" style="object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><?php _e('We don\'t just design, we bring your vision to life. Specializing in UI, UX, Web, and Mobile. Your dream is our next project.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|sm"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:image {"width":"60px","height":"undefinedpx","sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"100px"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""  style="border-radius:100px;width:60px;height:undefinedpx"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"tiny"} -->
<p class="has-tiny-font-size"><strong><?php _e('Name Surname', 'frameword-lite'); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#8b8a8a"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"tiny"} -->
<p class="has-text-color has-tiny-font-size" style="color:#8b8a8a;margin-top:0;margin-bottom:0"><?php _e('Silicon Valley', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group">
<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"width":"40%"} -->
<div class="wp-block-column" style="flex-basis:40%"><!-- wp:image {"width":"400px","height":"undefinedpx","aspectRatio":"1","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"20px"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""  style="border-radius:20px;aspect-ratio:1;object-fit:cover;width:400px;height:undefinedpx"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"%"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":["#888","#ffffff"]}}} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/black-quote.png" alt="" style="object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"medium"} -->
<p class="has-text-align-left has-medium-font-size" style="font-style:normal;font-weight:500"><?php _e('"We don\'t just design, we bring your vision to life. Specializing in UI, UX, Web, and Mobile. Your dream is our next project."', 'frameword-lite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"left"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"center"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"fontSize":"small"} -->
<p class="has-small-font-size"><strong><?php _e('Name Surname', 'frameword-lite'); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#8b8a8a"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"tiny"} -->
<p class="has-text-color has-tiny-font-size" style="color:#8b8a8a;margin-top:0;margin-bottom:0"><?php _e('Silicon Valley', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:social-links {"iconBackgroundColor":"accent","iconBackgroundColorValue":"#111111","style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<ul class="wp-block-social-links has-icon-background-color"><!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|xl","bottom":"var:preset|spacing|xl"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--xl);padding-bottom:var(--wp--preset--spacing--xl)"><!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|xl"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"33.33%"} -->
<div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:group {"style":{"position":{"type":"sticky","top":"0px"},"spacing":{"padding":{"top":"var:preset|spacing|sm"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--sm)"><!-- wp:heading {"textAlign":"left","fontSize":"medium"} -->
<h2 class="wp-block-heading has-text-align-left has-medium-font-size"><?php _e('Our Team', 'frameword-lite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","style":{"spacing":{"margin":{"top":"var:preset|spacing|xs"}}},"className":"is-style-frameword-text-wrap-balance"} -->
<p class="has-text-align-left is-style-frameword-text-wrap-balance" style="margin-top:var(--wp--preset--spacing--xs)"><?php _e('Streamlined Steps, Exceptional Results: Your Path to Specialist Hiring Simplicity', 'frameword-lite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"accent","textColor":"buttons-font","style":{"spacing":{"padding":{"top":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs"}},"typography":{"fontStyle":"normal","fontWeight":"500"}}} -->
<div class="wp-block-button" style="font-style:normal;font-weight:500"><a class="wp-block-button__link has-buttons-font-color has-accent-background-color has-text-color has-background wp-element-button" style="padding-top:var(--wp--preset--spacing--xxs);padding-bottom:var(--wp--preset--spacing--xxs)"><?php _e('Get started', 'frameword-lite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"66.66%","style":{"spacing":{"padding":{"top":"var:preset|spacing|sm"}}}} -->
<div class="wp-block-column" style="padding-top:var(--wp--preset--spacing--sm);flex-basis:66.66%"><!-- wp:columns {"style":{"border":{"radius":"10px"},"spacing":{"blockGap":{"left":"var:preset|spacing|xs"}}}} -->
<div class="wp-block-columns" style="border-radius:10px"><!-- wp:column {"width":"","style":{"spacing":{"padding":{"top":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs","left":"var:preset|spacing|xs","right":"var:preset|spacing|xs"}}},"backgroundColor":"background-soft","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-background-soft-background-color has-background" style="padding-top:var(--wp--preset--spacing--xs);padding-right:var(--wp--preset--spacing--xs);padding-bottom:var(--wp--preset--spacing--xs);padding-left:var(--wp--preset--spacing--xs)"><!-- wp:image {"lightbox":{"enabled":true},"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong><?php _e('Jane Ostin', 'frameword-lite'); ?></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs"}}},"fontSize":"tiny"} -->
<p class="has-tiny-font-size" style="margin-top:var(--wp--preset--spacing--xxs);margin-bottom:var(--wp--preset--spacing--xxs)"><?php _e('Fill out a simple form outlining your hiring needs.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"","style":{"spacing":{"padding":{"top":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs","left":"var:preset|spacing|xs","right":"var:preset|spacing|xs"}}},"backgroundColor":"background-soft","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-background-soft-background-color has-background" style="padding-top:var(--wp--preset--spacing--xs);padding-right:var(--wp--preset--spacing--xs);padding-bottom:var(--wp--preset--spacing--xs);padding-left:var(--wp--preset--spacing--xs)"><!-- wp:image {"lightbox":{"enabled":true},"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong><?php _e('Jane Ostin', 'frameword-lite'); ?></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs"}}},"fontSize":"tiny"} -->
<p class="has-tiny-font-size" style="margin-top:var(--wp--preset--spacing--xxs);margin-bottom:var(--wp--preset--spacing--xxs)"><?php _e('Fill out a simple form outlining your hiring needs.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"","style":{"spacing":{"padding":{"top":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs","left":"var:preset|spacing|xs","right":"var:preset|spacing|xs"}}},"backgroundColor":"background-soft","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-background-soft-background-color has-background" style="padding-top:var(--wp--preset--spacing--xs);padding-right:var(--wp--preset--spacing--xs);padding-bottom:var(--wp--preset--spacing--xs);padding-left:var(--wp--preset--spacing--xs)"><!-- wp:image {"lightbox":{"enabled":true},"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong><?php _e('Jane Ostin', 'frameword-lite'); ?></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs"}}},"fontSize":"tiny"} -->
<p class="has-tiny-font-size" style="margin-top:var(--wp--preset--spacing--xxs);margin-bottom:var(--wp--preset--spacing--xxs)"><?php _e('Fill out a simple form outlining your hiring needs.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"style":{"border":{"radius":"10px"},"spacing":{"blockGap":{"left":"var:preset|spacing|xs"}}}} -->
<div class="wp-block-columns" style="border-radius:10px"><!-- wp:column {"width":"","style":{"spacing":{"padding":{"top":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs","left":"var:preset|spacing|xs","right":"var:preset|spacing|xs"}}},"backgroundColor":"background-soft","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-background-soft-background-color has-background" style="padding-top:var(--wp--preset--spacing--xs);padding-right:var(--wp--preset--spacing--xs);padding-bottom:var(--wp--preset--spacing--xs);padding-left:var(--wp--preset--spacing--xs)"><!-- wp:image {"lightbox":{"enabled":true},"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong><?php _e('Jane Ostin', 'frameword-lite'); ?></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs"}}},"fontSize":"tiny"} -->
<p class="has-tiny-font-size" style="margin-top:var(--wp--preset--spacing--xxs);margin-bottom:var(--wp--preset--spacing--xxs)"><?php _e('Fill out a simple form outlining your hiring needs.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"","style":{"spacing":{"padding":{"top":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs","left":"var:preset|spacing|xs","right":"var:preset|spacing|xs"}}},"backgroundColor":"background-soft","className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10 has-background-soft-background-color has-background" style="padding-top:var(--wp--preset--spacing--xs);padding-right:var(--wp--preset--spacing--xs);padding-bottom:var(--wp--preset--spacing--xs);padding-left:var(--wp--preset--spacing--xs)"><!-- wp:image {"lightbox":{"enabled":true"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/patterns/images/man-person-male-portrait.jpg" alt=""/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><strong><?php _e('Jane Ostin', 'frameword-lite'); ?></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|xxs","bottom":"var:preset|spacing|xxs"}}},"fontSize":"tiny"} -->
<p class="has-tiny-font-size" style="margin-top:var(--wp--preset--spacing--xxs);margin-bottom:var(--wp--preset--spacing--xxs)"><?php _e('Fill out a simple form outlining your hiring needs.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"","style":{"spacing":{"padding":{"top":"var:preset|spacing|xs","bottom":"var:preset|spacing|xs","left":"var:preset|spacing|xs","right":"var:preset|spacing|xs"}}},"className":"is-style-frameword-rounded-borders-10"} -->
<div class="wp-block-column is-style-frameword-rounded-borders-10" style="padding-top:var(--wp--preset--spacing--xs);padding-right:var(--wp--preset--spacing--xs);padding-bottom:var(--wp--preset--spacing--xs);padding-left:var(--wp--preset--spacing--xs)"></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group">
<!-- wp:group {"style":{"border":{"radius":"16px"},"spacing":{"padding":{"top":"var:preset|spacing|lg","bottom":"var:preset|spacing|lg","left":"var:preset|spacing|lg","right":"var:preset|spacing|lg"},"margin":{"top":"var:preset|spacing|xl","bottom":"var:preset|spacing|xl"}}},"backgroundColor":"background-soft","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-soft-background-color has-background" style="border-radius:16px;margin-top:var(--wp--preset--spacing--xl);margin-bottom:var(--wp--preset--spacing--xl);padding-top:var(--wp--preset--spacing--lg);padding-right:var(--wp--preset--spacing--lg);padding-bottom:var(--wp--preset--spacing--lg);padding-left:var(--wp--preset--spacing--lg)"><!-- wp:heading {"textAlign":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
<h2 class="wp-block-heading has-text-align-left" style="font-style:normal;font-weight:600"><?php _e('Contact Us', 'frameword-lite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","className":"is-style-frameword-text-wrap-balance"} -->
<p class="has-text-align-left is-style-frameword-text-wrap-balance"><?php _e('Have questions or need assistance? Our team is ready to help.', 'frameword-lite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
<p style="margin-top:0;margin-bottom:0"><strong><?php _e('Call us:', 'frameword-lite'); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|font-text"}}},"spacing":{"margin":{"top":"0","bottom":"0"}}},"textColor":"font-text","fontSize":"large"} -->
<p class="has-font-text-color has-text-color has-link-color has-large-font-size" style="margin-top:0;margin-bottom:0"><strong>341-821-6680</strong></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
<p style="margin-top:0;margin-bottom:0"><strong><?php _e('Email us:', 'frameword-lite'); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|font-text"}}},"spacing":{"margin":{"top":"0","bottom":"0"}}},"textColor":"font-text","fontSize":"large"} -->
<p class="has-font-text-color has-text-color has-link-color has-large-font-size" style="margin-top:0;margin-bottom:0"><strong>frameword@gmail.com</strong></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->
