<?php
/**
 * Template part for displaying the header navigation menu
 *
 * @package fotographia
 */

namespace JM_Web_Development\Fotographia;

if ( ! fotographia()->is_primary_nav_menu_active() ) {
	return;
}

?>

<nav id="site-navigation" class="main-navigation nav--toggle-sub nav--toggle-small" aria-label="<?php esc_attr_e( 'Main menu', 'fotographia' ); ?>">


	<button class="menu-toggle" aria-label="<?php esc_attr_e( 'Open menu', 'fotographia' ); ?>" aria-controls="primary-menu" aria-expanded="false">
		<?php esc_html_e( 'Menu', 'fotographia' ); ?>
	</button>

	<div class="primary-menu-container">
		<?php fotographia()->display_primary_nav_menu( array( 'menu_id' => 'primary-menu' ) ); ?>
	</div>
</nav><!-- #site-navigation -->
