<?php
/**
 * Template part for displaying the header branding
 *
 * @package fotographia
 */

namespace JM_Web_Development\Fotographia;

if ( has_header_image() ) {
	$screen_reader_class = 'screen-reader-text';
} else {
	$screen_reader_class = '';
}
?>

<div class="site-branding">

	<?php
	if ( is_front_page() && is_home() ) {
		?>
		<h1 class="site-title <?php echo esc_attr( $screen_reader_class ); ?>"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
		<?php
	} else {
		?>
		<p class="site-title <?php echo esc_attr( $screen_reader_class ); ?>"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
		<?php
	}
	?>

	<?php
	$fotographia_description = get_bloginfo( 'description', 'display' );
	if ( $fotographia_description || is_customize_preview() ) {
		?>
		<p class="site-description screen-reader-text">
			<?php echo $fotographia_description; /* phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped */ ?>
		</p>
		<?php
	}
	?>
</div><!-- .site-branding -->
