<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package fotographia
 */

namespace JM_Web_Development\Fotographia;

if ( ! fotographia()->is_primary_sidebar_active() ) {
	return;
}

fotographia()->print_styles( 'fotographia-sidebar' );

?>
<aside id="secondary" class="primary-sidebar widget-area">
	<h2 class="screen-reader-text"><?php esc_attr_e( 'Asides', 'fotographia' ); ?></h2>
	<?php
		if ( is_author() ) {
			?>
			<aside id="author-bio1" class="widget author-bio clearfix">
				<?php the_post(); ?>
					<h4 class="widgettitle"><?php echo esc_html__( 'About ', 'fotographia' ) . get_the_author_meta( 'display_name' ); ?></h4>
					<div class="mugshot"><?php echo get_avatar( esc_url( get_the_author_meta( 'email' ) ), $size = 96 ); ?></div>
					<p class="bio"><?php echo get_the_author_meta( 'description' ); ?></p>
				<?php rewind_posts(); ?>
			</aside>
		<?php
		}
	?>
	<?php fotographia()->display_primary_sidebar(); ?>
</aside><!-- #secondary -->
