<?php
/**
 * Render your site front page, whether the front page displays the blog posts index or a static page.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#front-page-display
 *
 * @package fotographia
 */

namespace JM_Web_Development\Fotographia;

get_header();

// Use grid layout if blog index is displayed.
fotographia()->print_styles( 'fotographia-content', 'fotographia-front-page' );
fotographia()->load_dark_styles();

?>
<main id="primary" class="site-main">
	<div class="row" id="top-post">
		<?php get_template_part( 'template-parts/front-page/top', 'post' ); ?>
	</div>

	<div id="inner-content" class="row home-posts-section">

		<div class="home-posts">
			<?php get_template_part( 'template-parts/front-page/home', 'posts' ); ?>
		</div>

		<?php get_sidebar(); ?>

	</div> <!-- end #inner-content -->
</main><!-- #primary -->
<?php
get_footer();
