<?php
$fortune_theme_options = fortune_theme_options();
if(!$fortune_theme_options['slider_home']){return;}
if($fortune_theme_options['slider_plugin_code']){
    echo do_shortcode($fortune_theme_options['slider_plugin_code']);
}else{
    $slider_no        = 3;
    $slider_pages      = array();
    for( $i = 1; $i <= $slider_no; $i++ ) {
        $slider_pages[]    =  get_theme_mod( "fortune_slider_page_$i", 1 );
         
    }
    $slider_args  = array(
        'post_type' => 'page',
        'post__in' => array_map( 'absint', $slider_pages ),
        'posts_per_page' => absint($slider_no),
        'orderby' => 'post__in'
       
    ); 

    $fortune_slider = new   wp_Query( $slider_args ); ?>
    <div class="wrapper">
        <div id="fortune-slider" class="owl-slider owl-carousel owl-theme"><?php
            if($fortune_slider->have_posts()){
                while($fortune_slider->have_posts()):
                    $fortune_slider->the_post();
                    $slider_image_id = get_post_thumbnail_id();
                    $slider_image = wp_get_attachment_image_src( $slider_image_id, 'fortune_slider');?>
                    <div class="ft-slide">
                        <div class="ft-slide-overlay"></div>
                        <img src="<?php echo esc_url($slider_image[0]);?>" alt="<?php echo get_the_title(); ?>">
                            <div class="ft-slide-caption">
                            <div class="ft-slide-cap-title">
                                <span><?php the_title(); ?></span>
                            </div>

                            <div class="ft-slide-cap-desc">
                                <?php the_content(__('Read more','fortune')); ?>
                            </div>
                        </div>
                    </div><?php
                endwhile;
                wp_reset_postdata();
            }else{
?>
                <div class="ft-slide">
                    <div class="ft-slide-overlay"></div>
                    <img src="<?php echo get_template_directory_uri().'/images/hero.jpg'; ?>">
                        <div class="ft-slide-caption">
                        <div class="ft-slide-cap-title">
                            <span><?php _e('Fortune', 'fortune'); ?></span>
                        </div>

                        <div class="ft-slide-cap-desc">
                            <p><?php _e('Best WordPress Theme Ever!',  'fortune'); ?></p>
                        </div>
                    </div>
                </div>
                    <?php 
                }?>
        </div>
    </div>
<?php } ?>