<?php
$fortune_theme_options = fortune_theme_options();
if (!$fortune_theme_options['blog_home']) {return;}

if ($fortune_theme_options['blog_title'] != "") {?>
<!-- Recent Posts -->
<div class="title-decorated" data-animation="fadeInUp">
  <h1 id="blog-heading"><?php echo wp_kses_post($fortune_theme_options['blog_title']); ?></h1>
</div>
<?php } ?>

<?php if ($fortune_theme_options['blog_desc'] != "") {?>
<p class="text-center" data-animation="fadeInUp" id="blog-desc"><?php echo esc_html($fortune_theme_options['blog_desc']); ?></p>
<?php }?>

<div class="spacer-xl"></div>
<div class="row">
  <div id="owl-carousel" class="owl-carousel__posts owl-carousel"><?php 
    $all_posts = wp_count_posts('post')->publish;
    $all_posts = get_theme_mod( 'blog_home_num_post', 'all' ) == 'all' ? $all_posts : $fortune_theme_options['home_post_num'];
    $query     = array('post_type' => 'post', 'posts_per_page' => $all_posts, 'post__not_in' => get_option('sticky_posts'));

    if (query_posts($query)) {
      while (have_posts()): the_post();?>
        <div class="project-item">
            <div class="project-item-inner"><?php 
              if (has_post_thumbnail()) { ?>
                <figure class="alignnone project-img"><?php
                  $img_class = array('class' => 'img_responsive');
                  the_post_thumbnail('fortune_home_post_thumb', $img_class);?>
                  <div class="overlay">
                    <a href="<?php the_permalink();?>" class="dlink"><i class="fa fa-link"></i></a>
                  </div>
                </figure><?php
              }?>
              <div class="project-desc">
                <div class="meta"> <i class="fa fa-comments"></i>
                  <?php esc_url(comments_popup_link(__('No Comments', 'fortune'), __('1 Comment', 'fortune'), __('% Comments', 'fortune')));?>
                  <?php esc_url(edit_post_link(__('Edit', 'fortune'), ' &#124; ', ''));?>
                  <?php echo fortune_posted_on(); ?> </div>
                  <h4 class="title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>
                  <?php 
                  if($fortune_theme_options['blog_home_content']){
                    if(get_theme_mod('blog_home_content_type', 'excerpt')=='content'){
                      the_content();
                    }elseif(get_theme_mod('blog_home_content_type', 'excerpt')=='excerpt'){
                      the_excerpt();
                    }else{
                      echo wp_trim_words( get_the_content() , $fortune_theme_options['blog_home_content_custom'] );
                    }
                  }?>
                </div>
              </div>
            </div><?php
      endwhile;
      wp_reset_postdata();
    }?>
  </div>
</div>
<?php if ($all_posts > 4) {?>
  <div class="prev-next-holder text-center">
    <a class="prev-btn" id="carousel-prev"><i class="fa fa-angle-left"></i></a>
    <a class="next-btn" id="carousel-next"><i class="fa fa-angle-right"></i></a>
  </div>
<?php }?>
<!-- Recent Posts / End -->
<div class="spacer"></div>
