<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=0">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php wp_head(); ?>
</head>
<?php $fortune_theme_options = fortune_theme_options(); $fortune_site_layout = get_theme_mod('fortune_site_layout','');?>
<body <?php body_class($fortune_site_layout); ?>>
<a class="skip-link screen-reader-text" href="#site-content"><?php esc_html_e( 'Skip to content', 'fortune' ); ?></a>
	<div class="site-wrapper">
		
		<!-- Header -->
		<header class="header <?php echo get_theme_mod('fortune_navigation_style','header-default');?> header-centered">

		<?php if(get_theme_mod('fortue_show_top_bar',1) && (has_nav_menu( 'secondary' ) || $fortune_theme_options['contact_in_header'])){ ?>
		<div class="header-top">
			<div class="container">
				<div class="header-top-<?php echo get_theme_mod('fortune_topbar_contact_switch',0) ? 'right' : 'left';?>">
					<?php if ( has_nav_menu( 'secondary' ) ) :
							wp_nav_menu(array(
								'theme_location' => 'secondary',
								'container' => false,
								'depth'=>1,
								'menu_class' => 'header-top-nav',
								)
							);
						elseif(is_customize_preview()):
							echo '<a href="' . esc_url( admin_url( 'nav-menus.php' ) ) . '" title="' . esc_attr__( 'Add a menu', 'fortune' ) . '">' . esc_html__( 'Add a menu', 'fortune' ) . '</a>';
						endif;?>
				</div>
				<?php
					if($fortune_theme_options['contact_in_header']){?>
					<div class="header-top-<?php echo get_theme_mod('fortune_topbar_contact_switch',0) ? 'left' : 'right';?>">
						<?php if($fortune_theme_options['contact_phone']!=""){?>
						<span class="phone">
							<i class="fa fa-phone"></i> <?php _e('Call Us:','fortune');?> <a class="cont_phone" href="tel:<?php echo esc_attr($fortune_theme_options['contact_phone']);?>"><?php echo esc_html($fortune_theme_options['contact_phone']);?></a>
						</span>
					<?php } ?>
					<?php if($fortune_theme_options['contact_email']!=""){?>
						<span class="email">
						<i class="fa fa-envelope-o"></i> <?php _e('Email:','fortune');?> <a class="cont_email" href="mailto:<?php echo sanitize_email($fortune_theme_options['contact_email']);?>"><?php echo sanitize_email($fortune_theme_options['contact_email']);?></a>
						</span>
						<?php } ?>
					</div><?php
					} ?>
			</div>
		</div><?php } ?>
			<div class="header-main" <?php if(has_header_image()) echo 'style="background-image:url('.get_header_image().');"';?>>
				<div class="container">
					<nav class="navbar navbar-default fhmm" role="navigation">
						<div class="navbar-header">
							<button type="button" class="navbar-toggle">
								<i class="fa fa-bars"></i>
							</button>
							<!-- Logo -->
							<div class="logo">
									<?php if ( function_exists( 'the_custom_logo' )) {
										the_custom_logo();
									} ?>
									
									<?php $description = get_bloginfo( 'description', 'display' );?>
									<?php if ( is_front_page() ) : ?>
										<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
									<?php if($description || is_customize_preview()){ ?>
											<p class="tagline"><?php echo $description; ?></p><?php
										}
									 ?>
									
							</div>
							<!-- Logo / End -->
						</div><!-- end navbar-header -->

						<div id="main-nav" class="navbar-collapse collapse" role="navigation">
						<!-- Menu Goes Here -->
						<?php wp_nav_menu(array(
								'theme_location' => 'primary',
								'container' => false,
								'menu_class' => 'nav navbar-nav',
								'fallback_cb' => 'fortune_fallback_page_menu',
								'walker' => new fortune_nav_walker(),
								)
							); ?>
						</div>
					</nav>
				</div>
			</div>
				
		</header>
		<!-- Header / End -->
		<!-- Main -->
		<div id="site-content" class="main" role="main">