<?php

/* All functions used in theme */
if (!function_exists('fortune_header_style')):
/**
 * Styles the header image and text displayed on the blog.
 *
 * @see fortune_custom_header_setup().
 */
    function fortune_header_style()
{
        $header_text_color = get_header_textcolor();

        // If no custom options for text are set, let's bail.
        // get_header_textcolor() options: add_theme_support( 'custom-header' ) is default, hide text (returns 'blank') or any hex value.
        if (get_theme_support('custom-header', 'default-text-color') === $header_text_color) {
            return;
        }
        ; // If we get this far, we have custom styles. Let's do this.
        ?>
	    <style id="fortune-custom-header-styles" type="text/css">
	    <?php
    // Has the text been hidden?
        if ('blank' === $header_text_color):
        ?>
	        .site-title,
	        .tagline {
	            position: absolute;
	            clip: rect(1px, 1px, 1px, 1px);
	        }
	    <?php
    // If the user has set a custom color for the text use that.
    else:
    ?>
        .site-title a,
        .fhmm .navbar-collapse .navbar-nav > li > a {
            color: #<?php echo esc_attr($header_text_color); ?>;
        }
        @media (min-width: 992px){
            .fhmm .navbar-collapse .navbar-nav > li.current_page_item > a:before, .fhmm .navbar-collapse .navbar-nav > li.current_page_item > a:hover:before, .fhmm .navbar-collapse .navbar-nav > li.current_page_item > a:focus:before,
            .fhmm .navbar-collapse .navbar-nav > li > a:hover:before, .fhmm .navbar-collapse .navbar-nav > li > a:focus:before,
            header.menu-pills .fhmm .navbar-nav > li:not(.current_page_item) > a:hover, header.menu-pills .fhmm .navbar-nav > li:not(.current_page_item) > a:focus,
            header.menu-colored .fhmm .navbar-nav > li:not(.current_page_item) > a:hover, header.menu-colored .fhmm .navbar-nav > li:not(.current_page_item) > a:focus,header.menu-colored .fhmm .navbar-nav > li.open > a,
            header.menu-pills .fhmm .navbar-nav > li.open > a,
            header.menu-colored .fhmm .navbar-nav > li .dropdown-menu > li > a:hover,.fhmm .navbar-collapse .navbar-nav > li.open > a:before, .fhmm .navbar-collapse .navbar-nav > li.open > a:hover:before, .fhmm .navbar-collapse .navbar-nav > li.open > a:focus:before {
                background: #<?php echo esc_attr($header_text_color); ?>;
            }
            .fhmm .navbar-collapse .navbar-nav > li.current_page_item > a,
            .fhmm .navbar-collapse .navbar-nav > li.current_page_item > a:hover,
            .fhmm .navbar-collapse .navbar-nav > li.current_page_item > a:focus{
                color: #<?php echo esc_attr($header_text_color); ?>;
            }
        }
    <?php endif;?>
    </style>
    <?php
}
endif; // End of fortune_header_style.

// Read more tag to formatting in blog page
function fortune_content_more($read_more)
{
    return '<div class=""><a class="main-button" href="' . get_permalink() . '">' . __('Read More', 'fortune') . ' <i class="fa fa-angle-right"></i></a></div>';
}

add_filter('the_content_more_link', 'fortune_content_more');
// Replaces the excerpt "more" text by a link
function fortune_excerpt_more($more)
{
    return '<footer class="entry-footer">
		<a href="' . esc_url(get_permalink()) . '" class="btn btn-default">' . __('Read More', 'fortune') . '</a>
	</footer>';
}

add_filter('excerpt_more', 'fortune_excerpt_more');

/* Breadcrumbs  */
function fortune_breadcrumbs()
{
    /* === OPTIONS === */
    $text['home'] = __('Home', 'fortune'); // text for the 'Home' link
    $text['category'] = __('Category "%s"', 'fortune'); // text for a category page
    $text['search'] = __('Search Results for "%s" Query', 'fortune'); // text for a search results page
    $text['tag'] = __('Posts Tagged "%s"', 'fortune'); // text for a tag page
    $text['author'] = __('Posted by %s', 'fortune'); // text for an author page
    $text['404'] = __('Error 404', 'fortune'); // text for the 404 page
    $text['page'] = __('Page %s', 'fortune'); // text 'Page N'
    $text['cpage'] = __('Comment Page %s', 'fortune'); // text 'Comment Page N'
    $wrap_before = '<div class="breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList">'; // the opening wrapper tag
    $wrap_after = '</div><!-- .breadcrumbs -->'; // the closing wrapper tag
    $sep = '<span class="breadcrumbs__separator">&nbsp;&nbsp;›&nbsp;&nbsp;</span>'; // separator between crumbs
    $before = '<span class="breadcrumbs__current">'; // tag before the current crumb
    $after = '</span>'; // tag after the current crumb
    $show_on_home = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
    $show_home_link = 1; // 1 - show the 'Home' link, 0 - don't show
    $show_current = 1; // 1 - show current page title, 0 - don't show
    $show_last_sep = 1; // 1 - show last separator, when current page title is not displayed, 0 - don't show
    /* === END OF OPTIONS === */
    global $post;
    $home_url = home_url('/');
    $link = '<span itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">';
    $link .= '<a class="breadcrumbs__link" href="%1$s" itemprop="item"><span itemprop="name">%2$s</span></a>';
    $link .= '<meta itemprop="position" content="%3$s" />';
    $link .= '</span>';
    $parent_id = ($post) ? $post->post_parent : '';
    $home_link = sprintf($link, $home_url, $text['home'], 1);
    if (is_home() || is_front_page()) {
        if ($show_on_home) {
            echo $wrap_before . $home_link . $wrap_after;
        }

    } else {
        $position = 0;
        echo $wrap_before;
        if ($show_home_link) {
            $position += 1;
            echo $home_link;
        }
        if (is_category()) {
            $parents = get_ancestors(get_query_var('cat'), 'category');
            foreach (array_reverse($parents) as $cat) {
                $position += 1;
                if ($position > 1) {
                    echo $sep;
                }

                echo sprintf($link, get_category_link($cat), get_cat_name($cat), $position);
            }
            if (get_query_var('paged')) {
                $position += 1;
                $cat = get_query_var('cat');
                echo $sep . sprintf($link, get_category_link($cat), get_cat_name($cat), $position);
                echo $sep . $before . sprintf($text['page'], get_query_var('paged')) . $after;
            } else {
                if ($show_current) {
                    if ($position >= 1) {
                        echo $sep;
                    }

                    echo $before . sprintf($text['category'], single_cat_title('', false)) . $after;
                } elseif ($show_last_sep) {
                    echo $sep;
                }

            }
        } elseif (is_search()) {
            if (get_query_var('paged')) {
                $position += 1;
                if ($show_home_link) {
                    echo $sep;
                }

                echo sprintf($link, $home_url . '?s=' . get_search_query(), sprintf($text['search'], get_search_query()), $position);
                echo $sep . $before . sprintf($text['page'], get_query_var('paged')) . $after;
            } else {
                if ($show_current) {
                    if ($position >= 1) {
                        echo $sep;
                    }

                    echo $before . sprintf($text['search'], get_search_query()) . $after;
                } elseif ($show_last_sep) {
                    echo $sep;
                }

            }
        } elseif (is_year()) {
            if ($show_home_link && $show_current) {
                echo $sep;
            }

            if ($show_current) {
                echo $before . get_the_time('Y') . $after;
            } elseif ($show_home_link && $show_last_sep) {
                echo $sep;
            }

        } elseif (is_month()) {
            if ($show_home_link) {
                echo $sep;
            }

            $position += 1;
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y'), $position);
            if ($show_current) {
                echo $sep . $before . get_the_time('F') . $after;
            } elseif ($show_last_sep) {
                echo $sep;
            }

        } elseif (is_day()) {
            if ($show_home_link) {
                echo $sep;
            }

            $position += 1;
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y'), $position) . $sep;
            $position += 1;
            echo sprintf($link, get_month_link(get_the_time('Y'), get_the_time('m')), get_the_time('F'), $position);
            if ($show_current) {
                echo $sep . $before . get_the_time('d') . $after;
            } elseif ($show_last_sep) {
                echo $sep;
            }

        } elseif (is_single() && !is_attachment()) {
            if (get_post_type() != 'post') {
                $position += 1;
                $post_type = get_post_type_object(get_post_type());
                if ($position > 1) {
                    echo $sep;
                }

                echo sprintf($link, get_post_type_archive_link($post_type->name), $post_type->labels->name, $position);
                if ($show_current) {
                    echo $sep . $before . get_the_title() . $after;
                } elseif ($show_last_sep) {
                    echo $sep;
                }

            } else {
                $cat = get_the_category();
                if (!empty($cat)) {
                    $catID = $cat[0]->cat_ID;
                    $parents = get_ancestors($catID, 'category');
                    $parents = array_reverse($parents);
                    $parents[] = $catID;
                    foreach ($parents as $cat) {
                        $position += 1;
                        if ($position > 1) {
                            echo $sep;
                        }

                        echo sprintf($link, get_category_link($cat), get_cat_name($cat), $position);
                    }
                }
                if (get_query_var('cpage')) {
                    $position += 1;
                    echo $sep . sprintf($link, get_permalink(), get_the_title(), $position);
                    echo $sep . $before . sprintf($text['cpage'], get_query_var('cpage')) . $after;
                } else {
                    if ($show_current) {
                        echo $sep . $before . get_the_title() . $after;
                    } elseif ($show_last_sep) {
                        echo $sep;
                    }

                }
            }
        } elseif (is_post_type_archive()) {
            $post_type = get_post_type_object(get_post_type());
            if (get_query_var('paged')) {
                $position += 1;
                if ($position > 1) {
                    echo $sep;
                }

                echo sprintf($link, get_post_type_archive_link($post_type->name), $post_type->label, $position);
                echo $sep . $before . sprintf($text['page'], get_query_var('paged')) . $after;
            } else {
                if ($show_home_link && $show_current) {
                    echo $sep;
                }

                if ($show_current) {
                    echo $before . $post_type->label . $after;
                } elseif ($show_home_link && $show_last_sep) {
                    echo $sep;
                }

            }
        } elseif (is_attachment()) {
            $parent = get_post($parent_id);
            $cat = get_the_category($parent->ID);
            $catID = $cat[0]->cat_ID;
            $parents = get_ancestors($catID, 'category');
            $parents = array_reverse($parents);
            $parents[] = $catID;
            foreach ($parents as $cat) {
                $position += 1;
                if ($position > 1) {
                    echo $sep;
                }

                echo sprintf($link, get_category_link($cat), get_cat_name($cat), $position);
            }
            $position += 1;
            echo $sep . sprintf($link, get_permalink($parent), $parent->post_title, $position);
            if ($show_current) {
                echo $sep . $before . get_the_title() . $after;
            } elseif ($show_last_sep) {
                echo $sep;
            }

        } elseif (is_page() && !$parent_id) {
            if ($show_home_link && $show_current) {
                echo $sep;
            }

            if ($show_current) {
                echo $before . get_the_title() . $after;
            } elseif ($show_home_link && $show_last_sep) {
                echo $sep;
            }

        } elseif (is_page() && $parent_id) {
            $parents = get_post_ancestors(get_the_ID());
            foreach (array_reverse($parents) as $pageID) {
                $position += 1;
                if ($position > 1) {
                    echo $sep;
                }

                echo sprintf($link, get_page_link($pageID), get_the_title($pageID), $position);
            }
            if ($show_current) {
                echo $sep . $before . get_the_title() . $after;
            } elseif ($show_last_sep) {
                echo $sep;
            }

        } elseif (is_tag()) {
            if (get_query_var('paged')) {
                $position += 1;
                $tagID = get_query_var('tag_id');
                echo $sep . sprintf($link, get_tag_link($tagID), single_tag_title('', false), $position);
                echo $sep . $before . sprintf($text['page'], get_query_var('paged')) . $after;
            } else {
                if ($show_home_link && $show_current) {
                    echo $sep;
                }

                if ($show_current) {
                    echo $before . sprintf($text['tag'], single_tag_title('', false)) . $after;
                } elseif ($show_home_link && $show_last_sep) {
                    echo $sep;
                }

            }
        } elseif (is_author()) {
            $author = get_userdata(get_query_var('author'));
            if (get_query_var('paged')) {
                $position += 1;
                echo $sep . sprintf($link, get_author_posts_url($author->ID), sprintf($text['author'], $author->display_name), $position);
                echo $sep . $before . sprintf($text['page'], get_query_var('paged')) . $after;
            } else {
                if ($show_home_link && $show_current) {
                    echo $sep;
                }

                if ($show_current) {
                    echo $before . sprintf($text['author'], $author->display_name) . $after;
                } elseif ($show_home_link && $show_last_sep) {
                    echo $sep;
                }

            }
        } elseif (is_404()) {
            if ($show_home_link && $show_current) {
                echo $sep;
            }

            if ($show_current) {
                echo $before . $text['404'] . $after;
            } elseif ($show_last_sep) {
                echo $sep;
            }

        } elseif (has_post_format() && !is_singular()) {
            if ($show_home_link && $show_current) {
                echo $sep;
            }

            echo get_post_format_string(get_post_format());
        }
        echo $wrap_after;
    }
}
/* add a class to avatar */
add_filter('get_avatar', 'fortune_change_avatar_css');
function fortune_change_avatar_css($class)
{
    $class = str_replace("class='avatar", "class='gravatar ", $class);
    return $class;
}
/* change class of comment reply link */
add_filter('comment_reply_link', 'fortune_replace_reply_link_class');
function fortune_replace_reply_link_class($class)
{
    $class = str_replace("class='comment-reply-link", "class='btn btn-sm btn-default", $class);
    return $class;
}
function fortune_comments($comments, $args, $depth)
{
    $GLOBALS['comment'] = $comments;
    extract($args, EXTR_SKIP);
    if ('div' == $args['style']) {
        $tag = 'div';
        $add_below = 'comment';
    } else {
        $tag = 'li';
        $add_below = 'div-comment';
    }
    ?>
    <li  <?php comment_class("comment");?>>
        <div class="comment-wrapper">
            <div class="comment-author vcard"><?php
            if ($args['avatar_size'] != 0) {
                echo get_avatar($comments, $args['avatar_size']);
            }?>
            <h5><?php printf('%s', esc_attr(get_comment_author()));?></h5>
            <span class="says"><?php _e('says:', 'fortune');?></span>
            <div class="comment-meta">
                <a href="<?php echo esc_url(get_comment_link($comments, $args)); ?>">
                    <?php
                    /* translators: 1: comment date, 2: comment time */
                    $comment_timestamp = sprintf(__('%1$s at %2$s', 'fortune'), get_comment_date('', $comments), get_comment_time());
                    ?>
                    <time datetime="<?php comment_time('c');?>" title="<?php echo $comment_timestamp; ?>">
                        <?php echo $comment_timestamp; ?>
                    </time>
                </a>
                - <i class="fa fa-pencil"></i> <?php edit_comment_link();?>
            </div>
            </div><?php
            if ($comments->comment_approved != '0') {?>
                <div class="comment-reply"> <?php comment_reply_link(array_merge($args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'])));?> </div>
                <div class="comment-body"><?php comment_text();?></div><?php
            } else {
                echo '<p>' . __('Your comment is awaitting for moderation.', 'fortune') . '</p>';
            }?>
        </div>
    <?php
}
/* Blog Pagination */
if (!function_exists('fortune_pagination')) {
    function fortune_pagination()
    {
        global $wp_query;
        $big = 999999999; // need an unlikely integer
        $pages = paginate_links(array(
            'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format'    => '?paged=%#%',
            'current'   => max(1, get_query_var('paged')),
            'total'     => $wp_query->max_num_pages,
            'prev_next' => false,
            'type'      => 'array',
            'prev_next' => true,
            'prev_text' => '&#171;',
            'next_text' => '&#187;',
        ));
        if (is_array($pages)) {
            $paged = (get_query_var('paged') == 0) ? 1 : get_query_var('paged');
            echo '<div class="text-center"><ul class="pagination-custom list-unstyled list-inline">';
            foreach ($pages as $page) {
                $page = str_replace('page-numbers', 'btn btn-sm btn-default', $page);
                echo "<li>$page</li>";
            }
            echo '</ul></div>';
        }
    }
}

if (!function_exists('fortune_posted_on')):
    /**
     * Prints HTML with meta information for the current post-date/time.
     */
    function fortune_posted_on()
{
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
        if (get_the_time('U') !== get_the_modified_time('U')) {
            $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
        }

        $time_string = sprintf(
            $time_string,
            esc_attr(get_the_date(DATE_W3C)),
            esc_html(get_the_date()),
            esc_attr(get_the_modified_date(DATE_W3C)),
            esc_html(get_the_modified_date())
        );

        printf(
            '<span class="posted-on">%1$s <a href="%2$s" rel="bookmark">%3$s</a></span>',
            esc_html__('On', 'fortune'),
            esc_url(get_permalink()),
            $time_string
        );
    }
endif;

/* TGMPA register */
add_action('tgmpa_register', 'fortune_register_required_plugins');
function fortune_register_required_plugins()
{
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        // This is an example of how to include a plugin bundled with a theme.
        array(
            'name'     => 'Kirki', // The plugin name.
            'slug'     => 'kirki', // The plugin slug (typically the folder name).
            'required' => false, // If false, the plugin is only 'recommended' instead of required.
        ),

        array(
            'name'     => 'Fusion Slider', // The plugin name.
            'slug'     => 'fusion-slider', // The plugin slug (typically the folder name).
            'required' => false, // If false, the plugin is only 'recommended' instead of required.
        ),

        array(
            'name'     => 'Photo Video Gallery Master', // The plugin name.
            'slug'     => 'photo-video-gallery-master', // The plugin slug (typically the folder name).
            'required' => false, // If false, the plugin is only 'recommended' instead of required.
        ),
        array(
            'name'     => 'Ultimate Gallery Master', // The plugin name.
            'slug'     => 'ultimate-gallery-master', // The plugin slug (typically the folder name).
            'required' => false, // If false, the plugin is only 'recommended' instead of required.
        ),
        array(
            'name'     => 'Social Media Gallery', // The plugin name.
            'slug'     => 'social-media-gallery', // The plugin slug (typically the folder name).
            'required' => false, // If false, the plugin is only 'recommended' instead of required.
        ),
    );
    $config = array(
        'id'           => 'fortune', // Unique ID for hashing notices for multiple instances of fortune.
        'default_path' => '', // Default absolute path to bundled plugins.
        'menu'         => 'fortune-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php', // Parent menu slug.
        'capability'   => 'edit_theme_options', // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true, // Show admin notices or not.
        'dismissable'  => true, // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '', // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false, // Automatically activate plugins after installation or not.
        'message'      => '', // Message to output right before the plugins table.
    );
    tgmpa($plugins, $config);
}

/* Woocommerce supoport */
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
add_action('woocommerce_before_main_content', 'fortune_theme_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'fortune_theme_wrapper_end', 10);
function fortune_theme_wrapper_start()
{
    ?>
    <section class="page-heading">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <?php if (!is_product()): ?>
                    <h1><?php woocommerce_page_title();?></h1>
                <?php else:
        woocommerce_template_single_title();
    endif;?>
            </div>
            <div class="col-md-6">
                <?php fortuneBreadcrumbs();?>
            </div>
        </div>
    </div>
    </section><?php
echo '<section class="page-content">
            <div class="container">
                <div class="row">
                    <div class="col-md-8">';
}
function fortune_theme_wrapper_end()
{ ?>
    </div><?php get_sidebar();?></div></div>
    </section>
<?php }
add_filter('woocommerce_show_page_title', 'fortune_hide_page_title');
/**
 * fortune_hide_page_title
 *
 * Removes the "shop" title on the main shop page
 */
function fortune_hide_page_title()
{
    return false;
}
/**
 * Removes breadcrumbs
 */
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
/** Remove Showing results functionality site-wide */
function woocommerce_result_count()
{
    return;
}

add_filter('get_product_search_form', 'fortune_custom_product_searchform');

/**
 * fortune_custom_product_searchform
 *
 * @access      public
 * @since       1.0
 * @return      void
 */
function fortune_custom_product_searchform($form)
{
    $form = '<form action="' . esc_url(home_url("/")) . '" role="search" method="get" class="woocommerce-product-search">
	  <div class="input-group">
		<input type="text" value="' . get_search_query() . '" name="s" id="s" class="form-control" placeholder="' . __("Search Product...", "fortune") . '">
		<span class="input-group-btn">
		<button id="searchsubmit" class="btn btn-primary" type="submit"><i class="fa fa-search"></i></button>
		<input type="hidden" name="post_type" value="product" />
		</span> </div>
	</form>';
    return $form;

}

/**
 * Adjust a hex color brightness
 * Allows us to create hover styles for custom link colors
 *
 * @param  strong  $hex   hex color e.g. #111111.
 * @param  integer $steps factor by which to brighten/darken ranging from -255 (darken) to 255 (brighten).
 * @return string        brightened/darkened hex color
 * @since  1.0.0
 */
function fortune_adjust_color_brightness($hex, $steps)
{
    // Steps should be between -255 and 255. Negative = darker, positive = lighter.
    $steps = max(-255, min(255, $steps));
    // Format the hex color string.
    $hex = str_replace('#', '', $hex);
    if (3 == strlen($hex)) {
        $hex = str_repeat(substr($hex, 0, 1), 2) . str_repeat(substr($hex, 1, 1), 2) . str_repeat(substr($hex, 2, 1), 2);
    }
    // Get decimal values.
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));
    // Adjust number of steps and keep it inside 0 to 255.
    $r = max(0, min(255, $r + $steps));
    $g = max(0, min(255, $g + $steps));
    $b = max(0, min(255, $b + $steps));
    $r_hex = str_pad(dechex($r), 2, '0', STR_PAD_LEFT);
    $g_hex = str_pad(dechex($g), 2, '0', STR_PAD_LEFT);
    $b_hex = str_pad(dechex($b), 2, '0', STR_PAD_LEFT);
    return '#' . $r_hex . $g_hex . $b_hex;
}
/**
 * Output Post Format icons
 *
 * Outputs an icon for each post format. Set up to use Fontawesome,
 * but can be used with anything, or you can just use CSS.
 *
 * @return string
 */
function fortune_post_format_icon()
{
    global $post;
    // get current post ID
    $id = $post->ID;
    // get post format
    $format = get_post_format($id);
    // array of icons as $format => $icon key/value pairs
    $icons = [
        'standard' => 'fa-pencil',
        'aside'    => 'fa-sticky-note',
        'chat'     => 'fa-comments',
        'gallery'  => 'fa-picture-o',
        'link'     => 'fa-external-link',
        'image'    => 'fa-camera',
        'quote'    => 'fa-quote-left',
        'status'   => 'fa-commenting',
        'video'    => 'fa-video-camera',
        'audio'    => 'fa-file-audio-o',
    ];
    // format will return false if no format is set. So, evaluate against this..
    // if format = false then $icon = standard, else icon = selected format
    $format == (false) ? $icon = $icons['standard'] : $icon = $icons[$format];

    // string to be output
    // echo a full line of html or just drop the output in as a class
    $output = $icon;
    // return the output
    return $output;
}
/**
 * @since [2.0.3]
 * [fortune_get_option Get theme option value]
 * @param  [type] $key [Option key]
 * @return [type]      [Option value]
 */
function fortune_get_option($key){
    if(empty($key)) return;
    $fortune_theme_options = get_option('fortune_theme_options');
    return isset($fortune_theme_options[$key]) ? $fortune_theme_options[$key] : '';
}