<?php
/** Theme Name: fortune
 *  Theme Core Functions and Codes
 **/

require get_template_directory() . '/functions/menu/default_menu_walker.php';
require get_template_directory() . '/functions/menu/fortune_nav_walker.php';
require get_template_directory(). '/inc/icon-functions.php';
require_once dirname(__FILE__) . '/default_options.php';
require_once get_template_directory() . '/inc/class-tgm-plugin-activation.php';
require get_template_directory() . '/functions/customize/contact-widgets.php';
include get_template_directory() . '/inc/dashboard.php';
include get_template_directory() . '/inc/include-kirki.php';
include get_template_directory() . '/inc/class-fortune-kirki.php';
include get_template_directory() . '/functions/fortune-functions.php';
function fortune_customizer_config()
{
    $args = array(
        'capability'   => 'edit_theme_options',
        'option_type'  => 'option',
        'option_name'  => 'fortune_theme_options',
        'compiler'     => array(),
        'width'        => '22.3%',
        'description'  => __('Visit our site for more great Products.If you like this theme please rate us 5 star', 'fortune'),
    );
    return $args;
}

add_filter('kirki/config', 'fortune_customizer_config');
require get_template_directory() . '/customizer.php';
add_action('after_setup_theme', 'fortune_theme_setup');
add_action('after_setup_theme', 'fortune_check_theme_version');
global $fortune_theme_options;
function fortune_theme_setup()
{
    global $content_width;
    //content width
    if (!isset($content_width)) {
        $content_width = 704;
    }
    //supports featured image
    add_theme_support('post-thumbnails');
    load_theme_textdomain('fortune', get_template_directory() . '/lang');
    // image resize according to image layout
    add_image_size('fortune_blog_thumb', 280, 270, true);
    add_image_size('fortune_home_post_thumb', 276, 200, true);
    add_image_size('fortune_portfolio_thumb', 358, 258, true);
    add_image_size('fortune_slider', 1349, 530, true);
    add_image_size('fortune_page_thumb', 346, 332, true);
    add_image_size('fortune_post_single', 704, 328, true);
    // Add theme support for selective refresh for widgets.
    add_theme_support( 'customize-selective-refresh-widgets' );
    // This theme uses wp_nav_menu() in Three locations.
    register_nav_menus( array(
        'primary'    => __( 'Primary menu', 'fortune' ),
        'secondary' => __( 'Topbar Menu', 'fortune' ),
        'social' => __( 'Social Links Menu', 'fortune' ),
    ) );
    // theme support
    $args = array('default-color' => '#ffffff');
    add_theme_support('custom-background', $args);
    $args1 = array(
        'width'         => 1300,
        'flex-height'    => true,
        'height'        => 115,
        'default-image' => '',
        'header-text-color'=>'#656464',
        'header-text' => true,
        'wp-head-callback'   => 'fortune_header_style',
    );
    add_theme_support('custom-header',$args1);
    add_theme_support('automatic-feed-links');
    add_theme_support('title-tag');
    add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
    add_theme_support( 'custom-logo', array(
        'height'      => 50,
        'width'       => 150,
        'flex-width'  => true,
    ) );
    /* WooCommerce Support */
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');

    // Add support for Block Styles.
    add_theme_support( 'wp-block-styles' );

    // Add support for full and wide align images.
    add_theme_support( 'align-wide' );

    // Add support for editor styles.
    add_theme_support( 'editor-styles' );

    // Enqueue editor styles.
    add_editor_style('css/editor-style.css');
    // Recommend plugins
    add_theme_support( 'recommend-plugins', array(
        'kirki'=>array(
            'name'     => 'Kirki', // The plugin name.
            'active_filename' => 'kirki/kirki.php',
        ),
        'fusion-slider'=>array(
            'name'     => 'Universal Slider', // The plugin name.
            'active_filename' => 'fusion-slider/fusion-slider.php',
        ),
        'photo-video-gallery-master'=>array(
            'name'     => 'Photo Video Gallery Master', // The plugin name.
            'active_filename' => 'photo-video-gallery-master/photo-video-gallery-master.php',
        ),
        'ultimate-gallery-master'=>array(
            'name'     => 'Ultimate Gallery Master', // The plugin name.
            'active_filename' => 'ultimate-gallery-master/ultimate-gallery-master-lite.php',
        ),
        'social-media-gallery'=>array(
            'name'     => 'Social Media Gallery', // The plugin name.
            'active_filename' => 'social-media-gallery/social-media-gallery.php',
        ),

    ) );
    /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.
     */
    add_theme_support( 'html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ) );

    /*
     * Enable support for Post Formats.
     * See https://developer.wordpress.org/themes/functionality/post-formats/
     */
    add_theme_support( 'post-formats', array(
        'aside',
        'image',
        'video',
        'quote',
        'link',
        'gallery',
        'audio',
    ) );

    add_theme_support( 'starter-content', array(

        'posts' => array(
            'home' => array(
                'template'	=> 'home-page.php',
            ),
            'about' => array(
                'thumbnail' => '{{image-sandwich}}',
            ),
            'contact' => array(
                'thumbnail' => '{{image-espresso}}',
            ),
            'blog' => array(
                'thumbnail' => '{{image-coffee}}',
            )
        ),

        'options' => array(
            'show_on_front' => 'page',
            'page_on_front' => '{{home}}',
            'page_for_posts' => '{{blog}}',
        ),
        'widgets' => array(
            'sidebar-widget' => array(
                'search',
                'text_business_info',
                'text_about',
                'category',
                'tags',
            ),

            'footer-widget' => array(
                'text_business_info',
                'text_about',
                'meta',
                'search',
            ),
        ),

        'nav_menus' => array(
            'primary' => array(
                'name' => __( 'Primary Menu', 'fortune' ),
                'items' => array(
                    'page_home',
                    'page_about',
                    'page_blog',
                    'page_contact',
                ),
            ),
            'secondary' => array(
                'name' => __( 'Top Menu', 'fortune' ),
                'items' => array(
                    'page_home',
                    'page_about',
                    'page_blog',
                    'page_contact',
                ),
            ),
            'social' => array(
                'name' => __( 'Social Links Menu', 'fortune' ),
                'items' => array(
                    'link_yelp',
                    'link_facebook',
                    'link_twitter',
                    'link_instagram',
                    'link_email',
                ),
            ),
        ),
    ) );
}

add_action('wp_enqueue_scripts', 'fortune_enqueue_style');
function fortune_enqueue_style(){
    $fortune_theme_options = fortune_theme_options();
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.css');
    wp_enqueue_style('fortune', get_stylesheet_uri());
    wp_enqueue_style('elements-styles', get_template_directory_uri() . '/css/elements-styles.css');
    if(get_theme_mod('color_scheme')!=""){
        wp_enqueue_style('site-color-scheme', get_template_directory_uri() . '/css/skins/'.get_theme_mod('color_scheme'));
    }
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/css/fonts/font-awesome/css/font-awesome.css');
    wp_enqueue_style('owl.carousel', get_template_directory_uri() . '/vendor/owl-carousel/owl.carousel.css');
    wp_enqueue_style('owl.theme', get_template_directory_uri() . '/vendor/owl-carousel/owl.theme.css');
    wp_enqueue_style('magnific-popup', get_template_directory_uri() . '/vendor/magnific-popup/magnific-popup.css');
    wp_enqueue_style('animate', get_template_directory_uri() . '/css/animate.css');
    $fortune_header_bg_color_bottom = get_theme_mod('fortune_header_bg_color_bottom','');
    $fortune_header_bg_color_top = get_theme_mod('fortune_header_bg_color_top','');
    $fortune_callout_bg_color = get_theme_mod('fortune_callout_bg_color','');
    $fortune_topbar_bg_color = get_theme_mod('fortune_topbar_bg_color','');
    $fortune_cusotm_css = '';
    if($fortune_topbar_bg_color!=""){
        $fortune_topbar_bright_color = sanitize_hex_color(fortune_adjust_color_brightness($fortune_topbar_bg_color,100));
        $fortune_cusotm_css .='.header-top{background:'.sanitize_hex_color($fortune_topbar_bg_color).';}
                                .header-top a:hover{border-bottom-color: '.$fortune_topbar_bright_color.';}.header-top{color:'.$fortune_topbar_bright_color.';}.header-top .header-top-nav > li > a:after{background:'.$fortune_topbar_bright_color.';}';
    }
    if($fortune_header_bg_color_bottom!=""){
        $fortune_cusotm_css .= '
            .header-main {
                background: '.$fortune_header_bg_color_bottom.';
            }';
    }
    if($fortune_header_bg_color_top!=""){
        $fortune_cusotm_css .= '
        .header-main:before{
            background-image: -webkit-linear-gradient(top,'.sanitize_hex_color($fortune_header_bg_color_top).' 0%, rgba(255, 255, 255, 0) 100%);
            background-image: linear-gradient(to bottom, '.sanitize_hex_color($fortune_header_bg_color_top).' 0%, rgba(255, 255, 255, 0) 100%);
        }';
    }
        if($fortune_callout_bg_color!=""){
            $fortune_cusotm_css .='section#callout{background:'.sanitize_hex_color($fortune_callout_bg_color).' !important}';
        }
        if($fortune_theme_options['footer_bg_color']!=""){
            $fortune_cusotm_css .='.footer .footer-widgets{background:'.sanitize_hex_color($fortune_theme_options['footer_bg_color']).'}';
        }
        if($fortune_theme_options['footer_2_bg_color']!=""){
            $fortune_footer_2_bright_color = sanitize_hex_color(fortune_adjust_color_brightness($fortune_theme_options['footer_2_bg_color'],20));
            $fortune_cusotm_css .='.footer .footer-copyright{background:'.sanitize_hex_color($fortune_theme_options['footer_2_bg_color']).'}';
            $fortune_cusotm_css .='.footer .footer-copyright{border-top:1px solid '.sanitize_hex_color(fortune_adjust_color_brightness($fortune_theme_options['footer_2_bg_color'],-50)).'}';
            $fortune_cusotm_css .='.social-links > li > a{background:'.$fortune_footer_2_bright_color.' !important; border: 1px solid '.sanitize_hex_color(fortune_adjust_color_brightness($fortune_theme_options['footer_2_bg_color'],-10)).' !important;color:#fff !important;}';
            $fortune_cusotm_css .='.social-links > li > a:hover{background:#fff !important;color:'.$fortune_footer_2_bright_color.' !important}';
            $fortune_cusotm_css .='#f-copyright a:hover{color:'.sanitize_hex_color(fortune_adjust_color_brightness($fortune_theme_options['footer_2_bg_color'],150)).'}';
        }
        wp_add_inline_style('fortune',$fortune_cusotm_css);
        if (is_singular()) {
            wp_enqueue_script("comment-reply");
        }
    wp_enqueue_style('Goudy', '//fonts.googleapis.com/css?family=Goudy+Bookletter+1911&text=&');
    wp_enqueue_style('antom','//fonts.googleapis.com/css?family=Anton|Muli:300,400,400italic,300italic|Oswald');
}

add_action('wp_footer', 'fortune_enqueue_in_footer');
function fortune_enqueue_in_footer()
{	
    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/vendor/bootstrap.js', array('jquery'));
    wp_enqueue_script('headhesive.js', get_template_directory_uri() . '/vendor/headhesive.js', array('jquery'));
    wp_enqueue_script('jquery.magnific-popup', get_template_directory_uri() . '/vendor/magnific-popup/jquery.magnific-popup.js', array('jquery'));
    if(class_exists('WooCommerce')){
        if(is_shop() || is_cart() || is_product() || is_checkout() || is_product_category()){
            wp_enqueue_script('jquery.dcjqaccordion', get_template_directory_uri() . '/vendor/jquery.dcjqaccordion.js', array('jquery'));
            $dcjq ='  jQuery(".product-categories").dcAccordion({
					saveState: false,
					autoExpand: true,
					showCount: true,
				});
			jQuery(".dcjq-icon").click(function(){
				jQuery(this).toggleClass("less");
			});';
            wp_add_inline_script('jquery.dcjqaccordion',$dcjq);
        }
    }
    $fortune_sticky_header = get_theme_mod('fortune_sticky_header', 0);
    $fortune_slider_auto_play = get_theme_mod('fortune_slider_auto_play', 1);

    wp_enqueue_script('owl.carousel', get_template_directory_uri() . '/vendor/owl-carousel/owl.carousel.js', array('jquery'));
    wp_enqueue_script('jquery.fitvids', get_template_directory_uri() . '/vendor/jquery.fitvids.js', array('jquery'));
    wp_enqueue_script('jquery.appear', get_template_directory_uri() . '/vendor/jquery.appear.js', array('jquery'));
    wp_enqueue_script('jquery.easing', get_template_directory_uri() . '/vendor/jquery.easing.1.3.js', array('jquery'));
    wp_enqueue_script('fortune-custom', get_template_directory_uri() . '/vendor/custom.js', array('jquery'));
    wp_localize_script('fortune-custom','fortune_obj',array(
        'is_sticky'=>$fortune_sticky_header,
        'auto_play'=> $fortune_slider_auto_play,

    ));

    wp_enqueue_script('modernizr', get_template_directory_uri() . '/vendor/modernizr.js', array('jquery'));
    wp_enqueue_script ('htmlshiv', get_template_directory_uri() . '/vendor/htmlshiv.js');
    wp_script_add_data( 'htmlshiv', 'conditional', 'lt IE 9' );
    wp_enqueue_script ('respond', get_template_directory_uri() . '/vendor/respond.js');
    wp_script_add_data( 'respond', 'conditional', 'lt IE 9' );

}

/*
 * fortune widget area
 */
add_action('widgets_init', 'fortune_widget');
function fortune_widget()
{
    /*sidebar*/
    $fortune_theme_options = fortune_theme_options();
    $col                = (int) $fortune_theme_options['footer_layout'];
    register_sidebar(array(
        'name'          => __('Sidebar Widget Area', 'fortune'),
        'id'            => 'sidebar-widget',
        'description'   => __('Sidebar widget area', 'fortune'),
        'before_widget' => '<div id="%1$s" class="%2$s widget widget__sidebar">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
    register_sidebar(array(
        'name'          => __('Footer Widget Area', 'fortune'),
        'id'            => 'footer-widget',
        'description'   => __('Footer widget area', 'fortune'),
        'before_widget' => '<div id="%1$s" class="%2$s col-sm-6 col-md-'.$col.'">
								<div class=" widget widget__footer">',
        'after_widget'  => '</div></div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
}

function fortune_check_theme_version() {

  $current_version = wp_get_theme()->get('Version');
  $old_version = get_option( 'fortune_theme_version' );

  if ($old_version !== $current_version) {
    // do some cool stuff

    // update not to run twice
    update_option('fortune_theme_version', $current_version);
  }
}
add_action('switch_theme', 'fortune_options_removal');

function fortune_options_removal () {
  delete_option('fortune_theme_version');
}