<?php
if (class_exists('Kirki')) {
    include 'customizer-extra.php';
}
add_action('customize_register', 'fortuneCustomizer');
function fortuneCustomizer($wp_customize)
{
    $fortune_theme_options = fortune_theme_options();
    wp_enqueue_style('custom_css', get_template_directory_uri() . '/css/customizer.css');
    $j = array('', __(' One', 'fortune'), __(' Two', 'fortune'), __(' Three', 'fortune'));
    /* set selctive refresh for existing control */
    //$wp_customize->get_setting('header_textcolor')->transport = 'postMessage';
    $wp_customize->get_setting('blogdescription')->transport = 'postMessage';
    $wp_customize->get_setting('blogname')->transport        = 'postMessage';

    $wp_customize->selective_refresh->add_partial('blogname', array(
        'selector'        => '.site-title',
        'render_callback' => 'fortune_get_site_name',
    ));
    $wp_customize->selective_refresh->add_partial('blogdescription', array(
        'selector'        => '.tagline',
        'render_callback' => 'fortune_get_site_description',
    ));

    /* add topbar color control in color section */
    $wp_customize->add_setting('fortune_topbar_bg_color',
        array(
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'fortune_topbar_bg_color',
            array(
                'label'    => __('Top bar background color', 'fortune'),
                'section'  => 'colors',
                'settings' => 'fortune_topbar_bg_color',
            ))
    );
    /* header radiant color */
    $wp_customize->add_setting('fortune_header_radiant_color', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Fortune_Customize_Heading($wp_customize, 'fortune_header_radiant_color', array(
        'label'   => __('Header Radiant color', 'fortune'),
        'section' => 'colors',
    )));
    /* header color bottom*/
    $wp_customize->add_setting('fortune_header_bg_color_bottom',
        array(
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'fortune_header_bg_color_bottom',
            array(
                'label'    => __('Header bottom color', 'fortune'),
                'section'  => 'colors',
                'settings' => 'fortune_header_bg_color_bottom',
            ))
    );
    /* header color top*/
    $wp_customize->add_setting('fortune_header_bg_color_top',
        array(
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'fortune_header_bg_color_top',
            array(
                'label'    => __('Header top color', 'fortune'),
                'section'  => 'colors',
                'settings' => 'fortune_header_bg_color_top',
            ))
    );

    /* Genral section */
    $wp_customize->add_panel('fortune_theme_option', array(
        'title'    => __('Theme Options', 'fortune'),
        'priority' => 2, // Mixed with top-level-section hierarchy.
    ));
    /* General section */
    $wp_customize->add_section('general_sec',
        array(
            'title'      => __('General Section', 'fortune'),
            'panel'      => 'fortune_theme_option',
            'capability' => 'edit_theme_options',
            'priority'   => 30, // Mixed with top-level-section hierarchy.
        )
    );
    /* color scheme */
    $wp_customize->add_setting('color_scheme',
        array(
            'sanitize_callback' => 'fortune_sanitize_select',
            'default'           => '',
        )
    );

    $wp_customize->add_control('color_scheme', array(
        'label'    => __('Color Scheme', 'fortune'),
        'type'     => 'select',
        'section'  => 'general_sec',
        'settings' => 'color_scheme',
        'choices'  => array(
            ''           => 'Default',
            'blue.css'   => 'Blue',
            'orange.css' => 'Orange',
            'violet.css' => 'Violet',
        ),
    )
    );
    /* site layout */
    $wp_customize->add_setting('fortune_site_layout',
        array(
            'sanitize_callback' => 'fortune_sanitize_select',
            'transport'         => 'postMessage',
            'default'           => '',
        )
    );

    $wp_customize->add_control('fortune_site_layout', array(
        'label'       => __('Site Layout', 'fortune'),
        'description' => __('Change your site layout to full width or boxed size.', 'fortune'),
        'type'        => 'select',
        'section'     => 'general_sec',
        'settings'    => 'fortune_site_layout',
        'choices'     => array(
            ''      => __('Full Width Layout', 'fortune'),
            'boxed' => __('Box Width Layout', 'fortune'),
        ),
    )
    );

    $wp_customize->add_setting('fortune_header_nav_heading', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Fortune_Customize_Heading($wp_customize, 'fortune_header_nav_heading', array(
        'label'   => esc_html__('Header / Header Navigation ', 'fortune'),
        'section' => 'general_sec',
    )));

    $wp_customize->add_setting('fortune_sticky_header',
        array(
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'default'           => 0,
        )
    );
    $wp_customize->add_control('fortune_sticky_header', array(
        'label'       => __('Fixed Header', 'fortune'),
        'description' => __('Switch between fixed and static header', 'fortune'),
        'section'     => 'general_sec',
        'settings'    => 'fortune_sticky_header',
        'type'        => 'checkbox',
    )
    );

    $wp_customize->add_setting('fortune_navigation_style',
        array(
            'sanitize_callback' => 'fortune_sanitize_select',
            'default'           => 'header-default',
        )
    );
    $wp_customize->add_control('fortune_navigation_style', array(
        'label'       => __('Navigation Style', 'fortune'),
        'description' => __('Seelct hedaer navigation menu style.', 'fortune'),
        'section'     => 'general_sec',
        'settings'    => 'fortune_navigation_style',
        'type'        => 'select',
        'choices'     => array(
            'header-default' => esc_html__('Default', 'fortune'),
            'menu-pills'     => esc_html__('Pills', 'fortune'),
            'menu-colored'   => esc_html__('Colored', 'fortune'),
        ),
    )
    );

    $wp_customize->add_setting(
        'fortune_header_nav_color',
        array(
            'default'           => sprintf('<a class="linkToControl" id="header_textcolor" href="#">%s</a>', esc_html__('Go to color section.', 'fortune')),
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'esc_html',
        )
    );
    $wp_customize->add_control(new Fortune_Custom_Customizer_Control($wp_customize, 'fortune_header_nav_color', array(
        'type'    => 'custom',
        'label'   => esc_html__('Header text color ', 'fortune'),
        'section' => 'general_sec',
    )));

    $wp_customize->add_setting('fortune_top_bar_heading', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Fortune_Customize_Heading($wp_customize, 'fortune_top_bar_heading', array(
        'label'   => esc_html__('Top bar options ', 'fortune'),
        'section' => 'general_sec',
    )));

    $wp_customize->add_setting('fortue_show_top_bar',
        array(
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'default'           => 1,
        )
    );
    $wp_customize->add_control('fortue_show_top_bar', array(
        'label'    => __('Show Top bar', 'fortune'),
        'section'  => 'general_sec',
        'settings' => 'fortue_show_top_bar',
        'type'     => 'checkbox',
    )
    );

    /* contact options */
    $wp_customize->add_setting(
        'fortune_theme_options[contact_in_header]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['contact_in_header'],
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->add_control('contact_in_header', array(
        'label'    => __('Show Contact Info in Top bar', 'fortune'),
        'section'  => 'general_sec',
        'settings' => 'fortune_theme_options[contact_in_header]',
        'type'     => 'checkbox',
    )
    );

    $wp_customize->add_setting(
        'fortune_topbar_contact_switch',
        array(
            'default'           => 0,
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->add_control('fortune_topbar_contact_switch', array(
        'label'       => __('Switch topbar content.', 'fortune'),
        'description' => __('Contact info in left and topbar menu in right', 'fortune'),
        'section'     => 'general_sec',
        'settings'    => 'fortune_topbar_contact_switch',
        'type'        => 'checkbox',
    )
    );

    $wp_customize->add_setting(
        'fortune_theme_options[contact_email]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['contact_email'],
            'sanitize_callback' => 'sanitize_email',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->selective_refresh->add_partial('fortune_theme_options[contact_email]', array(
        'selector'        => '.cont_email',
        'render_callback' => 'fortune_partial_refresh_cont_email',
    ));
    $wp_customize->add_control('contact_email', array(
        'label'    => __('Contact Email', 'fortune'),
        'section'  => 'general_sec',
        'settings' => 'fortune_theme_options[contact_email]',
        'type'     => 'text',
    )
    );
    $wp_customize->add_setting(
        'fortune_theme_options[contact_phone]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['contact_phone'],
            'sanitize_callback' => 'esc_attr',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->selective_refresh->add_partial('fortune_theme_options[contact_phone]', array(
        'selector'        => '.cont_phone',
        'render_callback' => 'fortune_partial_refresh_cont_number',
    ));
    $wp_customize->add_control('contact_phone', array(
        'label'    => __('Contact Number', 'fortune'),
        'section'  => 'general_sec',
        'settings' => 'fortune_theme_options[contact_phone]',
        'type'     => 'text',
    )
    );

    $wp_customize->add_setting(
        'fortune_topbar_color',
        array(
            'default'           => sprintf('<a class="linkToControl" id="fortune_topbar_bg_color" href="#">%s</a>', esc_html__('Go to color section.', 'fortune')),
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'esc_html',
        )
    );
    $wp_customize->add_control(new Fortune_Custom_Customizer_Control($wp_customize, 'fortune_topbar_color', array(
        'type'    => 'custom',
        'label'   => esc_html__('Top bar background color ', 'fortune'),
        'section' => 'general_sec',
    )));

    $wp_customize->add_setting(
        'fortune_topbar_menu',
        array(
            'default'           => sprintf('<a class="linkToControl" id="nav_menu_locations[secondary]" href="#">%s</a>', esc_html__('Add topbar menu.', 'fortune')),
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'esc_html',
        )
    );
    $wp_customize->add_control(new Fortune_Custom_Customizer_Control($wp_customize, 'fortune_topbar_menu', array(
        'type'    => 'custom',
        'label'   => esc_html__('Topbar menu ', 'fortune'),
        'section' => 'general_sec',
    )));

    /*********************************/
    $wp_customize->add_section('slider_sec',
        array(
            'title'      => __('Slider Options', 'fortune'),
            'panel'      => 'fortune_theme_option',
            'capability' => 'edit_theme_options',
            'priority'   => 35, // Mixed with top-level-section hierarchy.
        )
    );

    $wp_customize->add_setting('fortune_theme_options[slider_home]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'default'           => $fortune_theme_options['slider_home'],
        )
    );
    $wp_customize->add_control('slider_home', array(
        'label'    => __('Show Slider', 'fortune'),
        'section'  => 'slider_sec',
        'settings' => 'fortune_theme_options[slider_home]',
        'type'     => 'checkbox',
    )
    );

    ///////////
    $wp_customize->add_setting('fortune_slider_auto_play',
        array(
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'default'           => 1,
        )
    );
    $wp_customize->add_control('fortune_slider_auto_play', array(
        'label'    => __('Auto Play Slider', 'fortune'),
        'section'  => 'slider_sec',
        'settings' => 'fortune_slider_auto_play',
        'type'     => 'checkbox',
    )
    );
    for ($i = 1; $i <= 3; $i++) {
        $fortune_slider_page = 'fortune_slider_page_' . $i;

        $wp_customize->add_setting($fortune_slider_page,
            array(
                'default'           => 1,
                'sanitize_callback' => 'absint',
            )
        );

        $wp_customize->add_control($fortune_slider_page,
            array(
                'label'    => sprintf(esc_html__('Slider Page %d', 'fortune'), $i),
                'section'  => 'slider_sec',
                'type'     => 'dropdown-pages',
                'priority' => 10,

            )
        );

    }

    /* or put plugin shortcode */
    $wp_customize->add_setting('fortune_slider_code_heading', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Fortune_Customize_Heading($wp_customize, 'fortune_slider_code_heading', array(
        'label'    => esc_html__('OR Put slider plugin Shortcode ', 'fortune'),
        'section'  => 'slider_sec',
        'priority' => 11,
    )));

    $wp_customize->add_setting('fortune_theme_options[slider_plugin_code]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'sanitize_text_field',
            'default'           => $fortune_theme_options['slider_plugin_code'],
        )
    );
    $wp_customize->add_control('slider_plugin_code', array(
        'label'    => __('Slider plugin shortcode.', 'fortune'),
        'section'  => 'slider_sec',
        'settings' => 'fortune_theme_options[slider_plugin_code]',
        'type'     => 'text',
        'priority' => 11,
    )
    );

    /* Service Options */
    $wp_customize->add_section('service_section', array(
        'title'      => __("Service Options", "fortune"),
        'panel'      => 'fortune_theme_option',
        'capability' => 'edit_theme_options',
        'priority'   => 35,
    ));
    $wp_customize->add_setting(
        'fortune_theme_options[home_service_enabled]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['home_service_enabled'],
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_setting(
        'fortune_theme_options[service_type]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['service_type'],
            'sanitize_callback' => 'absint',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->add_control('service_type', array(
        'label'    => __('Service style', 'fortune'),
        'section'  => 'service_section',
        'settings' => 'fortune_theme_options[service_type]',
        'type'     => 'select',
        'choices'  => array(
            1 => __("Default", "fortune"),
            2 => __("Box Style", "fortune"),
        ),
    )
    );
    $wp_customize->add_control('home_service_enabled', array(
        'label'    => __('Enable Home Service', 'fortune'),
        'section'  => 'service_section',
        'settings' => 'fortune_theme_options[home_service_enabled]',
        'type'     => 'checkbox',
    )
    );
    $wp_customize->add_setting(
        'fortune_theme_options[service_heading]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['service_heading'],
            'sanitize_callback' => 'wp_kses_post',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control('service_heading', array(
        'label'    => __('Service Heading', 'fortune'),
        'section'  => 'service_section',
        'settings' => 'fortune_theme_options[service_heading]',
        'type'     => 'text',
    )
    );
    $wp_customize->selective_refresh->add_partial('fortune_theme_options[service_heading]', array(
        'selector'            => '#service_head',
        'render_callback' => function () {
            return fortune_get_option('service_heading');
        }
    ));
    for ($i = 1; $i <= 3; $i++) {
        $wp_customize->add_setting('fortune_service_heading_' . $i, array(
            'sanitize_callback' => 'sanitize_text_field',
        ));

        $wp_customize->add_setting(
            'fortune_theme_options[service_icon_' . $i . ']',
            array(
                'default'           => esc_attr($fortune_theme_options['service_icon_' . $i]),
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
                'transport'         => 'postMessage',
            )
        );

        $wp_customize->add_setting(
            'fortune_theme_options[service_title_' . $i . ']',
            array(
                'default'           => esc_attr($fortune_theme_options['service_title_' . $i]),
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
                'transport'         => 'postMessage',
            )
        );
        $wp_customize->add_setting(
            'fortune_theme_options[service_text_' . $i . ']',
            array(
                'default'           => esc_attr($fortune_theme_options['service_text_' . $i]),
                'type'              => 'option',
                'sanitize_callback' => 'wp_kses_post',
                'capability'        => 'edit_theme_options',
                'transport'         => 'postMessage',
            )
        );
        $wp_customize->add_setting(
            'fortune_theme_options[service_link_' . $i . ']',
            array(
                'type'              => 'option',
                'default'           => $fortune_theme_options['service_link_' . $i],
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'esc_url_raw',
            )
        );
        $wp_customize->add_setting(
            'fortune_theme_options[service_link_txt_' . $i . ']',
            array(
                'type'              => 'option',
                'default'           => esc_html__('Read More', 'fortune'),
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
                'transport'         => 'postMessage',
            )
        );
        $wp_customize->add_setting(
            'fortune_theme_options[service_target_' . $i . ']',
            array(
                'type'              => 'option',
                'default'           => $fortune_theme_options['service_target_' . $i],
                'sanitize_callback' => 'fortune_sanitize_checkbox',
                'capability'        => 'edit_theme_options',
                'transport'         => 'postMessage',
            )
        );

    }
    for ($i = 1; $i <= 3; $i++) {
        $wp_customize->add_control(new Fortune_Customize_Heading($wp_customize, 'fortune_service_heading_' . $i, array(
            'label'   => sprintf(__('Service %s ', 'fortune'), $j[$i]),
            'section' => 'service_section',
        )));
        $wp_customize->add_control(new Fortune_Custom_Customizer_Control($wp_customize, 'fortune_service_icon' . $i, array(
            'type'     => 'iconpicker',
            'label'    => sprintf(__('Service Icon %s ', 'fortune'), $j[$i]),
            'section'  => 'service_section',
            'settings' => 'fortune_theme_options[service_icon_' . $i . ']',
        )));

        $wp_customize->add_control('fortune_service_title' . $i, array(
            'label'    => __('Service Title', 'fortune') . $j[$i],
            'type'     => 'text',
            'section'  => 'service_section',
            'settings' => 'fortune_theme_options[service_title_' . $i . ']',
        ));
        $wp_customize->add_control('fortune_service_text_' . $i, array(
            'label'    => __('Service Description', 'fortune') . $j[$i],
            'type'     => 'textarea',
            'section'  => 'service_section',
            'settings' => 'fortune_theme_options[service_text_' . $i . ']',
        ));
        $wp_customize->add_control('fortune_service_link_txt_' . $i, array(
            'label'    => __('Button Text', 'fortune') . $j[$i],
            'type'     => 'text',
            'section'  => 'service_section',
            'settings' => 'fortune_theme_options[service_link_txt_' . $i . ']',
        ));

        $wp_customize->add_control('fortune_service_link_' . $i, array(
            'label'    => __('Button Link', 'fortune') . $j[$i],
            'type'     => 'text',
            'section'  => 'service_section',
            'settings' => 'fortune_theme_options[service_link_' . $i . ']',
        ));
        $wp_customize->add_control('fortune_service_link_target_' . $i, array(
            'label'    => __('Open link in new tab', 'fortune'),
            'type'     => 'checkbox',
            'section'  => 'service_section',
            'settings' => 'fortune_theme_options[service_target_' . $i . ']',
        ));

    }

    /* Portfolio Options */
    $wp_customize->add_section('portfolio_section', array(
        'title'      => __("Portfolio Options", "fortune"),
        'panel'      => 'fortune_theme_option',
        'capability' => 'edit_theme_options',
        'priority'   => 35,
    ));
    $wp_customize->add_setting(
        'fortune_theme_options[portfolio_home]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
            'default'           => 0,
        )
    );
    $wp_customize->add_control('portfolio_home', array(
        'label'    => __('Enable Home Portfolio', 'fortune'),
        'section'  => 'portfolio_section',
        'settings' => 'fortune_theme_options[portfolio_home]',
        'type'     => 'checkbox',
    )
    );

    /* home portfolio title */
    $wp_customize->add_setting(
        'fortune_theme_options[portfolio_home_title]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'wp_kses_post',
            'capability'        => 'edit_theme_options',
            'default'           => $fortune_theme_options['portfolio_home_title'],
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control('portfolio_home_title', array(
        'label'    => __('Enable Home Portfolio', 'fortune'),
        'section'  => 'portfolio_section',
        'settings' => 'fortune_theme_options[portfolio_home_title]',
        'type'     => 'text',
    )
    );

    $wp_customize->selective_refresh->add_partial('fortune_theme_options[portfolio_home_title]', array(
        'selector' => '#port_head',
        'render_callback' => function () {
            return fortune_get_option('portfolio_home_title');
        }
    ));

    for ($i = 1; $i <= 3; $i++) {

        $fortune_portfolio_page = 'fortune_portfolio_page_' . $i;

        $wp_customize->add_setting($fortune_portfolio_page,
            array(
                'default'           => 1,
                'sanitize_callback' => 'absint',
            )
        );

        $wp_customize->add_control($fortune_portfolio_page,
            array(
                'label'   => sprintf(esc_html__('Portfolio Page %d', 'fortune'), $i),
                'section' => 'portfolio_section',
                'type'    => 'dropdown-pages',
            )
        );

    }
    $wp_customize->add_setting('fortune_portfolio_OR_heading', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Fortune_Customize_Heading($wp_customize, 'fortune_portfolio_OR_heading', array(
        'label'   => __('OR select a page to show content from', 'fortune'),
        'section' => 'portfolio_section',
    )));

    $wp_customize->add_setting('fortune_portfolio_page',
        array(
            'sanitize_callback' => 'absint',
            'default'           => 0,
        )
    );
    $wp_customize->add_control('fortune_portfolio_page', array(
        'label'    => __('Select Page', 'fortune'),
        'section'  => 'portfolio_section',
        'settings' => 'fortune_portfolio_page',
        'type'     => 'dropdown-pages',
    )
    );
    /* Extra Options */
    $wp_customize->add_section('extra_section', array(
        'title'      => __("Extra Section", "fortune"),
        'panel'      => 'fortune_theme_option',
        'capability' => 'edit_theme_options',
        'priority'   => 35,
    ));
    $wp_customize->add_setting(
        'fortune_theme_options[extra_home]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
            'default'           => 0,
        )
    );
    $wp_customize->add_control('extra_home', array(
        'label'    => __('Enable Home extra', 'fortune'),
        'section'  => 'extra_section',
        'settings' => 'fortune_theme_options[extra_home]',
        'type'     => 'checkbox',
    )
    );

    $wp_customize->add_setting('fortune_theme_options[extra_section]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control('extra_section', array(
        'label'          => __('Select Page', 'fortune'),
        'description'    => __('Select Page to show content on home page.', 'fortune'),
        'section'        => 'extra_section',
        'settings'       => 'fortune_theme_options[extra_section]',
        'type'           => 'dropdown-pages',
        'allow_addition' => true,
    )
    );
    /* Blog Optionds */
    $wp_customize->add_section('blog_section', array(
        'title'      => __("Blog Options", "fortune"),
        'panel'      => 'fortune_theme_option',
        'capability' => 'edit_theme_options',
        'priority'   => 35,
    ));
    $wp_customize->add_setting(
        'fortune_theme_options[blog_home]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['blog_home'],
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
        )
    );

    $wp_customize->add_control('blog_home', array(
        'label'    => __('Enable Home Blog', 'fortune'),
        'section'  => 'blog_section',
        'settings' => 'fortune_theme_options[blog_home]',
        'type'     => 'checkbox',
    )
    );
    $wp_customize->add_setting(
        'fortune_theme_options[blog_title]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['blog_title'],
            'sanitize_callback' => 'wp_kses_post',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->selective_refresh->add_partial('fortune_theme_options[blog_title]', array(
        'selector'            => '#blog-heading',
        'render_callback' => function () {
            return fortune_get_option('blog_title');
        }
    ));

    $wp_customize->add_control('blog_title', array(
        'label'    => __('Home Blog Title', 'fortune'),
        'section'  => 'blog_section',
        'settings' => 'fortune_theme_options[blog_title]',
        'type'     => 'text',
    )
    );
    $wp_customize->add_setting(
        'fortune_theme_options[blog_desc]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['blog_desc'],
            'sanitize_callback' => 'sanitize_text_field',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->selective_refresh->add_partial('fortune_theme_options[blog_desc]', array(
        'selector'            => '#blog-desc',
        'render_callback' => function () {
            return fortune_get_option('blog_desc');
        }
    ));
    $wp_customize->add_control('blog_desc', array(
        'label'    => __('Home Blog Description', 'fortune'),
        'section'  => 'blog_section',
        'settings' => 'fortune_theme_options[blog_desc]',
        'type'     => 'text',
    )
    );
    /* Number of post to show on home */
    $wp_customize->add_setting(
        'blog_home_num_post',
        array(
            'default'           => 'all',
            'sanitize_callback' => 'fortune_sanitize_select',
            'capability'        => 'edit_theme_options',
        )
    );

    $wp_customize->add_control('blog_home_num_post', array(
        'label'    => __('Number of post to show', 'fortune'),
        'section'  => 'blog_section',
        'settings' => 'blog_home_num_post',
        'type'     => 'select',
        'choices'  => array(
            'all'    => __('Show All Posts', 'fortune'),
            'custom' => __('Custom', 'fortune'),
        ),
    ));

    $wp_customize->add_setting(
        'fortune_theme_options[home_post_num]',
        array(
            'type'              => 'option',
            'default'           => 8,
            'sanitize_callback' => 'absint',
            'capability'        => 'edit_theme_options',
        )
    );

    $wp_customize->add_control('home_post_num', array(
        'label'           => __('Number of Post', 'fortune'),
        'section'         => 'blog_section',
        'settings'        => 'fortune_theme_options[home_post_num]',
        'type'            => 'number',
        'active_callback' => function () {
            return get_theme_mod('blog_home_num_post') == 'custom' ? true : false;
        },
    ));

    /* show content on home blog */
    $wp_customize->add_setting(
        'fortune_theme_options[blog_home_content]',
        array(
            'type'              => 'option',
            'default'           => false,
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
        )
    );

    $wp_customize->add_control('blog_home_content', array(
        'label'    => __('Show Post Content', 'fortune'),
        'section'  => 'blog_section',
        'settings' => 'fortune_theme_options[blog_home_content]',
        'type'     => 'checkbox',
    )
    );
    $wp_customize->add_setting(
        'blog_home_content_type',
        array(
            'default'           => 'excerpt',
            'sanitize_callback' => 'fortune_sanitize_select',
            'capability'        => 'edit_theme_options',
        )
    );

    $wp_customize->add_control('blog_home_content_type', array(
        'label'           => __('Post Conent Type', 'fortune'),
        'section'         => 'blog_section',
        'settings'        => 'blog_home_content_type',
        'type'            => 'select',
        'choices'         => array(
            'content' => __('Full Content', 'fortune'),
            'excerpt' => __('Excerpt', 'fortune'),
            'custom'  => __('Custom', 'fortune'),
        ),
        'active_callback' => function () {
            $fortune_theme_options = get_option('fortune_theme_options');
            return $fortune_theme_options['blog_home_content'];
        },
    )
    );

    /* custom length */
    $wp_customize->add_setting(
        'fortune_theme_options[blog_home_content_custom]',
        array(
            'type'              => 'option',
            'default'           => 55,
            'sanitize_callback' => 'absint',
            'capability'        => 'edit_theme_options',
        )
    );

    $wp_customize->add_control('blog_home_content_custom', array(
        'label'           => __('Number of words', 'fortune'),
        'section'         => 'blog_section',
        'settings'        => 'fortune_theme_options[blog_home_content_custom]',
        'type'            => 'number',
        'active_callback' => function () {
            return get_theme_mod('blog_home_content_type') == 'custom' ? true : false;
        },
    ));
    /* Callout Optionds */
    $wp_customize->add_section('callout_section', array(
        'title'      => __("Callout Options", "fortune"),
        'panel'      => 'fortune_theme_option',
        'capability' => 'edit_theme_options',
        'priority'   => 35,
    ));
    $wp_customize->add_setting(
        'fortune_theme_options[callout_home]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['callout_home'],
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_control('callout_home', array(
        'label'    => __('Enable Callout Section', 'fortune'),
        'section'  => 'callout_section',
        'settings' => 'fortune_theme_options[callout_home]',
        'type'     => 'checkbox',
    )
    );

    $wp_customize->add_setting(
        'fortune_theme_options[callout_title]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['callout_title'],
            'sanitize_callback' => 'sanitize_text_field',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    
    $wp_customize->add_control('callout_title', array(
        'label'    => __('Callout Title', 'fortune'),
        'section'  => 'callout_section',
        'settings' => 'fortune_theme_options[callout_title]',
        'type'     => 'text',
    )
    );

    $wp_customize->selective_refresh->add_partial('fortune_theme_options[callout_title]', array(
        'selector'            => '#callout-title',
        'render_callback' => function () {
            return fortune_get_option('callout_title');
        },
    ));

    $wp_customize->add_setting(
        'fortune_theme_options[callout_btn_text]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['callout_btn_text'],
            'sanitize_callback' => 'sanitize_text_field',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->selective_refresh->add_partial('fortune_theme_options[callout_btn_text]', array(
        'selector'            => '#callout_btn_link',
        'render_callback'     => function(){
            return fortune_get_option('callout_btn_text');
        }
    ));
    $wp_customize->add_control('callout_btn_text', array(
        'label'    => __('Callout Button Text', 'fortune'),
        'section'  => 'callout_section',
        'settings' => 'fortune_theme_options[callout_btn_text]',
        'type'     => 'text',
    )
    );

    $wp_customize->add_setting(
        'fortune_theme_options[callout_btn_link]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['callout_btn_link'],
            'sanitize_callback' => 'esc_url_raw',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_control('callout_btn_link', array(
        'label'    => __('Callout Button Link', 'fortune'),
        'section'  => 'callout_section',
        'settings' => 'fortune_theme_options[callout_btn_link]',
        'type'     => 'text',
    )
    );

    $wp_customize->add_setting('fortune_callout_bg_color',
        array(
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'fortune_callout_bg_color',
            array(
                'label'    => __('Background color', 'fortune'),
                'section'  => 'callout_section',
                'settings' => 'fortune_callout_bg_color',
            ))
    );

    /* Social Optionds */
    $wp_customize->add_section('social_section', array(
        'title'      => __("Social Options", "fortune"),
        'desc'       => __("Social Options", "fortune"),
        'panel'      => 'fortune_theme_option',
        'capability' => 'edit_theme_options',
        'priority'   => 35,
    ));
    $wp_customize->add_setting(
        'fortune_theme_options[social_home]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['social_home'],
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->add_control('social_home', array(
        'label'    => __('Enable Social Media Option in Home', 'fortune'),
        'section'  => 'social_section',
        'settings' => 'fortune_theme_options[social_home]',
        'type'     => 'checkbox',
    )
    );

    $wp_customize->add_setting(
        'fortune_theme_options[social_footer]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['social_footer'],
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_control('social_footer', array(
        'label'    => __('Enable Social Media in Footer', 'fortune'),
        'section'  => 'social_section',
        'settings' => 'fortune_theme_options[social_footer]',
        'type'     => 'checkbox',
    )
    );

    $wp_customize->add_setting(
        'fortune_social_icons',
        array(
            'default'           => sprintf('<p><a href="' . esc_url_raw('https://www.webhuntinfotech.com/add-social-media-icons-fortune-lite-wordpress-theme/') . '" target="_blank">%1$s</a></p> <a class="linkToControl" id="nav_menu_locations[social]" href="#">%2$s</a>', esc_html__('How to add social icons?', 'fortune'), esc_html__('Add Social Menu', 'fortune')),
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'esc_html',
        )
    );
    $wp_customize->add_control(new Fortune_Custom_Customizer_Control($wp_customize, 'fortune_social_icons', array(
        'type'    => 'custom',
        'label'   => esc_html__('Add Social Icons ', 'fortune'),
        'section' => 'social_section',
    )));

    /* Footer Option */
    $wp_customize->add_section('footer_section', array(
        'title'      => __("Footer Options", "fortune"),
        'panel'      => 'fortune_theme_option',
        'capability' => 'edit_theme_options',
        'priority'   => 35,
    ));

    $wp_customize->add_setting(
        'fortune_theme_options[footer_copyright]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['footer_copyright'],
            'sanitize_callback' => 'sanitize_text_field',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->selective_refresh->add_partial('fortune_theme_options[footer_copyright]', array(
        'selector'            => '#f-copyright',
    ));
    $wp_customize->add_control('footer_copyright', array(
        'label'    => __('Copyright Text', 'fortune'),
        'section'  => 'footer_section',
        'settings' => 'fortune_theme_options[footer_copyright]',
        'type'     => 'text',
    )
    );
    $wp_customize->add_setting(
        'fortune_theme_options[developed_by_text]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['developed_by_text'],
            'sanitize_callback' => 'sanitize_text_field',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->add_control('developed_by_text', array(
        'label'    => __('Developed by Text', 'fortune'),
        'section'  => 'footer_section',
        'settings' => 'fortune_theme_options[developed_by_text]',
        'type'     => 'text',
    )
    );

    $wp_customize->add_setting(
        'fortune_theme_options[developed_by_link_text]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['developed_by_link_text'],
            'sanitize_callback' => 'sanitize_text_field',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->add_control('developed_by_link_text', array(
        'label'    => __('Link Text', 'fortune'),
        'section'  => 'footer_section',
        'settings' => 'fortune_theme_options[developed_by_link_text]',
        'type'     => 'text',
    )
    );
    $wp_customize->add_setting(
        'fortune_theme_options[developed_by_link]',
        array(
            'type'              => 'option',
            'default'           => $fortune_theme_options['developed_by_link'],
            'sanitize_callback' => 'esc_url_raw',
            'capability'        => 'edit_theme_options',
        )
    );
    $wp_customize->add_control('developed_by_link', array(
        'label'    => __('Developed by Link', 'fortune'),
        'section'  => 'footer_section',
        'settings' => 'fortune_theme_options[developed_by_link]',
        'type'     => 'text',
    )
    );
    $wp_customize->add_setting(
        'fortune_theme_options[show_footer_widget]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'fortune_sanitize_checkbox',
            'capability'        => 'edit_theme_options',
            'default'           => 1,
        )
    );
    $wp_customize->add_control('show_footer_widget', array(
        'label'    => __('Show/Hide Footer Widget Area', 'fortune'),
        'section'  => 'footer_section',
        'settings' => 'fortune_theme_options[show_footer_widget]',
        'type'     => 'checkbox',
    )
    );
    $wp_customize->add_setting('fortune_theme_options[footer_layout]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'absint',
            'default'           => 3,
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_control('footer_layout', array(
        'label'           => __('Footer widget layout', 'fortune'),
        'description'     => __('Change footer widget area into 2, 3 or 4 column', 'fortune'),
        'section'         => 'footer_section',
        'settings'        => 'fortune_theme_options[footer_layout]',
        'type'            => 'select',
        'choices'         => array(
            6 => esc_html__('2 columns', 'fortune'),
            4 => esc_html__('3 columns', 'fortune'),
            3 => esc_html__('4 columns', 'fortune'),
        ),
        'active_callback' => 'fortune_is_footer_area_enabled',
    )
    );

    $wp_customize->add_setting('fortune_theme_options[footer_bg_color]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_bg_color',
            array(
                'label'           => __('Footer-1 Background Color', 'fortune'),
                'section'         => 'footer_section',
                'settings'        => 'fortune_theme_options[footer_bg_color]',
                'active_callback' => 'fortune_is_footer_area_enabled',
            ))
    );

    $wp_customize->add_setting('fortune_theme_options[footer_2_bg_color]',
        array(
            'type'              => 'option',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '',
            'transport'         => 'postMessage',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'footer_2_bg_color',
            array(
                'label'    => __('Footer-2 Background Color', 'fortune'),
                'section'  => 'footer_section',
                'settings' => 'fortune_theme_options[footer_2_bg_color]',
            ))
    );

    $wp_customize->add_section('fortune_pro', array(
        'title'    => __('Upgrade to Fortune Premium', 'fortune'),
        'priority' => 999,
    ));

    $wp_customize->add_setting('fortune_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control(new Fortune_Custom_Customizer_Control($wp_customize, 'fortune_pro', array(
        'label'    => __('Fortune Premium', 'fortune'),
        'section'  => 'fortune_pro',
        'settings' => 'fortune_pro',
        'priority' => 1,
    )));
}

/* active callback function */
function fortune_is_footer_area_enabled()
{
    $fortune_theme_options = fortune_theme_options();
    return $fortune_theme_options['show_footer_widget'] == true ? true : false;
}
/* selective refresh functions */

function fortune_get_site_name()
{
    return get_bloginfo('name', 'display');
}

function fortune_get_site_description()
{
    return get_bloginfo('description', 'display');
}
/* custom heading control class */
if (class_exists('WP_Customize_Control') && !class_exists('Fortune_Customize_Heading')):
    class Fortune_Customize_Heading extends WP_Customize_Control
{
    public $type = 'heading';

    public function render_content()
    {
        if (!empty($this->label)): ?>
            <h3 class="fortune-accordion-section-title"><?php echo esc_html($this->label); ?></h3>
        <?php endif;

        if ($this->description) {?>
            <span class="description customize-control-description">
                <?php echo wp_kses_post($this->description); ?>
            </span>
        <?php }
    }
}
endif;

function fortune_partial_refresh_cont_number()
{
    $fortune_theme_options = fortune_theme_options();
    echo '<a class="cont_phone" href="tel:' . esc_attr($fortune_theme_options['contact_phone']) . '">' . esc_html($fortune_theme_options['contact_phone']) . '</a>';
}
function fortune_partial_refresh_cont_email()
{
    $fortune_theme_options = fortune_theme_options();
    echo '<a class="cont_email" href="mailto:' . sanitize_email($fortune_theme_options['contact_email']) . '">' . sanitize_email($fortune_theme_options['contact_email']) . '</a>';
}

/**
 * Sanitizing the select callback
 *
 */
function fortune_sanitize_select($input, $setting)
{

    // Ensure input is a slug.
    $input = sanitize_text_field($input);
    // Get list of choices from the control associated with the setting.
    $choices = $setting->manager->get_control($setting->id)->choices;
    // If the input is a valid key, return it; otherwise, return the default.
    return (array_key_exists($input, $choices) ? $input : $setting->default);
}

function fortune_sanitize_checkbox($checked)
{
    return ((isset($checked) && (true == $checked || 'on' == $checked)) ? true : false);
}

function fortune_customizer_preview_js()
{
    wp_enqueue_script('custom_css_preview', get_template_directory_uri() . '/vendor/customize-preview.js', array('customize-preview', 'jquery'));
}
add_action('customize_preview_init', 'fortune_customizer_preview_js');
add_action('customize_controls_enqueue_scripts', 'fortune_customize_controls_scripts');
function fortune_customize_controls_scripts()
{
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/css/fonts/font-awesome/css/font-awesome.css');
    wp_enqueue_style('simple-icon-picker', get_template_directory_uri() . '/css/simple-iconpicker.css');
    wp_enqueue_script('simple-icon-picker-js', get_template_directory_uri() . '/vendor/simple-iconpicker.js', array('jquery', 'customize-controls'), '20190206', true);
}
if (class_exists('WP_Customize_Control') && !class_exists('Fortune_Custom_Customizer_Control')):
    class Fortune_Custom_Customizer_Control extends WP_Customize_Control
{

        /**
         * Render the content on the theme customizer page
         */
        public function render_content()
    {
            switch ($this->type) {
                case 'iconpicker': ?>
                <label>
                  <span class="customize-control-title">
                      <?php echo esc_html($this->label); ?>
                  </span>

                  <?php if (!empty($this->description)): ?>
                      <span class="description customize-control-description"><?php echo esc_html($this->description); ?></span>
                  <?php endif;?>

                  <input id="input_<?php echo esc_html($this->id); ?>" class="iconpicker" type="text" value="<?php echo esc_html($this->value()); ?>" <?php echo $this->link(); ?>>
                </label><?php
              break;
              case 'custom': ?>
              <label>
                <span class="customize-control-title">
                    <?php echo esc_html($this->label); ?>
                </span>

                <?php if (!empty($this->description)): ?>
                    <span class="description customize-control-description"><?php echo esc_html($this->description); ?>
                </span>
            <?php endif;?>

            <div class="customize-custom-control"><?php echo wp_kses_post($this->value()); ?></div>
            </label><?php
            break;
            default: ?>
            <label style="overflow: hidden; zoom: 1;">
                <div class="col-md-2 col-sm-6 upsell-btn">
                    <a style="margin-bottom:20px;margin-left:20px;"
                    href="<?php echo esc_url_raw('https://www.webhuntinfotech.com/theme/fortune-premium-wordpress-theme/'); ?>" target="blank"
                    class="btn btn-success btn"><?php _e('Upgrade to Fortune Premium', 'fortune');?> </a>
                </div>
                <div class="col-md-4 col-sm-6">
                    <img class="fortune_img_responsive "
                    src="<?php echo get_template_directory_uri() . '/images/fortune.png'; ?>">
                </div>
                <div class="col-md-3 col-sm-6">
                    <h3 style="margin-top:10px;margin-left: 20px;text-decoration:underline;color:#333;"><?php echo _e('Fortune Premium - Features', 'fortune'); ?></h3>
                    <ul style="padding-top:10px">
                        <li class="upsell-fortune">
                            <div class="dashicons dashicons-yes"></div> <?php _e('Responsive Design', 'fortune');?>
                        </li>
                        <li class="upsell-fortune">
                            <div class="dashicons dashicons-yes"></div> <?php _e('Rich Shortcodes', 'fortune');?> </li>
                            <li class="upsell-fortune">
                                <div class="dashicons dashicons-yes"></div> <?php _e('More than 15 Templates', 'fortune');?>
                            </li>
                            <li class="upsell-fortune">
                                <div class="dashicons dashicons-yes"></div> <?php _e('Custom Widgets', 'fortune');?> </li>
                                <li class="upsell-fortune">
                                    <div class="dashicons dashicons-yes"></div> <?php _e('Pricing Tables', 'fortune');?> </li>
                                    <li class="upsell-fortune">
                                        <div class="dashicons dashicons-yes"></div> <?php _e('Redux Options Panel', 'fortune');?>
                                    </li>
                                    <li class="upsell-fortune">
                                        <div class="dashicons dashicons-yes"></div> <?php _e('2 types of Service Section', 'fortune');?>
                                    </li>
                                    <li class="upsell-fortune">
                                        <div class="dashicons dashicons-yes"></div> <?php _e('3 Different Types of Blog Templates', 'fortune');?>
                                    </li>
                                    <li class="upsell-fortune">
                                        <div class="dashicons dashicons-yes"></div> <?php _e('4 Types of Portfolio Templates', 'fortune');?>
                                    </li>
                                    <li class="upsell-fortune">
                                        <div class="dashicons dashicons-yes"></div> <?php _e('Unlimited Colors Scheme', 'fortune');?>
                                    </li>
                                    <li class="upsell-fortune">
                                        <div class="dashicons dashicons-yes"></div> <?php _e('Patterns Background', 'fortune');?>
                                    </li>
                                    <li class="upsell-fortune">
                                        <div class="dashicons dashicons-yes"></div> <?php _e('WPML Compatible', 'fortune');?>
                                    </li>
                                    <li class="upsell-fortune">
                                        <div class="dashicons dashicons-yes"></div> <?php _e('Woo-commerce Compatible', 'fortune');?>
                                        <li class="upsell-fortune">
                                            <div class="dashicons dashicons-yes"></div> <?php _e('Portfolio layout with Isotope effect', 'fortune');?>
                                        </li>
                                        <li class="upsell-fortune">
                                            <div class="dashicons dashicons-yes"></div> <?php _e('Translation Ready', 'fortune');?>
                                        </li>

                                    </ul>
                                </div>
                                <div class="col-md-2 col-sm-6 upsell-btn upsell-btn-bottom">
                                    <a style="margin-bottom:20px;margin-left:20px;"
                                    href="<?php echo esc_url_raw('https://www.webhuntinfotech.com/theme/fortune-premium-wordpress-theme/'); ?>" target="blank"
                                    class="btn btn-success btn"><?php _e('Upgrade to Fortune Premium', 'fortune');?> </a>
                                </div>

                                <p>
                                    <?php
                                    printf(__('If you Like our Products , Please Rate us 5 star on %1$sWordPress.org%2$s.  We\'d really appreciate it! </br></br>  Thank You', 'fortune'), '<a target="_blank" href="https://wordpress.org/support/view/theme-reviews/fortune?filter=5">', '</a>');
                                    ?>
                                </p>
                            </label>
                    <?php
break;
        }
    }
}
endif;
?>
