<?php
/* Add Customizer Panel */
$fortune_theme_options = fortune_theme_options();
Kirki::add_config('fortune_theme', array(
    'capability'  => 'edit_theme_options',
    'option_type' => 'option',
    'option_name' => 'fortune_theme_options',
));

Kirki::add_field('fortune_theme', array(
    'type'     => 'custom',
    'settings' => 'slider_typo',
    'label'    => 'Slider Typography',
    'section'  => 'slider_sec',
    'default'  => sprintf('<a class="linkToControl" id="fortune_theme_options[slider_title_font]" href="#">%s</a>',esc_html__('Go to typography section.','fortune')),
    'priority' => 10,
));

/* Typography */
Kirki::add_section('typography_sec', array(
    'title'       => __('Typography Section', 'fortune'),
    'description' => __('Here you can change Font Style of your site', 'fortune'),
    'panel'       => 'fortune_theme_option',
    'priority'    => 160,
    'capability'  => 'edit_theme_options',
));

Kirki::add_field('fortune_theme', array(
    'type'        => 'typography',
    'settings'    => 'logo_font',
    'label'       => __('Logo Font Style', 'fortune'),
    'description' => __('Change logo font family and font style.', 'fortune'),
    'section'     => 'typography_sec',
    'default'     => array(
        'font-style'     => array('bold', 'italic'),
        'font-family'    => 'Anton',
        'variant'        => 'regular',
        'font-size'      => '36px',
        'line-height'    => '1em',
        'letter-spacing' => '0',
        'subsets'        => array('sans-serif'),
        'text-transform' => 'capitalize',

    ),
    'priority'    => 10,
    'output'      => array(
        array(
            'element' => '.header .logo .site-title a',
        ),
    ),
));

Kirki::add_field('fortune_theme', array(
    'type'        => 'typography',
    'settings'    => 'logo_tag_font',
    'label'       => __('Logo Tag line Style', 'fortune'),
    'description' => __('Change logo tag ine font family and font style.', 'fortune'),
    'section'     => 'typography_sec',
    'default'     => array(
        'font-style'     => array('bold', 'italic'),
        'font-family'    => 'Muli',
        'font-size'      => '11px',
        'line-height'    => '1.5em',
        'subsets'        => array('sans-serif'),
        'text-transform' => 'capitalize',
        'color'          => '#a3a3a3',

    ),
    'priority'    => 10,
    'output'      => array(
        array(
            'element' => '.header .logo .tagline',
        ),
    ),
));

Kirki::add_field('fortune_theme', array(
    'type'     => 'typography',
    'settings' => 'prime_menu_font',
    'label'    => __('Primary Menu Style', 'fortune'),
    'section'  => 'typography_sec',
    'default'  => array(
        'font-style'     => array('bold', 'italic'),
        'font-family'    => 'Oswald',
        'font-size'      => '16px',
        'subsets'        => array('sans-serif'),
        'text-transform' => 'uppercase',

    ),
    'priority' => 10,
    'output'   => array(
        array(
            'element' => '.fhmm .navbar-collapse .navbar-nav > li > a',
        ),
    ),
));
/* Slider title Typography */
Kirki::add_field('fortune_theme', array(
    'type'        => 'typography',
    'settings'    => 'slider_title_font',
    'label'       => __('Slider Title Style', 'fortune'),
    'description' => __('Change Slider Title font family and font style.', 'fortune'),
    'section'     => 'typography_sec',
    'default'     => array(
        'font-style'     => array('bold'),
        'font-family'    => '',
        'font-size'      => '',
        'line-height'    => '1.2',
        'subsets'        => array('serif'),
        'text-transform' => 'uppercase',
        'color'          => '',

    ),
    'priority'    => 10,
    'output'      => array(
        array(
            'element' => '.ft-slide-cap-title',
        ),
    ),
));

/* Slider subtitle Typography */
Kirki::add_field('fortune_theme', array(
    'type'        => 'typography',
    'settings'    => 'slider_subtitle_font',
    'label'       => __('Slider Subtitle Font Style', 'fortune'),
    'description' => __('Change Sldier subtitle font family and font style.', 'fortune'),
    'section'     => 'typography_sec',
    'default'     => array(
        'font-family'    => '',
        'font-size'      => '',
        'line-height'    => '',
        'subsets'        => array('sans-serif'),
        'text-transform' => 'capitalize',

    ),
    'priority'    => 10,
    'output'      => array(
        array(
            'element' => '.ft-slide-cap-desc *',
        ),
    ),
));

/* Full body typography */
Kirki::add_field('fortune_theme', array(
    'type'        => 'typography',
    'settings'    => 'site_font',
    'label'       => __('Site Font Style', 'fortune'),
    'description' => __('Change whole site font family and font style.', 'fortune'),
    'section'     => 'typography_sec',
    'default'     => array(
        'font-style'  => array('bold', 'italic'),
        'font-family' => "Open Sans",

    ),
    'priority'    => 10,
    'choices'     => array(
        'font-style'  => true,
        'font-family' => true,
    ),
    'output'      => array(
        array(
            'element' => 'body, p, a, em, blockquote',
        ),
    ),
));

for ($i=1; $i <=6 ; $i++) { 
    Kirki::add_field('fortune_theme', array(
        'type'        => 'typography',
        'settings'    => "site_h{$i}_font",
        'label'       => sprintf(__('Heading H%d', 'fortune'),$i),
        'section'     => 'typography_sec',
        'default'     => array(
            'font-style'  => array('bold', 'italic'),
            'font-family' => "Open Sans",

        ),
        'priority'    => 10,
        'choices'     => array(
            'font-style'  => true,
            'font-family' => true,
            'font-weight' => true,
            'text-transform' => true,
        ),
        'output'      => array(
            array(
                'element' => 'h'.$i,
            ),
        ),
    ));
}

/* Home Page Customizer */
Kirki::add_section('home_customize_section', array(
    'title'      => __('Home Page Reorder Sections', 'fortune'),
    'panel'      => 'fortune_theme_option',
    'priority'   => 160,
    'capability' => 'edit_theme_options',
));
Kirki::add_field('fortune_theme', array(
    'type'     => 'sortable',
    'settings' => 'home_sections',
    'label'    => __('Here You can reorder your homepage section', 'fortune'),
    'section'  => 'home_customize_section',
    'default'  => array(
        'service',
        'portfolio',
        'extra',
        'blog',
    ),
    'choices'  => array(
        'service'   => esc_attr__('Service Section', 'fortune'),
        'portfolio' => esc_attr__('Portfolio Section', 'fortune'),
        'extra'     => esc_attr__('Extra Section', 'fortune'),
        'blog'      => esc_attr__('Blog Section', 'fortune'),
    ),
    'priority' => 10,
));
