<?php 
if ( post_password_required() ) {
	return;
}
if (have_comments()): ?>
<div class="comments-wrapper" id="comments">
  <h3>
    <?php
        if ( comments_open() ) {
            if ( have_comments() ) {
                _e( 'Join the Conversation', 'fortune' );
            } else {
                _e( 'Leave a comment', 'fortune' );
            }
        } else {
            if ( '1' == get_comments_number() ) {
                /* translators: %s: post title */
                printf( _x( 'One reply on &ldquo;%s&rdquo;', 'comments title', 'fortune' ), get_the_title() );
            } else {
                printf(
                    /* translators: 1: number of comments, 2: post title */
                    _nx(
                        '%1$s reply on &ldquo;%2$s&rdquo;',
                        '%1$s replies on &ldquo;%2$s&rdquo;',
                        get_comments_number(),
                        'comments title',
                        'fortune'
                    ),
                    number_format_i18n( get_comments_number() ),
                    get_the_title()
                );
            }
        }
    ?>
</h3>
  <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : 
            the_comments_navigation(
                array(
                    'prev_text' => sprintf( '%s <span class="nav-prev-text"><span class="primary-text">%s</span> <span class="secondary-text">%s</span></span>', '<i class="fa fa-long-arrow-left"></i>', __( 'Previous', 'fortune' ), __( 'Comments', 'fortune' ) ),
                    'next_text' => sprintf( '<span class="nav-next-text"><span class="primary-text">%s</span> <span class="secondary-text">%s</span></span> %s', __( 'Next', 'fortune' ), __( 'Comments', 'fortune' ), '<i class="fa fa-long-arrow-right"></i>' ),
                )
            );
        endif; // Check for comment navigation.
        ?>
  <ol class="commentlist">
  	 <?php wp_list_comments('callback=fortune_comments&style=ol'); ?>  
  </ol>
  <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : 
            the_comments_navigation(
                array(
                    'prev_text' => sprintf( '%s <span class="nav-prev-text"><span class="primary-text">%s</span> <span class="secondary-text">%s</span></span>', '<i class="fa fa-long-arrow-left"></i>', __( 'Previous', 'fortune' ), __( 'Comments', 'fortune' ) ),
                    'next_text' => sprintf( '<span class="nav-next-text"><span class="primary-text">%s</span> <span class="secondary-text">%s</span></span> %s', __( 'Next', 'fortune' ), __( 'Comments', 'fortune' ), '<i class="fa fa-long-arrow-right"></i>' ),
                )
            );
        endif; // Check for comment navigation.
        ?>
</div><?php
endif; 
if (comments_open()) { ?>
<div id="respond" class="comment-respond">
<?php
                $fields = array(
                    'author' => '<div class="row"><div class="col-md-6"><div class="form-group">
					<label for="author">' . __('Name', 'fortune') . ' <span class="required">*</span></label>
					<input type="text" class="form-control" id="author" name="author"></div>',
                    'email' => '<div class="form-group"><label for="email">' . __('Email', 'fortune') . ' <span class="required">*</span></label><input type="text" class="form-control" id="email" name="email"></div>',
                    'website' => '<div class="form-group"><label for="url">' . __('Website', 'fortune') . ' </label><input type="text" class="form-control" id="url" name="url"></div></div></div>',
                );
                function fortune_defaullt_fields($fields)
                {
                    return $fields;
                }

                add_filter('comment_form_default_fields', 'fortune_defaullt_fields');
                $comments_args = array(
                    'fields' => apply_filters('comment_form_default_fields', $fields),
                    'label_submit' => __('Submit Message', 'fortune'),
                    'title_reply_to' => '<h3 class="reply-title">' . __('Leave a Reply to %s', 'fortune') . '</h3>',
                    'title_reply' => '<h3 class="reply-title">' . __("Leave a reply", 'fortune') . '</h3>',
                    'comment_notes_after' => '',
                    'comment_field' => '<div class="form-group">
										<label for="comment">' . __("Comment", 'fortune') . '</label>
										<textarea cols="30" rows="10" class="form-control" id="comment" name="comment"></textarea>
									</div>',
                    'class_submit' => 'btn btn-primary',
                );
                comment_form($comments_args);?>	
</div>
<?php } ?>