<?php
final class forexn_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		require_once( trailingslashit( get_template_directory() ) . '/inc/upgrade/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'forexn_Customize_Section_Pro' );

		// doc sections.
		$manager->add_section(
			new forexn_Customize_Section_Pro(
				$manager,
				'forexn',
				array(
					'title'    => esc_html__( 'Theme Documentation', 'forexn' ),
					'pro_text' => esc_html__( 'Click Here', 'forexn' ),
					'pro_url'  => 'http://wpcart.net/index.php/forexn-documentation/',
					'priority'  => 1
				)
			)
		);
		// upgrade sections.
		$manager->add_section(
			new forexn_Customize_Section_Pro(
				$manager,
				'upgrade-pro',
				array(
					'title'    => esc_html__( 'Upgrade To Pro', 'forexn'),
					'pro_text' => esc_html__( 'View Pro', 'forexn' ),
					'pro_url'  => 'http://wpcart.net/index.php/forexn-pro/',
					'priority'  => 2
				)
			)
		);
	}


	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'forexn-customize-controls', trailingslashit( get_template_directory_uri() ) . '/inc/upgrade/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'forexn-customize-controls', trailingslashit( get_template_directory_uri() ) . '/inc/upgrade/customize-controls.css' );
	}
}

// Doing this customizer thang!
forexn_Customize::get_instance();