<?php
function forexn_customize_register( $wp_customize ) {
	
if ( ! function_exists( 'forexn_sanitize_checkbox' ) ) :


    function forexn_sanitize_checkbox( $checked ) {

        return ( ( isset( $checked ) && true === $checked ) ? true : false );

    }

endif;


    if ( !function_exists('forexn_sanitize_select') ) :
        function forexn_sanitize_select( $input, $setting ) {

            // Ensure input is a slug.
            $input = sanitize_text_field( $input );

            // Get list of choices from the control associated with the setting.
            $choices = $setting->manager->get_control( $setting->id )->choices;

                // If the input is a valid key, return it; otherwise, return the default.
            return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
        }
    endif;


    if ( !function_exists('forexn_column_layout_sanitize_select') ) :
        function forexn_column_layout_sanitize_select( $input, $setting ) {

            // Ensure input is a slug.
            $input = sanitize_text_field( $input );

            // Get list of choices from the control associated with the setting.
            $choices = $setting->manager->get_control( $setting->id )->choices;

            // If the input is a valid key, return it; otherwise, return the default.
            return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
        }
    endif;
    
    function forexn_sanitize_dropdown_pages( $page_id, $setting ) {
        // Ensure $input is an absolute integer.
        $page_id = absint( $page_id );
    
        // If $page_id is an ID of a published page, return it; otherwise, return the default.
        return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
    }


	
    /** Front Page Section Settings starts **/	

    $wp_customize->add_panel('frontpage', 
        array(
            'title'       => __('Forex Options', 'forexn'),        
		    'description' => '',                                        
		    'priority'   => 3,
        )
    );
	

    /** Header Section Settings Start **/

 $wp_customize->add_section('forexn_header_info', array(
      'title'   => __('Header Section', 'forexn'),
      'description' => '',
      'panel' => 'frontpage',
      'priority'    => 110
    ));
  
  $wp_customize->add_setting('forexn_show_header_section',
    array(
        'default'           => true,
        'sanitize_callback' => 'forexn_sanitize_checkbox'
    )
);
$wp_customize->add_control('forexn_show_header_section',
    array(
        'label'    => __('Enable Header Section', 'forexn'),
        'section'  => 'forexn_header_info',
        'type'     => 'checkbox',
        'priority' => ''

    )
);

$wp_customize->add_setting('forexn_header_phone', array(
    'default'   => '',
    'type'      => 'theme_mod',
   'sanitize_callback'  => 'sanitize_text_field'
));

$wp_customize->add_control('forexn_header_phone', array(
    'label'   => __('Contact', 'forexn'),
    'section' => 'forexn_header_info',
    'priority'  => ''
));

$wp_customize->add_setting('forexn_header_email', array(
    'default'   => '',
    'type'      => 'theme_mod',
   'sanitize_callback'  => 'sanitize_text_field'
));

$wp_customize->add_control('forexn_header_email', array(
    'label'   => __('Email', 'forexn'),
    'section' => 'forexn_header_info',
    'priority'  => ''
));

$wp_customize->add_setting('forexn_location',array(
    'default'   => '',
    'type'      => 'theme_mod',
    'sanitize_callback' => 'sanitize_text_field'
)); 
$wp_customize->add_control('forexn_location',array(
    'label' => __('Add Location','forexn'),
    'section'=> 'forexn_header_info',
    'priority'  => ''
));


//slider

 $wp_customize->add_section('forexn_sliderinfo', array(
      'title'   => __('Home Slider Section', 'forexn'),
      'description' => '',
      'panel' => 'frontpage',
      'priority'    => 120
    ));
    
 $wp_customize->add_setting('forexn_show_banner_section',
    array(
        'default'           => false,
        'sanitize_callback' => 'forexn_sanitize_checkbox'
    )
);
$wp_customize->add_control('forexn_show_banner_section',
    array(
        'label'    => __('Enable Home Slider Section', 'forexn'),
        'section'  => 'forexn_sliderinfo',
        'type'     => 'checkbox',
        'priority' => 1,

    )
);

 $wp_customize->add_setting('forexn_slider_opacity_section',
    array(
        'default'           => '.85',
        'sanitize_callback' => 'forexn_sanitize_float'
    )
);
$wp_customize->add_control('forexn_slider_opacity_section',
    array(
        'label'    => __('Slider Opacity', 'forexn'),
        'section'  => 'forexn_sliderinfo',
        'type'     => 'number',
        'input_attrs' => array(
            'min' => '0.01', 'step' => '0.01', 'max' => '1',
          ),
        'priority' => 2,

    )
);

function forexn_sanitize_float( $input ) {
    return filter_var($input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}

//pages...................................................
$slider_no = 3;
for( $k = 1; $k <= $slider_no; $k++ ) {
    $forexn_slider_page   = 'forexn_slider_page_' .$k;
    $forexn_slider_btntxt = 'forexn_slider_btntxt_' .$k;
    $forexn_slider_btnurl = 'forexn_slider_btnurl_' .$k;
    $forexn_slider_btntxt2 = 'forexn_slider_btntxt2_' .$k;
    $forexn_slider_btnurl2 = 'forexn_slider_btnurl2_' .$k;


    $wp_customize->add_setting( $forexn_slider_page,
    array(
        'default'           => 1,
        'sanitize_callback' => 'forexn_sanitize_dropdown_pages',
    )
    );

    $wp_customize->add_control( $forexn_slider_page,
    array(
        'label'     => __( 'Slider Page ', 'forexn' ) .$k,
        'section'   => 'forexn_sliderinfo',
        'type'      => 'dropdown-pages',
        'priority'  => 100,
    )
    );

    //button.....................................................

    $wp_customize->add_setting( $forexn_slider_btntxt,
    array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    )
    );

    $wp_customize->add_control( $forexn_slider_btntxt,
    array(
        'label'        => __( 'Button 1 - Text','forexn' ),
        'section'      => 'forexn_sliderinfo',
        'type'         => 'text',
        'priority'     => 100,
    )
    );

    $wp_customize->add_setting( $forexn_slider_btnurl,
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    )
    );

    $wp_customize->add_control( $forexn_slider_btnurl,
    array(
        'label'       => __( 'Button 1- URL', 'forexn' ),
        'section'     => 'forexn_sliderinfo',
        'type'        => 'text',
        'priority'    => 100,
    )
    );


    $wp_customize->add_setting( $forexn_slider_btntxt2,
    array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    )
    );

    $wp_customize->add_control( $forexn_slider_btntxt2,
    array(
        'label'        => __( 'Button 2 - Text','forexn' ),
        'section'      => 'forexn_sliderinfo',
        'type'         => 'text',
        'priority'     => 100,
    )
    );

    $wp_customize->add_setting( $forexn_slider_btnurl2,
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    )
    );

    $wp_customize->add_control( $forexn_slider_btnurl2,
    array(
        'label'       => __( 'Button 2 - URL', 'forexn' ),
        'section'     => 'forexn_sliderinfo',
        'type'        => 'text',
        'priority'    => 100,
    )); 
}

//about

$wp_customize->add_section('forexn_about',              
        array(
            'title'       => __('Home About Section', 'forexn'),          
            'description' => '',             
            'panel'       => 'frontpage',      
            'priority'    => 140,
        )
    );
    
  $wp_customize->add_setting('forexn_show_About_section',
    array(
        'default'           => false,
        'sanitize_callback' => 'forexn_sanitize_checkbox'
    )
);
$wp_customize->add_control('forexn_show_About_section',
    array(
        'label'    => __('Enable Home About Section', 'forexn'),
        'section'  => 'forexn_about',
        'type'     => 'checkbox',
        'priority' => 1,

    )
);
    // about 
   
    $About_no = 1;
        for( $i = 1; $i <= $About_no; $i++ ) {
            $forexn_Aboutpage = 'forexn_About_page_' . $i;
        
        
    $wp_customize->add_setting( $forexn_Aboutpage,
        array(
            'default'           => 1,
            'sanitize_callback' => 'forexn_sanitize_dropdown_pages',
        )
    );

    $wp_customize->add_control( $forexn_Aboutpage,
        array(
            'label'        => __( 'About Page ', 'forexn' ) .$i,
            'section'      => 'forexn_about',
            'type'         => 'dropdown-pages',
            'priority'     => 100,
        )
    );

    $wp_customize->add_setting(
        'forexn_about_heading', 
        array(
            'default'   => 'About Us',
            'type'      => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'forexn_about_heading', 
        array(
            'label'   => __('About Heading Text', 'forexn'),
            'section' => 'forexn_about',
            'priority'  => 50
        )
    );

    $wp_customize->add_setting(
        'forexn_about_sub_heading', 
        array(
            'default'   => 'Lorem ipsum dolor sit amet,consectetur adipisicing elit',
            'type'      => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'forexn_about_sub_heading', 
        array(
            'label'   => __('About Sub Heading Text', 'forexn'),
            'section' => 'forexn_about',
            'priority'  => 55
        )
    );

    }



//service
$wp_customize->add_section('forexn_services',              
        array(
            'title'       => __('Home Service Section', 'forexn'),          
            'description' => '',             
            'panel'       => 'frontpage',      
            'priority'    => 140,
        )
    );
    
  $wp_customize->add_setting('forexn_show_service_section',
    array(
        'default'           => false,
        'sanitize_callback' => 'forexn_sanitize_checkbox'
    )
);
$wp_customize->add_control('forexn_show_service_section',
    array(
        'label'    => __('Enable Home Service Section', 'forexn'),
        'section'  => 'forexn_services',
        'type'     => 'checkbox',
        'priority' => 1,

    )
);



    // Services 
   
    $service_no = 6;
        for( $i = 1; $i <= $service_no; $i++ ) {
            $forexn_servicepage = 'forexn_service_page_' . $i;
            $forexn_serviceicon = 'forexn_page_service_icon_' . $i;
        
    // Setting - Feature Icon
    $wp_customize->add_setting( $forexn_serviceicon,
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control( $forexn_serviceicon,
        array(
            'label'         => __( 'Service Icon ', 'forexn' ).$i,
            'description' =>  __('Select font awesome icon from <a target="_blank" href="https://fontawesome.com/v4.7.0/icons/">Font Awesome List</a> Or Input class','forexn'),
            'section'       => 'forexn_services',
            'type'          => 'text',
            'priority'      => 100,
        )
    );
        
    $wp_customize->add_setting( $forexn_servicepage,
        array(
            'default'           => 1,
            'sanitize_callback' => 'forexn_sanitize_dropdown_pages',
        )
    );

    $wp_customize->add_control( $forexn_servicepage,
        array(
            'label'        => __( 'Service Page ', 'forexn' ) .$i,
            'section'      => 'forexn_services',
            'type'         => 'dropdown-pages',
            'priority'     => 100,
        )
    );

    $wp_customize->add_setting(
        'forexn_service_heading', 
        array(
            'default'   => 'Our Services',
            'type'      => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'forexn_service_heading', 
        array(
            'label'   => __('Service Heading Text', 'forexn'),
            'section' => 'forexn_services',
            'priority'  => 50
        )
    );

    $wp_customize->add_setting(
        'forexn_service_sub_heading', 
        array(
            'default'   => 'Lorem ipsum dolor sit amet,consectetur adipisicing elit, sed do eiu tempore incididunt ut labore et dolore magna aliqua',
            'type'      => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'forexn_service_sub_heading', 
        array(
            'label'   => __('Service Sub Heading Text', 'forexn'),
            'section' => 'forexn_services',
            'priority'  => 55
        )
    );

    }

    $wp_customize->add_section('forexn_partner_info', array(
      'title'   => __('Home Client Section ', 'forexn'),
      'description' => '',
      'panel' => 'frontpage',
      'priority'    => 153
    ));
  
  $wp_customize->add_setting('forexn_show_partner_section',
    array(
        'default'           => false,
        'sanitize_callback' => 'forexn_sanitize_checkbox'
    )
);
$wp_customize->add_control('forexn_show_partner_section',
    array(
        'label'    => __('Enable Home Client Section', 'forexn'),
        'section'  => 'forexn_partner_info',
        'type'     => 'checkbox',
        'priority' => ''

    )
);
  
  $partner_no = 6;
  for( $i = 1; $i <= $partner_no; $i++ ) {
  $forexn_partner_page = 'forexn_partner_page_' . $i; 
    $wp_customize->add_setting( $forexn_partner_page,
      array(
        'default'           => 1,
        'sanitize_callback' => 'forexn_sanitize_dropdown_pages',
      )
    );

    $wp_customize->add_control( $forexn_partner_page,
      array(
        'label'         => __( 'Client Partner Page ', 'forexn' ).$i,
        'section'       => 'forexn_partner_info',
        'type'          => 'dropdown-pages',
        'priority'      => 4,
      )
    );
  
  }
 

$wp_customize->add_section('forexn_blog_info', 
        array(
            'title'       => __('Home Blog Section', 'forexn'),
            'description' => '',
            'panel'       => 'frontpage',
            'priority'    => 160
        )
     );
    
  $wp_customize->add_setting('forexn_show_blog_section',
    array(
        'default'           => true,
        'sanitize_callback' => 'forexn_sanitize_checkbox'
    )
);
$wp_customize->add_control('forexn_show_blog_section',
    array(
        'label'    => __('Enable Home Blog Section', 'forexn'),
        'section'  => 'forexn_blog_info',
        'type'     => 'checkbox',
        'priority' => 1,

    )
);
    
    $wp_customize->add_setting('forexn_blog_title', 
         array(
            'default'            => 'Latest News',
            'type'               => 'theme_mod',
            'sanitize_callback'  => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('forexn_blog_title', 
        array(
            'label'    => __('Blog Title', 'forexn'),
            'section'  => 'forexn_blog_info',
            'priority' => 1
        )
    );
    
    $wp_customize->add_setting('forexn_blog_subtitle', 
        array(
            'default'             => '',
            'type'                => 'theme_mod',
            'sanitize_callback'   => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('forexn_blog_subtitle', 
        array(
            'label'    => __('Blog Subheading', 'forexn'),
            'section'  => 'forexn_blog_info', 
            'priority' => 4
        )
    );

    $wp_customize->add_setting( 'news_number_post',
        array(
            'sanitize_callback' => 'absint',
            'default'           => 3,
        )
    );
    $wp_customize->add_control( 'news_number_post',
        array(
            'label'         => __('Number Posts:', 'forexn'),
            'section'       => 'forexn_blog_info',
            'description'   => __('posts to show.', 'forexn' )
        )
    );

$wp_customize->add_section(
        'forexn_footer_contact', 
        array(
            'title'   => __('Callout Section', 'forexn'),
            'description' => '',
            'panel' => 'frontpage',
            'priority'    => 170
        )
    );
    
  $wp_customize->add_setting('forexn_show_callout_section',
    array(
        'default'           => false,
        'sanitize_callback' => 'forexn_sanitize_checkbox'
    )
);
$wp_customize->add_control('forexn_show_callout_section',
    array(
        'label'    => __('Enable Callout Section', 'forexn'),
        'section'  => 'forexn_footer_contact',
        'type'     => 'checkbox',
        'priority' => 1,

    )
);

    $wp_customize->add_setting(
        'forexn_ctah_heading', 
        array(
            'default'   => '',
            'type'      => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'forexn_ctah_heading', 
        array(
            'label'   => __('Callout Heading Text', 'forexn'),
            'section' => 'forexn_footer_contact',
            'priority'  => 8
        )
    );

    $wp_customize->add_setting(
        'forexn_ctah_btn_url', 
        array(
            'default'   =>'',
            'type'      => 'theme_mod',
            'sanitize_callback' => 'esc_url_raw'
        )
    );

    $wp_customize->add_control(
        'forexn_ctah_btn_url', 
        array(
            'label'   => __('Button URL', 'forexn'),
            'section' => 'forexn_footer_contact',
            'priority'  => 12
        )
    );

    $wp_customize->add_setting(
        'forexn_ctah_btn_text', 
        array(
            'default'   => '',
            'type'      => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'forexn_ctah_btn_text', 
        array(
            'label'   => __('Button Text', 'forexn'),
            'section' => 'forexn_footer_contact',
            'priority'  => 10
        )
    );
}
add_action( 'customize_register', 'forexn_customize_register' );