<?php 
/**
 * Template Name: Home Page
 *
 */
get_header();

// Slider Section Start .....................................................................

	$slide_show=get_theme_mod('forexn_show_banner_section', ''); 
	$slider_no = 3;
	$forexn_pages  = array();
    for( $k = 1; $k <= $slider_no; $k++ ) {
        $forexn_pages[]  = get_theme_mod( "forexn_slider_page_$k",true );
        $btntxt[]    =  get_theme_mod( "forexn_slider_btntxt_$k", '' );
        $btnurl[]    =  get_theme_mod( "forexn_slider_btnurl_$k", '' );
        $btntxt2[]    =  get_theme_mod( "forexn_slider_btntxt2_$k", '' );
        $btnurl2[]    =  get_theme_mod( "forexn_slider_btnurl2_$k", '' );
    }
    $slider_args  = array(
    'post_type' => 'page',
    'post__in' => array_map( 'absint', $forexn_pages ),
    'posts_per_page' => absint($slider_no ),
    'orderby' => 'post__in' ); 
    $slider_query = new wp_Query( $slider_args );
    if ($slide_show =='true' && $slider_query->have_posts() ) { ?>
        <div class="slider-main owl-carousel">
           <?php $count=0; while($slider_query->have_posts()): $slider_query->the_post(); ?>
            <!-- slider item  -->
            <div class="item">
                <?php if(has_post_thumbnail()) : ?>
                    <?php the_post_thumbnail(); ?>
                <?php endif; ?>
                <div class="overlay">
                    <div class="slide-text text-center">
                        <h2> <?php the_title(); ?> </h2>
                        <?php the_content(); ?>
                        <div class="slider-btns">
                          <?php if ( !empty( $btntxt[$count] ) && !empty( $btnurl[$count]) ) { ?>
                            <a class="btn btn-custom" href="<?php echo esc_url($btnurl[$count]); ?>"><?php echo esc_html($btntxt[$count]); ?></a>
                            <?php }

                            if(!empty($btntxt2[$count]) && !empty( $btnurl2[$count]) ) { ?>
                            <a class="btn btn-custom active" href="<?php echo esc_url($btnurl2[$count]); ?>"><?php echo esc_html($btntxt2[$count]); ?></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
             <?php $count=$count+1; endwhile; wp_reset_postdata();
            ?>
        </div>

        <div class="nav-dot-container">
            <div class="inner-con">
                <div class="slider-dot-con"></div>
            </div>
        </div>
    <?php  }  else { ?>

    <div class="page-title page-banner">
      <div class="container">
        <?php if(is_home()): ?>
        <h2 class="title"><?php bloginfo('name'); ?></h2>
        <?php else: ?>
          <h2 class="title"><?php if ( is_archive() ) {
            the_archive_title(); 
           }
           elseif(is_search()){
            esc_html_e('Search Results For ', 'forexn') . ' " ' . get_search_query() . ' "';
           }elseif ( is_404() ) {
            esc_html_e('Nothing Found ', 'forexn'); }
           else{ 
              echo esc_html( get_the_title() ); 
            } 
           ?>
          </h2>
        <?php endif; 
        forexn_breadcrumb_trail(); ?>
      </div>
    </div>
    <?php } ?>
    </div> 

    <?php
// about Section Start....................................................................

    $forexn_about_section= get_theme_mod('forexn_show_About_section','');
    $forexn_about_heading= get_theme_mod('forexn_about_heading','About Us');
    $forexn_about_sub_heading= get_theme_mod('forexn_about_sub_heading','Lorem ipsum dolor sit amet,consectetur adipisicing elit.');     
    $forexn_abouts_no        = 1;
    $forexn_abouts_pages      = array();

    for( $i = 1; $i <= $forexn_abouts_no; $i++ ) {
        $forexn_abouts_pages[]    =  get_theme_mod( "forexn_About_page_$i", 1 );
    }

    $forexn_abouts_args  = array(
        'post_type' => 'page',
        'post__in' => array_map( 'absint', $forexn_abouts_pages ),
        'posts_per_page' => absint($forexn_abouts_no),
        'orderby' => 'post__in'
    ); 
    $forexn_abouts_query = new WP_Query( $forexn_abouts_args ); 
    if($forexn_about_section=='true'){ ?>
    <section class="section-padding page-section about-section">
        <div class="container">
            <div class="row">
                <div class="col-md-12">

                  <?php if(!empty($forexn_about_heading && $forexn_about_sub_heading)): ?>
                    <h3 class="section-heading">
                        <?php echo esc_html($forexn_about_heading); ?>
                    </h3>
                    <p class="subtitle">
                        <?php echo esc_html($forexn_about_sub_heading); ?>
                    </p> 
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <?php $count = 0;
                        while($forexn_abouts_query->have_posts() && $count <= 1 ) :
                        $forexn_abouts_query->the_post(); ?>
                        <?php if(!has_post_thumbnail()){  ?>
<div class="col-md-12">
<?php } else {?>
                <div class="col-md-6">
                <?php } ?>
                    <div class="page-content mb-5">
                       <?php the_content(); ?> 
                    </div>
                </div>
                <?php if(has_post_thumbnail()): ?>
                <div class="col-md-6">
                    <div class="abt-img">
                        <?php the_post_thumbnail(); ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php $count = $count + 1; endwhile; wp_reset_postdata(); ?>
            </div>
        </div>
    </section>

<?php }
// Service Section Start....................................................................

	$forexn_service_section= get_theme_mod('forexn_show_service_section','');
    $forexn_service_heading= get_theme_mod('forexn_service_heading','Our Services');
    $forexn_service_sub_heading= get_theme_mod('forexn_service_sub_heading','Lorem ipsum dolor sit amet,consectetur adipisicing elit, sed do eiu tempore incididunt ut labore et dolore magna aliqua.');	 
	$forexn_services_no        = 6;
	$forexn_services_pages      = array();
	$forexn_services_icons     = array();

	for( $i = 1; $i <= $forexn_services_no; $i++ ) {
	    $forexn_services_pages[]    =  get_theme_mod( "forexn_service_page_$i", 1 );
	    $forexn_services_icons[]    = get_theme_mod( "forexn_page_service_icon_$i", '' );
	}

	$forexn_services_args  = array(
	    'post_type' => 'page',
	    'post__in' => array_map( 'absint', $forexn_services_pages ),
	    'posts_per_page' => absint($forexn_services_no),
	    'orderby' => 'post__in'
	); 
	$forexn_services_query = new WP_Query( $forexn_services_args ); 
    if($forexn_service_section=='true'){ ?>
	<section class="service-section service-1 section-padding">
	    <div class="container">
	        <div class="row">
	            <div class="col-lg-3">
                    <?php if(!empty($forexn_service_heading && $forexn_service_sub_heading)): ?>
	                <div class="service-head section-heading mb-4">	                 
	                    <h3><?php echo esc_html($forexn_service_heading); ?></h3>                    
	                </div>
	                <p class="subtitle"><?php echo esc_html($forexn_service_sub_heading); ?>
                    </p>
                <?php endif; ?>
	                <div class="service-nav"></div>
	            </div>
	            
	            <div class="col-lg-9">
	                <div class="service-slider owl-carousel">
	                <?php $count = 0;
	                    while($forexn_services_query->have_posts() && $count <= 5 ) :
	                    $forexn_services_query->the_post(); ?>
	                        <div class="service-box">
	                            <div class="service-icon">
	                                <?php if($forexn_services_icons[$count] !=""){ ?>
	                                <i class="fa <?php echo esc_attr($forexn_services_icons[$count]); ?>"></i>
	                                <?php } ?>
	                            </div>
	                            <h4 class="service-title"><?php the_title(); ?></h4>
	                            <?php the_excerpt(); ?>
	                            <a href="<?php the_permalink() ?>" class="read-more"><?php  esc_html_e('Read More','forexn'); ?></a>
	                        </div>
	                    <?php $count = $count + 1; endwhile; wp_reset_postdata(); ?>  
	                </div>
	            </div>
	        </div>
	    </div>
	</section>
	<?php }


if(have_posts()) : 
  while(have_posts()) : the_post();
    if(get_the_content()!= "")
    {
    ?>
      <section class="service-section service-1 section-padding">
          <div class="container">
            <div class="row">
          <?php the_content(); ?> 
        </div>
        </div> 
      </section>  
    <?php 
    } 
  endwhile;
endif; 
// Service Section Ends .....................................................................

// Client Section Start......................................................................

	$forexn_enable_partner= get_theme_mod('forexn_show_partner_section',''); 
	$partner_no        = 6;
	$partner_pages      = array();
	for( $i = 1; $i <= $partner_no; $i++ ) {
	    $partner_pages[]    =  get_theme_mod( "forexn_partner_page_$i", 1 );
	}
	$partner_args  = array(
	'post_type' => 'page',
	'post__in' => array_map( 'absint', $partner_pages ),
	'posts_per_page' => absint($partner_no),
	'orderby' => 'post__in'
	);    
	$partner_query = new   WP_Query( $partner_args );
	if( $forexn_enable_partner == "true" && $partner_query->have_posts() ) :?>

		<section class="clients-feed section-padding">
		    <div class="container">
		        <div class="row">
		            <div class="col-sm-6 col-md-12 col-lg-12">
		                <div class="partners ">
		                    <h3 class="section-heading txt-white">
		                        <?php esc_html_e('Our Clents','forexn'); ?>
		                    </h3>
		                    <ul class="clients clearfix">
		                        <?php while($partner_query->have_posts()) : $partner_query->the_post(); ?>
		                        <li> <?php  the_post_thumbnail(); ?> </li>
		                        <?php endwhile; wp_reset_postdata(); ?> 
		                    </ul>
		                </div>
		            </div>
		        </div>
		    </div>
		</section>
	<?php endif;

// Client Section Ends .....................................................................

// Blog Section Start ......................................................................
	
	$forexn_blog_section= get_theme_mod('forexn_show_blog_section','true');
	if($forexn_blog_section=='true'){
	$forexn_btn_blog = get_theme_mod('forexn_btn_blog',"");           
	$forexn_blog_title=get_theme_mod('forexn_blog_title','Latest News');
	$forexn_blog_subtitle=get_theme_mod('forexn_blog_subtitle');  
	?>
    <section class="section-padding blog-section">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h3 class="section-heading">
                        <?php if($forexn_blog_title !="") { ?>
                        <?php echo esc_html($forexn_blog_title); ?>
                        <?php } ?>
                    </h3>
                    <p class="subtitle">
                        <?php if($forexn_blog_subtitle !="") { ?>
                        <?php echo esc_html($forexn_blog_subtitle); ?>
                        <?php } ?>
                    </p>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <?php  $forexn_latest_blog_posts = new WP_Query( array( 'posts_per_page' => absint( get_theme_mod( 'news_number_post', 3 ) ) ) );  if ( $forexn_latest_blog_posts->have_posts() ) :  while ( $forexn_latest_blog_posts->have_posts() ) : $forexn_latest_blog_posts->the_post(); ?>
                    <div class="col-lg-4 col-sm-6 col-xs-12">
                        <div <?php post_class('blog-sm'); ?>>
                            <div class="featured-img">
                                <a class=" img-fluid" href="<?php the_permalink() ?>"><?php the_post_thumbnail(); ?></a>
                            </div>
                            <div class="blog-content">
                                <ul class="blog-meta">
                                    <li>
                                        <a href="<?php echo esc_url( get_day_link( get_the_time('Y'), get_the_time('m'), get_the_time('d') ) ) ; ?>">
                                            <i class="fa fa-calendar"></i><?php echo esc_html(get_the_date()); ?></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                            <i class="fa fa-user"></i> <?php esc_html(the_author()); ?></a>
                                    </li>
                                </ul>
                                <h4 class="blog-head">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h4>
                               <?php the_excerpt(); ?>
                            </div>
                             <a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e('Read More','forexn'); ?></a>
                        </div>
                    </div>
                <?php endwhile; endif; ?>
            </div>
        </div>
    </section>
    <?php }
	
// Blog Section Ends .....................................................................


// Callout Section Start .................................................................

    $forexn_callout_section= get_theme_mod('forexn_show_callout_section','');
    if($forexn_callout_section=='true'){
        $forexn_ctah_btn_text = get_theme_mod('forexn_ctah_btn_text'); 
        $forexn_ctah_btn_url = get_theme_mod('forexn_ctah_btn_url'); 
        $forexn_ctah_heading = get_theme_mod('forexn_ctah_heading'); ?>   
    
    <section class="contact-bar section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-9 col-lg-8 col-xl-7">
                    <h3 class="subline">
                        <?php if($forexn_ctah_heading) { ?>
                        <?php echo esc_html($forexn_ctah_heading); ?>
                        <?php } ?>
                    </h3>
                </div>
                <?php if($forexn_ctah_btn_text !="" && $forexn_ctah_btn_url!="") { ?>
                <div class="col-md-3 col-lg-4 col-xl-5 con-btn">
                    <a href="<?php echo esc_url($forexn_ctah_btn_url); ?>" class="btn btn-contact my-1">
                        <?php echo esc_html($forexn_ctah_btn_text); ?></a>
                </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } 

// Callout Section Start..................................................................

get_footer(); ?>