<?php 
/**
 * The header for our theme.
 *
 * Displays all of the <head> section 
 *
 * @package forexn
 */
 ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="https://gmpg.org/xfn/11" />
  <!--Shortcut icon-->

  <?php wp_head(); ?>
</head> 
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div id="page" class="site">
<a class="skip-link screen-reader-text" href="#content">
<?php esc_html_e( 'Skip to content', 'forexn' ); ?></a>

<a href="<?php esc_attr__("#",'forexn'); ?>" id="back-to-top" class="back-to-top fa fa-arrow-up"></a>
<div class="preloader">
    <div class="loader-inner">
         <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/preloader.gif">
    </div>
</div>
<!-- Search Form -->
    <div id="search">
        <span class="close"><?php esc_html_e( 'x', 'forexn' ); ?></span>
        <?php get_search_form(); ?>
    </div>

<?php get_template_part( 'inc/top-header'); ?>
<!-- slider section starts -->
<div class="slider-area">
<!-- menubar  -->
    <header id="masthead" class="menubar-fixed affix" <?php if( !is_page_template( 'template-home.php' ) ) { echo 'header-inner'; }  ?> role="banner" >
          <div class="container">
              <div class="nav-panel clearfix">
                  
                   <?php 
                    if( function_exists( 'has_custom_logo' ) && has_custom_logo() ){
                       the_custom_logo();
                    } 
                     if (display_header_text()==true){ 
                    ?>
                    
                        <h1 class="site-title" itemprop="name"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                    
                        
                    <?php 
                        $description = get_bloginfo( 'description', 'display' );
                    if ( $description || is_customize_preview() ) : ?>
                        <p class="site-description" itemprop="description"><?php echo esc_html($description); ?></p>
                    <?php
                    endif; }?>  
               
                  <!-- menu -->
          <nav id="site-navigation" class="main-navigation">
                       <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><i class="fa fa-bars"></i></button>

                                 <?php
                                    wp_nav_menu( array(
                                        'theme_location' => 'primary',
                                        'menu_id'        => 'primary-menu',
                                    ) );
                                    ?>
                    </nav>
              </div>
          </div>
        </header>
<div id="content"></div>