<?php 

/**
 * forexn functions and definitions
 * @package forexn
 */

if( ! function_exists( 'forexn_theme_setup' ) )
 {

	function forexn_theme_setup() {
		
	    load_theme_textdomain( 'forexn', get_template_directory() . '/lang' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		
		// Add default title support
		add_theme_support( 'title-tag' ); 		

		// Add default logo support		
        add_theme_support( 'custom-logo' );		

		// Custom Backgrounds
		add_theme_support('post-thumbnails');
		$defaults = array(
			'default-image'          => get_template_directory_uri() .'/assets/images/header-img.jpg',
			'default-text-color'     => '000000',
			'width'                  => 1000,
			'height'                 => 250,
			'flex-height'            => true,
            'wp-head-callback'       => 'forexn_header_style',
			);
		add_theme_support( 'custom-header', $defaults );

		/**
		* Set the content width in pixels, based on the theme's design and stylesheet.
		*/
		$GLOBALS['content_width'] = apply_filters( 'forexn_content_width', 980 );
		
		// Add theme support for Semantic Markup
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption'
		) );
		 
		add_theme_support( 'customize-selective-refresh-widgets' );
		 
		// add excerpt support for pages
		add_post_type_support( 'page', 'excerpt' );
		
		if ( is_singular() && comments_open() ) {
			wp_enqueue_script( 'comment-reply' );
		}
	   
		// Menus
		//add_theme_support( 'menus' );

        register_nav_menus(array(
       'primary' => esc_html__('primary Menu', 'forexn')
       ));		

	}
	add_action( 'after_setup_theme', 'forexn_theme_setup' );
}


    function forexn_header_style() {
        $header_text_color = get_header_textcolor(); ?>
            <style type="text/css">
            <?php
				//Check if user has defined any header image.
			if ( get_header_image() ) :
			?>
			.page-banner
			  {
				background-image:url('<?php header_image(); ?>');
				background-size: cover;
			  }

			<?php endif; ?>                                
               .site-title, .site-title a, .site-description{
                    color: #<?php echo esc_attr($header_text_color); ?>;        
                }                                
            </style>
        <?php
    }

    function forexn_sidebars() {

	register_sidebar(array(
		'name' => esc_html__( 'Blog Sidebar', "forexn"),
		'id' => 'blog-sidebar',
		'description' => esc_html__( 'Sidebar on the blog layout.', "forexn"),
		'before_widget' => '<div id="%1$s" class="%2$s widget-content">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	));
		
	register_sidebar(array(
		'name' => esc_html__( 'Footer Widget Area', "forexn"),
		'id' => 'forexn-footer-widget-area',
		'description' => esc_html__( 'The footer widget area', "forexn"),
		'before_widget' => '<div class="%2$s footer-widget col-md-4 col-sm-6 col-xs-12">',
		'after_widget' => '</div>',
		'before_title' => ' <h3>',
		'after_title' => '</h3>',
	));	
		
	}
	add_action( 'widgets_init', 'forexn_sidebars' );


/**
 * @package forexn
 */

function forexn_inline_styles(){
	$forexn_slider_opacity_section = esc_attr(get_theme_mod( 'forexn_slider_opacity_section', '.85' ));
	$color_css = "

.slider-main .overlay::before{ opacity: $forexn_slider_opacity_section !important;
                }';	
}";

    return forexn_css_strip_whitespace($color_css);
}

function forexn_css_strip_whitespace($css){
	  $replace = array(
	    "#/\*.*?\*/#s" => "",  // Strip C style comments.
	    "#\s\s+#"      => " ", // Strip excess whitespace.
	  );
	  $search = array_keys($replace);
	  $css = preg_replace($search, $replace, $css);

	  $replace = array(
	    ": "  => ":",
	    "; "  => ";",
	    " {"  => "{",
	    " }"  => "}",
	    ", "  => ",",
	    "{ "  => "{",
	    ";}"  => "}", // Strip optional semicolons.
	    ",\n" => ",", // Don't wrap multiple selectors.
	    "\n}" => "}", // Don't wrap closing braces.
	    "} "  => "}\n", // Put each rule on it's own line.
	  );
	  $search = array_keys($replace);
	  $css = str_replace($search, $replace, $css);

	  return trim($css);
}

require get_template_directory(). '/inc/customizer.php';
require get_template_directory(). '/inc/enqueue.php';
require get_template_directory(). '/inc/template-tags.php';
if ( ! function_exists( 'breadcrumb_trail' ) ) {
	require get_template_directory() . '/inc/breadcrumbs-trail.php';
}
require get_template_directory() . '/inc/breadcrumbs.php';



//=============================================================
// Body open hook
//=============================================================
if ( ! function_exists( 'wp_body_open' ) ) {
    /**
     * Body open hook.
     */
    function wp_body_open() {
        do_action( 'wp_body_open' );
    }
}

require_once( trailingslashit( get_template_directory() ) . '/inc/upgrade/class-customize.php' );

/**
* display notice 
**/

if ( $pagenow == 'index.php' || $pagenow == 'themes.php' ) {
	add_action( 'admin_notices', 'astral_activation_notice' );
}

function astral_activation_notice(){
$my_theme = wp_get_theme();	
?>
    <style>
		a.reply-btn {
			display: initial;
			margin: 0 auto;
			border-radius: 4px;
			color: #fff;
			background: #0e6ec4;
			padding: 10px;
			text-decoration: none;
		}
		.hello-elementor-notice-content {
			padding: 28px;
			text-align: center;
		}
		.notice h3 {
			margin: 0 0 5px;
		}
		.notice.updated.is-dismissible {
			padding: 15px;
		}
		a.rate-btn {
			font-size: 11px;
			text-decoration: none;
			background: #153e4d;
			padding: 3px 10px;
			color: #fff;
		}
		a.support-btn {
			margin-left: 10px;
			text-decoration: none;
		}
		.review-page {
			background: rgba(221, 240, 249, 0.8) !important;
			padding: 15px;
			border-left-color: #e0f0f7 !important;
		}
		.notice.updated.is-dismissible.review-page {
			border-left: 1px solid #ccd0d4 !important;
		}
		.corona-msg {
			padding: 17px 0 0 !important;
		}
		.corona-msg span {
		    font-style: oblique;
		    font-size: 19px;
		    font-weight: 600;
		    color: #ffbc00;
		}
		a.astra-pro {
		    font-weight: 600;
		    font-size: 18px;
		}
		a.rainbow2 {
    background-color: #ffc247;
    background-image: gradient( linear, left top, right top, color-stop(0, #f22), color-stop(0.15, #f2f), color-stop(0.3, #22f), color-stop(0.45, #2ff), color-stop(0.6, #2f2),color-stop(0.75, #2f2), color-stop(0.9, #ff2), color-stop(1, #f22) );
    color: #fff;
    /* -webkit-background-clip: text; */
    background-clip: text;
    padding: 10px;
    text-decoration: none;
}

.blinking{
    animation:blinkingText 1.2s infinite;
}
@keyframes blinkingText{
    0%{     color: transparent;    }
    49%{    color: transparent; }
    60%{    color: #ff0000; }
    99%{    color:#ff0000;  }
    100%{   color: #ff0000;    }
}
	</style>

    <div class="notice updated is-dismissible review-page">
		<div class="hello-elementor-notice-inner">
			<div class="hello-elementor-notice-content">
				<h3> <?php _e('Thank you for installing', 'forexn'); ?> <?php echo $my_theme->get( 'Name' ); ?>
				<?php echo esc_html_e('Version - ','forexn'); ?>
				 <?php echo esc_html( $my_theme->get('Version') ); ?>
				</h3>
				
				<p style="margin-bottom: 18px;"><?php 
				_e(' Are you are enjoying Forexn? We would love to hear your feedback. Big thanks in advance.','forexn'); ?> </p>
				<a target="_blank" class="reply-btn" href="https://wordpress.org/support/theme/forexn/reviews/#new-post"> <?php _e('Submit a review','forexn'); ?> </a>
				
				<a target="_blank" class="reply-btn" style="margin-left: 18px;" href="<?php echo admin_url('/themes.php?page=forexn'); ?>" > <?php _e('Welcome Page','forexn'); ?> </a>

				<a target="_blank" class="astra-pro rainbow2" style="margin-left: 18px;" href="<?php echo esc_url('http://wpcart.net/'); ?>" > <?php _e('forexn Pro','forexn'); ?> </a>
				
			</div>
		</div>
	</div>
<?php }

if (is_admin()) {
	require_once('inc/forexn-intro.php');
} ?> 