/**
 * File navigation.js.
 *
 * Handles toggling the navigation menu for small screens and enables TAB key
 * navigation support for dropdown menus.
 */
( function() {
	var forexn_container, forexn_button, forexn_menu, forexn_links, i, len;

	forexn_container = document.getElementById( 'site-navigation' );
	if ( ! forexn_container ) {
		return;
	}

	forexn_button = forexn_container.getElementsByTagName( 'button' )[0];
	if ( 'undefined' === typeof forexn_button ) {
		return;
	}

	forexn_menu = forexn_container.getElementsByTagName( 'ul' )[0];

	// Hide menu toggle button if menu is empty and return early.
	if ( 'undefined' === typeof forexn_menu ) {
		forexn_button.style.display = 'none';
		return;
	}

	forexn_menu.setAttribute( 'aria-expanded', 'false' );
	if ( -1 === forexn_menu.className.indexOf( 'nav-menu' ) ) {
		forexn_menu.className += ' nav-menu';
	}

	forexn_button.onclick = function() {
		if ( -1 !== forexn_container.className.indexOf( 'toggled' ) ) {
			forexn_container.className = forexn_container.className.replace( ' toggled', '' );
			forexn_button.setAttribute( 'aria-expanded', 'false' );
			forexn_menu.setAttribute( 'aria-expanded', 'false' );
		} else {
			forexn_container.className += ' toggled';
			forexn_button.setAttribute( 'aria-expanded', 'true' );
			forexn_menu.setAttribute( 'aria-expanded', 'true' );
		}
	};

	// Get all the link elements within the menu.
	forexn_links    = forexn_menu.getElementsByTagName( 'a' );

	// Each time a menu link is focused or blurred, toggle focus.
	for ( i = 0, len = forexn_links.length; i < len; i++ ) {
		forexn_links[i].addEventListener( 'focus', toggleFocus, true );
		forexn_links[i].addEventListener( 'blur', toggleFocus, true );
	}

	/**
	 * Sets or removes .focus class on an element.
	 */
	function toggleFocus() {
		var self = this;

		// Move up through the ancestors of the current link until we hit .nav-menu.
		while ( -1 === self.className.indexOf( 'nav-menu' ) ) {

			// On li elements toggle the class .focus.
			if ( 'li' === self.tagName.toLowerCase() ) {
				if ( -1 !== self.className.indexOf( 'focus' ) ) {
					self.className = self.className.replace( ' focus', '' );
				} else {
					self.className += ' focus';
				}
			}

			self = self.parentElement;
		}
	}

/**
	 * Toggles `focus` class to open Menu.
	 */
forexn_button.onfocus = function() {
		if ( -1 !== forexn_container.className.indexOf( 'toggled' ) ) {
			forexn_container.className = forexn_container.className.replace( ' toggled', '' );
			forexn_button.setAttribute( 'aria-expanded', 'false' );
			forexn_menu.setAttribute( 'aria-expanded', 'false' );
		} else {
			forexn_container.className += ' toggled';
			forexn_button.setAttribute( 'aria-expanded', 'true' );
			forexn_menu.setAttribute( 'aria-expanded', 'true' );
		}
	};
	/**
	 * Toggles `focus` class to allow submenu access on tablets.
	 */
	( function( forexn_container ) {
		var touchStartFn, i,
			parentLink = forexn_container.querySelectorAll( '.menu-item-has-children > a, .page_item_has_children > a' );

		if ( 'ontouchstart' in window ) {
			touchStartFn = function( e ) {
				var menuItem = this.parentNode, i;

				if ( ! menuItem.classList.contains( 'focus' ) ) {
					e.preventDefault();
					for ( i = 0; i < menuItem.parentNode.children.length; ++i ) {
						if ( menuItem === menuItem.parentNode.children[i] ) {
							continue;
						}
						menuItem.parentNode.children[i].classList.remove( 'focus' );
					}
					menuItem.classList.add( 'focus' );
				} else {
					menuItem.classList.remove( 'focus' );
				}
			};

			for ( i = 0; i < parentLink.length; ++i ) {
				parentLink[i].addEventListener( 'touchstart', touchStartFn, false );
			}
		}
	}( forexn_container ) );
} )();
