<?php

$page_builder = __( 'Page Builder', 'foodpark' );
$page_builder_details = __( 'FoodPark Pro supports Page Builder. All our shortcodes can be used as widgets too. You can drag and drop our widgets with page builder visual editor.', 'foodpark' );
$page_layout = __( 'Page Layout', 'foodpark' );
$page_layout_details = __( 'FoodPark Pro offers many different page layouts so you can quickly and easily create your pages with various layout without any hassle!', 'foodpark' );
$unlimited_sidebar = __( 'Unlimited Sidebar', 'foodpark' );
$unlimited_sidebar_details = __( 'Unlimited sidebars allows you to create multiple sidebars. Check out our demo site to see how different pages displays different sidebars!', 'foodpark' );
$shortcode_builder = __( 'Shortcode Builder', 'foodpark' );
$shortcode_builder_details = __( 'With our shortcode builder and lots of shortcodes, you can easily create nested shortcodes and build custom pages!', 'foodpark' );
$portfolio = __( 'Multi Portfolio', 'foodpark' );
$portfolio_details = __( '7 portfolio layouts with Isotope filtering, 3 blog layouts and multiple other alternate layouts for interior pages!', 'foodpark' );
$typography = __( 'Typography', 'foodpark' );
$typography_details = __( 'FoodPark Pro loves typography, you can choose from over 500+ Google Fonts and Standard Fonts to customize your site!', 'foodpark' );
$slider = __( 'Awesome Sliders', 'foodpark' );
$slider_details = __( 'FoodPark Pro includes two types of slider. You can use both Flex and Elastic sliders anywhere in your site.', 'foodpark' );
$woocommerce = __( 'Woo Commerce', 'foodpark' );
$woocommerce_details = __( 'FoodPark Pro has full design/code integration for WooCommerce, your shop will look as good as the rest of your site!', 'foodpark' );
$custom_widget = __( 'Custom Widget', 'foodpark' );
$custom_widget_details = __( 'We offer many custom widgets that are stylized and ready for use. Simply drag &amp; drop into place to activate!', 'foodpark' );
$advanced_admin = __( 'Advanced Admin', 'foodpark' );
$advanced_admin_details = __( 'Advanced Redux Framework for theme options panel, you can customize any part of your site quickly and easily!', 'foodpark' );
$font_awesome = __( 'Font Awesome', 'foodpark' );
$font_awesome_details = __( 'Font Awesome icons are fully integrated into the theme. Use them anywhere in your site in 6 different sizes!', 'foodpark' );
$responsive_layout = __( 'Responsive Layout', 'foodpark' );
$responsive_layout_details = __( 'FoodPark Pro is fully responsive and can adapt to any screen size. Resize your browser window to view it!', 'foodpark' );
$testimonials = __( 'Testimonials', 'foodpark' );
$testimonials_details = __( 'With our testimonial post type, shortcode and widget, Displaying testimonials is a breeze.', 'foodpark' );
$social_media = __( 'Social Media', 'foodpark' );
$social_media_details = __( 'Want your users to stay in touch? No problem, FoodPark Pro has Social Media icons all throughout the theme!', 'foodpark' );
$google_map = __( 'Google Map', 'foodpark' );
$google_map_details = __( 'FoodPark Pro includes Goole Map as shortcode and widget. So, you can use it anywhere in your site!', 'foodpark' );
$view_demo = __( 'View Demo', 'foodpark');
$upgrade_to_pro = __( 'Upgrade To Pro', 'foodpark' );


$why_upgrade = <<< FEATURES
<p class="wrap-header">
    <a class="view-demo" href="http://demo.webulous.in/foodpark/">
        <i class="fa fa-eye"></i> $view_demo</a> 
    <a class="upgrade" href="http://www.webulousthemes.com/?add-to-cart=1530">
        <i class="fa fa-upload"></i> $upgrade_to_pro</a>
</p>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-cog"></i></div>
	<h3>$page_builder</h3>
	<p>$page_builder_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-th-large"></i></div>
	<h3>$page_layout</h3>
	<p>$page_layout_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-th"></i></div>
	<h3>$unlimited_sidebar</h3>
	<p>$unlimited_sidebar_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-code-fork"></i></div>
	<h3>$shortcode_builder</h3>
	<p>$shortcode_builder_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-camera"></i></div>
	<h3>$portfolio</h3>
	<p>$portfolio_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-font"></i></div>
	<h3>$typography</h3>
	<p>$typography_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-slideshare"></i></div>
	<h3>$slider</h3>
	<p>$slider_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-leaf"></i></div>
	<h3>$woocommerce</h3>
	<p>$woocommerce_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-tasks"></i></div>
	<h3>$custom_widget</h3>
	<p>$custom_widget_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-dashboard"></i></div>
	<h3>$advanced_admin</h3>
	<p>$advanced_admin_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-magic"></i></div>
	<h3>$font_awesome</h3>
	<p>$font_awesome_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-arrows"></i></div>
	<h3>$responsive_layout</h3>
	<p>$responsive_layout_details</p>
</div>
<div class="one-third column clear">
	<div class="icon-wrap"><i class="fa  fa-5x fa-magic"></i></div>
	<h3>$testimonials</h3>
	<p>$testimonials_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-twitter"></i></div>
	<h3>$social_media</h3>
	<p>$social_media_details</p>
</div>
<div class="one-third column">
	<div class="icon-wrap"><i class="fa  fa-5x fa-map-marker"></i></div>
	<h3>$google_map</h3>
	<p>$google_map_details</p>
</div>
FEATURES;

function foodpark_theme_page() {
	add_theme_page( 
		__( 'Upgrade To FoodPark Pro', 'foodpark') ,
		__( 'Theme Upgrade', 'foodpark' ),
		'edit_theme_options',
		'wbls_upgrade',
		'foodpark_display_upgrade'
	);
}

add_action('admin_menu','foodpark_theme_page');


function foodpark_display_upgrade() {
	global $why_upgrade;
	echo '<div class="wrap">';
	echo $why_upgrade;
	echo '</div>';
}

	$options = array(
		'capability' => 10,
		'type' => 'theme_mod',
		'root' => array(
		),
		'panels' => array(
			'foodpark' => array(
				'priority'       => 9,
				'title'          => __('FoodPark Options', 'foodpark'),
				'description'    => __('FoodPark Theme Options', 'foodpark'),
				'sections' => array(
					'general' => array(
						'title' => __('General', 'foodpark'),
						'description' => __('General settings that affects overall site', 'foodpark'),
						'fields' => array(
							'breadcrumb' => array(
								'type' => 'checkbox',
								'label' => __('Enable Breadcrumb', 'foodpark'),
								'default' => 0,
								'sanitize_callback' => 'foodpark_boolean',
							),
							'breadcrumb_char' => array(
								'type' => 'select',
								'label' => __('Select Breadcrumb Character', 'foodpark'),
								'choices' => array(
									'1' => '&raquo;',
									'2' => ' / ',
									'3' => ' > '
								),
								'sanitize_callback' => 'foodpark_breadcrumb_char_choices',
								'default' => '1',
							),
						),
					),
					'header' => array(
						'title' => __('Header', 'foodpark'),
						'description' => __('Header options', 'foodpark'),
						'fields' => array(
							'logo_title' => array(
								'type' => 'checkbox',
								'label' => __('Logo as Title', 'foodpark'),
								'default' => 0,
								'sanitize_callback' => 'foodpark_boolean',
							),
							'logo' => array(
								'type' => 'image',
								'label' => __('Upload Logo', 'foodpark'),
								'sanitize_callback' => 'esc_url_raw',
							),
							'tagline' => array(
								'type' => 'checkbox',
								'label' => __('Show site Tagline', 'foodpark'),
								'default' => 0,
								'sanitize_callback' => 'foodpark_boolean',
							),
						),
					),
					'home' => array(
						'title' => __('Home', 'foodpark'),
						'description' => __('Home Page options', 'foodpark'),
						'fields' => array(
							'slider' => array(
								'type' => 'category',
								'label' => __('Slider Posts Category', 'foodpark'),
								'sanitize_callback' => 'absint',
							),
							'slider_count' => array(
								'type' => 'text',
								'label' => __('No. of Sliders', 'foodpark'),
								'sanitize_callback' => 'absint',
							),
							'service_1' => array(
								'type' => 'dropdown-pages',
								'label' => __('Service Section #1', 'foodpark'),
								'sanitize_callback' => 'absint',
							),
							'service_2' => array(
								'type' => 'dropdown-pages',
								'label' => __('Service Section #2', 'foodpark'),
								'sanitize_callback' => 'absint',
							),
							'service_3' => array(
								'type' => 'dropdown-pages',
								'label' => __('Service Section #3', 'foodpark'),
								'sanitize_callback' => 'absint',
							),
							'recent_posts_count' => array(
								'type' => 'text',
								'label' => __('No. of Recent Posts', 'foodpark'),
								'sanitize_callback' => 'absint',
							),
						),
					),
					'blog' => array(
						'title' => __('Blog', 'foodpark'),
						'description' => __('Blog related options', 'foodpark'),
						'fields' => array(
							'featured_image' => array(
								'type' => 'checkbox',
								'label' => __('Enable Featured Image', 'foodpark'),
								'default' => 1,
								'sanitize_callback' => 'foodpark_boolean',
							),
							'single_featured_image' => array(
								'type' => 'checkbox',
								'label' => __('Enable Single Post Featured Image', 'foodpark'),
								'default' => 1,
								'sanitize_callback' => 'foodpark_boolean',
							),
						),
					),
				)
			),
		)
	);

function foodpark_boolean($value) {
	if(is_bool($value)) {
		return $value;
	} else {
		return false;
	}
}

function foodpark_breadcrumb_char_choices($value='') {
	$choices = array('1','2','3');

	if( in_array($value, $choices)) {
		return $value;
	} else {
		return '1';
	}
}