<?php
/**
 * Template part for displaying posts
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

?>
<?php $fm_radio_station_column_layout = get_theme_mod( 'fm_radio_station_sidebar_post_layout');
if($fm_radio_station_column_layout == 'four-column' || $fm_radio_station_column_layout == 'three-column' ){ ?>
  <div id="category-post">
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
      <div class="page-box box-image">
         <?php
            // Get the post content
            $fm_radio_station_post_content = apply_filters('the_content', get_the_content());

            // Create a DOMDocument to parse the HTML content
            $dom = new DOMDocument();
            @$dom->loadHTML($fm_radio_station_post_content);

            // Find and display the first image in the post content
            $images = $dom->getElementsByTagName('img');

            echo ($images->length > 0)
                ? '<img src="' . esc_url($images->item(0)->getAttribute('src')) . '">'
                : '';
          ?>
          <div class="box-content mt-2 text-center">
              <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title();?></a></h4>
            <div class="box-info">
              <?php 
              // Add 'time' to your default meta order array
              $fm_radio_station_blog_archive_ordering = get_theme_mod('blog_meta_order', array('date', 'author', 'comment', 'category', 'time'));

              foreach ($fm_radio_station_blog_archive_ordering as $fm_radio_station_blog_data_order) : 
                if ('date' === $fm_radio_station_blog_data_order) : ?>
                    <i class="far fa-calendar-alt mb-1"></i>
                    <a href="<?php echo esc_url(get_day_link(get_the_date('Y'), get_the_date('m'), get_the_date('d'))); ?>" class="entry-date">
                        <?php echo esc_html(get_the_date('j F, Y')); ?>
                    </a>
                <?php elseif ('author' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-user mb-1"></i>
                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" class="entry-author">
                        <?php the_author(); ?>
                    </a>
                <?php elseif ('comment' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-comments mb-1"></i>
                    <a href="<?php comments_link(); ?>" class="entry-comments">
                        <?php comments_number(__('0 Comments', 'fm-radio-station'), __('1 Comment', 'fm-radio-station'), __('% Comments', 'fm-radio-station')); ?>
                    </a>
                <?php elseif ('category' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-list mb-1"></i>
                    <?php
                    $categories = get_the_category();
                    if (!empty($categories)) :
                        foreach ($categories as $category) : ?>
                            <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>" class="entry-category">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        <?php endforeach;
                    endif; 
                    ?>
                <?php elseif ('time' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-clock mb-1"></i>
                    <span class="entry-time">
                        <?php echo get_the_time(); ?>
                    </span>
                <?php endif;
            endforeach; ?>
          </div>
            <p><?php echo esc_html( wp_trim_words( get_the_content(), get_theme_mod( 'fm_radio_station_excerpt_count', 35 ) ) ); ?></p>
            <?php if(get_theme_mod('fm_radio_station_remove_read_button',true) != ''){ ?>
              <div class="readmore-btn">
                <a href="<?php echo esc_url( get_permalink() ); ?>" 
                   class="blogbutton-small" 
                   title="<?php echo esc_attr( get_theme_mod( 'fm_radio_station_read_more_text', __( 'Read More', 'fm-radio-station' ) ) ); ?>">
                    <?php echo esc_html( get_theme_mod( 'fm_radio_station_read_more_text', __( 'Read More', 'fm-radio-station' ) ) ); ?>
                </a>
              </div>
            <?php }?>
          </div>
          <div class="clearfix"></div>
      </div>
    </article>
  </div>
<?php } else{ ?>
<div id="category-post">
  <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="page-box row">
      <?php $fm_radio_station_post_layout = get_theme_mod( 'fm_radio_station_post_layout','image-content');
      if($fm_radio_station_post_layout == 'image-content'){ ?>
        <div class="box-image col-lg-6 col-md-12 align-self-center">
          <?php
            // Get the post content
            $fm_radio_station_post_content = apply_filters('the_content', get_the_content());

            // Create a DOMDocument to parse the HTML content
            $dom = new DOMDocument();
            @$dom->loadHTML($fm_radio_station_post_content);

            // Find and display the first image in the post content
            $images = $dom->getElementsByTagName('img');

            echo ($images->length > 0)
                ? '<img src="' . esc_url($images->item(0)->getAttribute('src')) . '">'
                : '';
            ?>
        </div>
        <div class="box-content col-lg-6 col-md-12">
          <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title();?></a></h4>
          <div class="box-info">
              <?php 
              // Add 'time' to your default meta order array
              $fm_radio_station_blog_archive_ordering = get_theme_mod('blog_meta_order', array('date', 'author', 'comment', 'category', 'time'));

              foreach ($fm_radio_station_blog_archive_ordering as $fm_radio_station_blog_data_order) : 
                if ('date' === $fm_radio_station_blog_data_order) : ?>
                    <i class="far fa-calendar-alt mb-1"></i>
                    <a href="<?php echo esc_url(get_day_link(get_the_date('Y'), get_the_date('m'), get_the_date('d'))); ?>" class="entry-date">
                        <?php echo esc_html(get_the_date('j F, Y')); ?>
                    </a>
                <?php elseif ('author' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-user mb-1"></i>
                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" class="entry-author">
                        <?php the_author(); ?>
                    </a>
                <?php elseif ('comment' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-comments mb-1"></i>
                    <a href="<?php comments_link(); ?>" class="entry-comments">
                        <?php comments_number(__('0 Comments', 'fm-radio-station'), __('1 Comment', 'fm-radio-station'), __('% Comments', 'fm-radio-station')); ?>
                    </a>
                <?php elseif ('category' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-list mb-1"></i>
                    <?php
                    $categories = get_the_category();
                    if (!empty($categories)) :
                        foreach ($categories as $category) : ?>
                            <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>" class="entry-category">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        <?php endforeach;
                    endif; 
                    ?>
                <?php elseif ('time' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-clock mb-1"></i>
                    <span class="entry-time">
                        <?php echo get_the_time(); ?>
                    </span>
                <?php endif;
            endforeach; ?>
          </div>
          <p><?php echo esc_html( wp_trim_words( get_the_content(), get_theme_mod( 'fm_radio_station_excerpt_count', 35 ) ) ); ?></p>
          <?php if(get_theme_mod('fm_radio_station_remove_read_button',true) != ''){ ?>
            <div class="readmore-btn">
                <a href="<?php echo esc_url( get_permalink() ); ?>" 
                   class="blogbutton-small" 
                   title="<?php echo esc_attr( get_theme_mod( 'fm_radio_station_read_more_text', __( 'Read More', 'fm-radio-station' ) ) ); ?>">
                    <?php echo esc_html( get_theme_mod( 'fm_radio_station_read_more_text', __( 'Read More', 'fm-radio-station' ) ) ); ?>
                </a>
            </div>
          <?php }?>
        </div>
      <?php }
      else if($fm_radio_station_post_layout == 'content-image'){ ?>
        <div class="box-content col-lg-6 col-md-12">
          <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title();?></a></h4>
          <div class="box-info">
              <?php 
              // Add 'time' to your default meta order array
              $fm_radio_station_blog_archive_ordering = get_theme_mod('blog_meta_order', array('date', 'author', 'comment', 'category', 'time'));

              foreach ($fm_radio_station_blog_archive_ordering as $fm_radio_station_blog_data_order) : 
                if ('date' === $fm_radio_station_blog_data_order) : ?>
                    <i class="far fa-calendar-alt mb-1"></i>
                    <a href="<?php echo esc_url(get_day_link(get_the_date('Y'), get_the_date('m'), get_the_date('d'))); ?>" class="entry-date">
                        <?php echo esc_html(get_the_date('j F, Y')); ?>
                    </a>
                <?php elseif ('author' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-user mb-1"></i>
                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" class="entry-author">
                        <?php the_author(); ?>
                    </a>
                <?php elseif ('comment' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-comments mb-1"></i>
                    <a href="<?php comments_link(); ?>" class="entry-comments">
                        <?php comments_number(__('0 Comments', 'fm-radio-station'), __('1 Comment', 'fm-radio-station'), __('% Comments', 'fm-radio-station')); ?>
                    </a>
                <?php elseif ('category' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-list mb-1"></i>
                    <?php
                    $categories = get_the_category();
                    if (!empty($categories)) :
                        foreach ($categories as $category) : ?>
                            <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>" class="entry-category">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        <?php endforeach;
                    endif; 
                    ?>
                <?php elseif ('time' === $fm_radio_station_blog_data_order) : ?>
                    <i class="fas fa-clock mb-1"></i>
                    <span class="entry-time">
                        <?php echo get_the_time(); ?>
                    </span>
                <?php endif;
            endforeach; ?>
          </div>
          <p><?php echo esc_html( wp_trim_words( get_the_content(), get_theme_mod( 'fm_radio_station_excerpt_count', 35 ) ) ); ?></p>
          <?php if(get_theme_mod('fm_radio_station_remove_read_button',true) != ''){ ?>
            <div class="readmore-btn">
                <a href="<?php echo esc_url( get_permalink() ); ?>" 
                   class="blogbutton-small" 
                   title="<?php echo esc_attr( get_theme_mod( 'fm_radio_station_read_more_text', __( 'Read More', 'fm-radio-station' ) ) ); ?>">
                    <?php echo esc_html( get_theme_mod( 'fm_radio_station_read_more_text', __( 'Read More', 'fm-radio-station' ) ) ); ?>
                </a>
            </div>
          <?php }?>
        </div>
        <div class="box-image col-lg-6 col-md-12 align-self-center pt-lg-0 pt-3">
          <?php
            // Get the post content
            $fm_radio_station_post_content = apply_filters('the_content', get_the_content());

            // Create a DOMDocument to parse the HTML content
            $dom = new DOMDocument();
            @$dom->loadHTML($fm_radio_station_post_content);

            // Find and display the first image in the post content
            $images = $dom->getElementsByTagName('img');

            echo ($images->length > 0)
                ? '<img src="' . esc_url($images->item(0)->getAttribute('src')) . '">'
                : '';
            ?>
        </div>
      <?php }?>
      <div class="clearfix"></div>
    </div>
  </article>
</div>
<?php } ?>