<?php
/**
 * Template part for displaying slider section
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

$fm_radio_station_static_image = get_template_directory_uri() . '/assets/images/slider-img.png';
$fm_radio_station_slider_arrows = get_theme_mod('fm_radio_station_slider_arrows', true);

// define this BEFORE any if ( $fm_radio_station_playlist_page_id )
$fm_radio_station_playlist_page_id = absint( get_theme_mod( 'fm_radio_station_track_player_page', '') );
?>
<?php if ($fm_radio_station_slider_arrows) : ?>
  <section id="slider">
    <div class="container-fuild">
      <div class="owl-theme">
        <?php 
        $fm_radio_station_slide_pages = array();
        for ($fm_radio_station_count = 1; $fm_radio_station_count <= 1; $fm_radio_station_count++) {
          $fm_radio_station_mod = absint(get_theme_mod('fm_radio_station_slider_page' . $fm_radio_station_count));
          if ($fm_radio_station_mod != 0) {
            $fm_radio_station_slide_pages[] = $fm_radio_station_mod;
          }
        }
        if (!empty($fm_radio_station_slide_pages)) :
          $fm_radio_station_args = array(
            'post_type' => 'page',
            'post__in' => $fm_radio_station_slide_pages,
            'orderby' => 'post__in'
          );
          $fm_radio_station_query = new WP_Query($fm_radio_station_args);
          if ($fm_radio_station_query->have_posts()) :
            while ($fm_radio_station_query->have_posts()) : $fm_radio_station_query->the_post(); ?>
              <div class="item">
                <div class="row m-0">
                  <div class="col-lg-6 col-md-6 col-12 slider-img-col align-self-center px-0">
                    <div class="slider-main-img">
                      <?php if (has_post_thumbnail()) : ?>
                        <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title_attribute(); ?>" />
                      <?php else : ?>
                        <img src="<?php echo esc_url($fm_radio_station_static_image); ?>" alt="<?php esc_attr_e('Slider Image', 'fm-radio-station'); ?>" />
                      <?php endif; ?>
                      <?php if ( $fm_radio_station_playlist_page_id ) : ?>
                       <div class="track-progress-left">
                          <div class="tp-line"></div>
                          <span class="tp-dot tp-dot-main"></span>  <!-- big first dot -->
                          <span class="tp-dot"></span>
                          <span class="tp-dot"></span>
                          <span class="tp-dot"></span>
                          <span class="tp-dot"></span>
                          <span class="tp-dot"></span>
                          <span class="tp-dot"></span>
                        </div>
                      <?php endif; ?>
                    </div>
                  </div>
                  <div class="col-lg-6 col-md-6 col-12 slider-content-col align-self-center px-0">
                    <div class="carousel-caption">
                      <div class="inner_carousel">
                        <?php if (get_theme_mod('fm_radio_station_slider_short_heading')) : ?>
                          <p class="slidetop-text mb-3"><?php echo esc_html(get_theme_mod('fm_radio_station_slider_short_heading')); ?></p>
                        <?php endif; ?>
                        <?php if ( get_theme_mod( 'fm_radio_station_show_slider_title', true ) ) : ?>
                          <h1 class="mb-md-3 mb-0">
                            <a href="<?php the_permalink(); ?>" class="text-capitalize">
                                <?php
                                $fm_radio_station_title = get_the_title();
                                $fm_radio_station_words = explode( ' ', $fm_radio_station_title ); // split into words[web:54]

                                if ( isset( $fm_radio_station_words[2] ) ) {
                                    $fm_radio_station_words[2] = '<span class="third-word">' . $fm_radio_station_words[2] . '</span>';
                                }

                                if ( isset( $fm_radio_station_words[4] ) ) {
                                    $fm_radio_station_words[4] = '<span class="fifth-word">' . $fm_radio_station_words[4] . '</span>';
                                }

                                echo implode( ' ', $fm_radio_station_words );
                                ?>
                            </a>
                            </h1>
                        <?php endif; ?>
                        <?php if (get_theme_mod('fm_radio_station_show_slider_content', true)) : ?>
                          <p class="mb-0 slide-content"><?php $fm_radio_station_excerpt = get_the_excerpt(); echo esc_html( fm_radio_station_string_limit_words( $fm_radio_station_excerpt, esc_attr(get_theme_mod('fm_radio_station_slider_excerpt_length','50')))); ?></p>
                        <?php endif; ?>
                        <div class="more-btn mt-md-4 mt-2">
                          <a class="text-capitalize mb-3 slider-btn1" href="<?php the_permalink(); ?>" target="_blank">
                            <?php esc_html_e( 'Explore More', 'fm-radio-station' ); ?>
                          </a>
                        </div>
                      </div>
                    </div>
                    <?php if( get_theme_mod('fm_radio_station_track_player_page') != ''){ ?>
                      <div class="track-player-sec" data-wow-duration="2s">    
                        <div class="tracks-list">  
                          <div class="container">    
                            <?php $fm_radio_station_track_player_page = array();
                              $fm_radio_station_mod = absint( get_theme_mod( 'fm_radio_station_track_player_page','fm-radio-station'));
                              if ( 'page-none-selected' != $fm_radio_station_mod ) {
                                $fm_radio_station_track_player_page[] = $fm_radio_station_mod;
                              }
                              if( !empty($fm_radio_station_track_player_page) ) :
                                $fm_radio_station_args = array(
                                  'post_type' => 'page',
                                  'post__in' => $fm_radio_station_track_player_page,
                                  'orderby' => 'post__in'
                                );
                                $query = new WP_Query( $fm_radio_station_args );
                                if ( $query->have_posts() ) :
                                  $fm_radio_station_count = 0;
                                  while ( $query->have_posts() ) : $query->the_post(); ?>
                                    <?php the_content(); ?>
                                  <?php $fm_radio_station_count++; endwhile; ?>
                                <?php else : ?>
                                  <div class="no-postfound"></div>
                                <?php endif;
                              endif;
                              wp_reset_postdata()
                            ?>
                          </div>
                        </div>
                      </div>
                    <?php }?>
                  </div>
                </div>
              </div>
            <?php endwhile;
            wp_reset_postdata();
          else : ?>
            <div class="no-postfound"><?php esc_html_e('No posts found', 'fm-radio-station'); ?></div>
          <?php endif;
        endif; ?>
      </div>
    </div>
    <div class="clearfix"></div>
  </section>
<?php endif; ?>