<?php
/**
 * Template part for displaying slider section with Owl Carousel
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

$fm_radio_station_live_player_show_hide = get_theme_mod('fm_radio_station_live_player_show_hide', '1');

if ($fm_radio_station_live_player_show_hide == '1') :
?>
  <section id="live-player-sec" class="live-player-section my-5" data-wow-duration="2s">    
    <div class="live-player-list">  
      <div class="container">
        <div class="text-center">
          <div class="serv-small">
            <?php if (get_theme_mod('fm_radio_station_featured_section_title')) : ?>
              <p class="text-center mb-2 text-capitalize small-head-live">
                <?php echo esc_html(get_theme_mod('fm_radio_station_featured_section_title', '')); ?>
              </p>
            <?php endif; ?>
          </div>
        <?php if (get_theme_mod('fm_radio_station_serv_short_heading') != '') { ?>
          <h2 class="serv-short mb-3 text-center d-inline-block text-capitalize">
            <?php echo esc_html(get_theme_mod('fm_radio_station_serv_short_heading', '')); ?>
          </h2>
        <?php } ?>
      </div>
        <!-- Owl Carousel Wrapper -->
        <div class="owl-carousel radio-carousel owl-theme">
          <?php
          // Get number of stations to display (default 3)
          $fm_radio_station_number_of_stations = absint(get_theme_mod('fm_radio_station_number_of_stations', '3'));
          // Collect all selected pages
          $fm_radio_station_player_pages = array();
          // Loop through only the selected number of stations
          for ( $fm_radio_station_i = 1; $fm_radio_station_i <= $fm_radio_station_number_of_stations; $fm_radio_station_i++ ) {
              $page_id = absint(get_theme_mod('fm_radio_station_player_page_' . $fm_radio_station_i, ''));
              if ( $page_id && 'page-none-selected' != $page_id ) {
                  $fm_radio_station_player_pages[] = $page_id;
              }
          }
          // Query all selected pages
          if ( !empty($fm_radio_station_player_pages) ) :
              $fm_radio_station_args = array(
                  'post_type'      => 'page',
                  'post__in'       => $fm_radio_station_player_pages,
                  'orderby'        => 'post__in',
                  'posts_per_page' => -1
              );
              $fm_radio_station_query = new WP_Query( $fm_radio_station_args );
              if ( $fm_radio_station_query->have_posts() ) :
                  while ( $fm_radio_station_query->have_posts() ) : $fm_radio_station_query->the_post(); ?>
                      <!-- Individual Carousel Item -->
                      <div class="carousel-item">
                          <div class="radio-player-card">
                              <!-- Player Content -->
                              <div class="player-content">
                                  <?php the_content(); ?>
                              </div>
                          </div>
                      </div>
                  <?php endwhile;
              else :
                  ?>
                  <div class="no-postfound">
                      <p><?php esc_html_e('No FM Radio Stations found', 'fm-radio-station'); ?></p>
                  </div>
                  <?php
              endif;
              wp_reset_postdata();
          else :
              ?>
              <div class="no-postfound">
                  <p><?php esc_html_e('Please select FM Radio Station pages from customizer', 'fm-radio-station'); ?></p>
              </div>
              <?php
          endif;
          ?>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>