<?php
/*
* Display Logo and header details
*/
?>
<div class="main-header">
  <div class="menubox py-md-3 py-3">
    <div class="container">
      <div class="row">
        <div class="col-lg-3 col-md-4 logo-col align-self-center">
            <div class="logo">
              <?php if( has_custom_logo() ) fm_radio_station_the_custom_logo(); ?>
              <?php if(get_theme_mod('fm_radio_station_site_title',true) == 1){ ?>
                <?php if (is_front_page() && is_home()) : ?>
                  <h1 class="text-capitalize">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                  </h1> 
                <?php else : ?>
                  <p class="text-capitalize site-title mb-1">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                  </p>
                <?php endif; ?>
              <?php }?>
              <?php $fm_radio_station_description = get_bloginfo( 'description', 'display' );
              if ( $fm_radio_station_description || is_customize_preview() ) : ?>
                <?php if(get_theme_mod('fm_radio_station_site_tagline',false)){ ?>
                  <p class="site-description mb-0"><?php echo esc_html($fm_radio_station_description); ?></p>
                <?php }?>
              <?php endif; ?>
            </div>
        </div>
        <div class="col-lg-8 col-md-4 align-self-center">
            <?php get_template_part('template-parts/navigation/site-nav'); ?>
        </div>
        <div class="col-lg-1 col-md-4 align-self-center btn-col">
          <div class="header-admin">
            <?php if (get_theme_mod('fm_radio_station_header_first_link')) : ?>
              <span class="header-btn-first ms-md-3">
                <a href="<?php echo esc_url(get_theme_mod('fm_radio_station_header_first_link')); ?>" class="book-appoin">
                  <i class="fas fa-layer-group"></i>
                </a>
              </span>
            <?php endif; ?>
          </div> 
        </div>
      </div>
    </div>
  </div>
</div>