<?php
/**
 * Displays footer widgets if assigned
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */
?>
<?php

// Determine the number of columns dynamically for the footer (you can replace this with your logic).
$fm_radio_station_no_of_footer_col = get_theme_mod('fm_radio_station_footer_columns', 4); // Change this value as needed.

// Calculate the Bootstrap class for large screens (col-lg-X) for footer.
$fm_radio_station_col_lg_footer_class = 'col-lg-' . (12 / $fm_radio_station_no_of_footer_col);

// Calculate the Bootstrap class for medium screens (col-md-X) for footer.
$fm_radio_station_col_md_footer_class = 'col-md-' . (12 / $fm_radio_station_no_of_footer_col);
?>
<div class="container">
    <aside class="widget-area row py-2 pt-3" role="complementary" aria-label="<?php esc_attr_e( 'Footer', 'fm-radio-station' ); ?>">
        <?php
        $fm_radio_station_default_widgets = array(
            1 => 'search',
            2 => 'archives',
            3 => 'meta',
            4 => 'categories'
        );

        for ($fm_radio_station_i = 1; $fm_radio_station_i <= $fm_radio_station_no_of_footer_col; $fm_radio_station_i++) :
            $fm_radio_station_lg_class = esc_attr($fm_radio_station_col_lg_footer_class);
            $fm_radio_station_md_class = esc_attr($fm_radio_station_col_md_footer_class);
            echo '<div class="col-12 ' . $fm_radio_station_lg_class . ' ' . $fm_radio_station_md_class . '">';

            if (is_active_sidebar('footer-' . $fm_radio_station_i)) {
                dynamic_sidebar('footer-' . $fm_radio_station_i);
            } else {
                // Display default widget content if not active.
                switch ($fm_radio_station_default_widgets[$fm_radio_station_i] ?? '') {
                    case 'search':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Search', 'fm-radio-station'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Search', 'fm-radio-station'); ?></h3>
                            <?php get_search_form(); ?>
                        </aside>
                        <?php
                        break;

                    case 'archives':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Archives', 'fm-radio-station'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Archives', 'fm-radio-station'); ?></h3>
                            <ul><?php wp_get_archives(['type' => 'monthly']); ?></ul>
                        </aside>
                        <?php
                        break;

                    case 'meta':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Meta', 'fm-radio-station'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Meta', 'fm-radio-station'); ?></h3>
                            <ul>
                                <?php wp_register(); ?>
                                <li><?php wp_loginout(); ?></li>
                                <?php wp_meta(); ?>
                            </ul>
                        </aside>
                        <?php
                        break;

                    case 'categories':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Categories', 'fm-radio-station'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Categories', 'fm-radio-station'); ?></h3>
                            <ul><?php wp_list_categories(['title_li' => '']); ?></ul>
                        </aside>
                        <?php
                        break;
                }
            }

            echo '</div>';
        endfor;
        ?>
    </aside>
</div>