<?php
/**
 * The template for displaying all single posts
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

get_header(); ?>

<?php while ( have_posts() ) : the_post(); ?>
    <div id="post-<?php the_ID(); ?>" <?php post_class('external-div'); ?>>
        <div class="box-image-page">
            <?php if ( has_post_thumbnail() ) : ?>
                <!-- If post has thumbnail, apply parallax background with header settings -->
                <div class="featured-image" 
                     style="background-image: url('<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ); ?>'); 
                            background-size: cover;
                            background-position: <?php echo esc_attr( get_theme_mod( 'fm_radio_station_header_background_position', 'center' ) ); ?>;
                            background-attachment: <?php echo esc_attr( get_theme_mod( 'fm_radio_station_header_background_attachment', 'scroll' ) ? 'fixed' : 'scroll' ); ?>;
                            height: <?php echo esc_attr( get_theme_mod( 'fm_radio_station_header_image_height', 400 ) ); ?>px;">
                </div>
            <?php else : ?>
                <!-- Fallback image for pages with no thumbnail -->
                <div class="single-page-img"></div>
            <?php endif; ?>
        </div> 
        <div class="box-text">
            <h2><?php echo esc_html( get_the_title() ); ?></h2>  
        </div> 
    </div>
<?php endwhile; ?>

<?php 
rewind_posts(); // Reset the loop for content area
?>

<main id="tp_content" role="main">
	<div class="container">
		<div id="primary" class="content-area">
			<?php
	        $fm_radio_station_sidebar_single_post_layout = get_theme_mod( 'fm_radio_station_sidebar_single_post_layout','right');
	        if($fm_radio_station_sidebar_single_post_layout == 'left'){ ?>
		        <div class="row">
		          	<div class="col-lg-4 col-md-4" id="theme-sidebar"><?php get_sidebar(); ?></div>
		          	<div class="col-lg-8 col-md-8">
			            <?php
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/post/single-post' );
							endwhile; ?>

			            <?php 
			            // Previous/next post navigation for single posts
			            the_post_navigation( array(
			                'prev_text' => esc_html__( '%title', 'fm-radio-station' ),
			                'next_text' => esc_html__( '%title', 'fm-radio-station' ),
			            ) ); ?>
		          	</div>
		        </div>
		        <div class="clearfix"></div>
		    <?php }else if($fm_radio_station_sidebar_single_post_layout == 'right'){ ?>
		        <div class="row">
		          	<div class="col-lg-8 col-md-8">	           
			            <?php
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/post/single-post' );
							endwhile; ?>

			            <?php 
			            // Previous/next post navigation for single posts
			            the_post_navigation( array(
			                'prev_text' => esc_html__( '%title', 'fm-radio-station' ),
			                'next_text' => esc_html__( '%title', 'fm-radio-station' ),
			            ) ); ?>
		          	</div>
		          	<div class="col-lg-4 col-md-4" id="theme-sidebar"><?php get_sidebar(); ?></div>
		        </div>
		    <?php }else if($fm_radio_station_sidebar_single_post_layout == 'full'){ ?>
		        <div class="full">
		            <?php
						while ( have_posts() ) : the_post();
							get_template_part( 'template-parts/post/single-post' );
						endwhile; ?>

		            <?php 
		            // Previous/next post navigation for single posts
		            the_post_navigation( array(
		                'prev_text' => esc_html__( '%title', 'fm-radio-station' ),
		                'next_text' => esc_html__( '%title', 'fm-radio-station' ),
		            ) ); ?>
		      	</div>
		    <?php }else {?>
		    	<div class="row">
		          	<div class="col-lg-8 col-md-8">	           
			            <?php
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/post/single-post' );
							endwhile; ?>

			            <?php 
			            // Previous/next post navigation for single posts
			            the_post_navigation( array(
			                'prev_text' => esc_html__( '%title', 'fm-radio-station' ),
			                'next_text' => esc_html__( '%title', 'fm-radio-station' ),
			            ) ); ?>
		          	</div>
		          	<div class="col-lg-4 col-md-4" id="theme-sidebar"><?php get_sidebar(); ?></div>
		        </div>
		    <?php } ?>
		</div>
   </div>
</main>

<?php get_footer(); ?>