<?php
/**
 * The template for displaying search results pages
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

get_header(); ?>

<div class="box-image-page">
  	<div class="single-page-img"></div>
  	 <div class="box-text">
    	<h2><?php echo esc_html( get_search_query() ); ?></h2>  
    </div> 
</div>

<div class="container">
	<main id="tp_content" role="main">
		<div id="primary" class="content-area">
			<div class="page-header">
				<?php if ( have_posts() ) : ?>
					<h1 class="page-title">
						<?php 
						/* translators: %s: search term */
						printf( 
							esc_html__( 'Search Results for: %s', 'fm-radio-station' ), 
							'<span>' . esc_html( get_search_query() ) . '</span>' 
						); 
						?>
					</h1>
				<?php else : ?>
					<h1 class="page-title">
						<?php
						echo esc_html(
							get_theme_mod(
								'fm_radio_station_edit_no_result_title',
								esc_html__( 'Nothing Found', 'fm-radio-station' )
							)
						);
						?>
					</h1>
				<?php endif; ?>
			</div>		
			
			<?php
	        $fm_radio_station_sidebar_layout = get_theme_mod( 'fm_radio_station_sidebar_post_layout','right');
	        if($fm_radio_station_sidebar_layout == 'left'){ ?>
		        <div class="row m-0">
		          	<div class="col-lg-4 col-md-4" id="theme-sidebar"><?php get_sidebar(); ?></div>
		          	<div class="col-lg-8 col-md-8">
			            <?php if ( have_posts() ) :
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/post/content', get_post_format() );
							endwhile;
						else : ?>
							<p>
								<?php
								echo esc_html(
									get_theme_mod(
										'fm_radio_station_edit_no_result_text',
										esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fm-radio-station' )
									)
								);
								?>
							</p>
							<?php get_search_form(); ?>
						<?php endif; ?>

			            <div class="navigation">
			              <?php
			                  the_posts_pagination( array(
			                      'prev_text'          => esc_html__( 'Previous page', 'fm-radio-station' ),
			                      'next_text'          => esc_html__( 'Next page', 'fm-radio-station' ),
			                      'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'fm-radio-station' ) . ' </span>',
			                  ) );
			              ?>
			                <div class="clearfix"></div>
			            </div>
		          	</div>
		        </div>
		        <div class="clearfix"></div>
		    <?php }else if($fm_radio_station_sidebar_layout == 'right'){ ?>
		        <div class="row m-0">
		          	<div class="col-lg-8 col-md-8">
			            <?php if ( have_posts() ) :
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/post/content', get_post_format() );
							endwhile;
						else : ?>
							<p>
								<?php
								echo esc_html(
									get_theme_mod(
										'fm_radio_station_edit_no_result_text',
										esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fm-radio-station' )
									)
								);
								?>
							</p>
							<?php get_search_form(); ?>
						<?php endif; ?>

			            <div class="navigation">
			              <?php
			                  the_posts_pagination( array(
			                      'prev_text'          => esc_html__( 'Previous page', 'fm-radio-station' ),
			                      'next_text'          => esc_html__( 'Next page', 'fm-radio-station' ),
			                      'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'fm-radio-station' ) . ' </span>',
			                  ) );
			              ?>
			                <div class="clearfix"></div>
			            </div>
		          	</div>
		          	<div class="col-lg-4 col-md-4" id="theme-sidebar"><?php get_sidebar(); ?></div>
		        </div>
		    <?php }else if($fm_radio_station_sidebar_layout == 'full'){ ?>
		        <div class="full">
		            <?php if ( have_posts() ) :
						while ( have_posts() ) : the_post();
							get_template_part( 'template-parts/post/content', get_post_format() );
						endwhile;
					else : ?>
						<p>
							<?php
							echo esc_html(
								get_theme_mod(
									'fm_radio_station_edit_no_result_text',
									esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fm-radio-station' )
								)
							);
							?>
						</p>
						<?php get_search_form(); ?>
					<?php endif; ?>

		            <div class="navigation">
		                <?php
		                   the_posts_pagination( array(
		                       'prev_text'          => esc_html__( 'Previous page', 'fm-radio-station' ),
		                       'next_text'          => esc_html__( 'Next page', 'fm-radio-station' ),
		                       'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'fm-radio-station' ) . ' </span>',
		                   ) );
		                ?>
		                <div class="clearfix"></div>
		            </div>
	          	</div>
		    <?php }else if($fm_radio_station_sidebar_layout == 'three-column'){ ?>
		        <div class="row m-0">
		          	<div class="col-lg-3 col-md-3" id="theme-sidebar"><?php get_sidebar(); ?></div>
		          	<div class="col-lg-6 col-md-6">
			            <?php if ( have_posts() ) :
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/post/content', get_post_format() );
							endwhile;
						else : ?>
							<p>
								<?php
								echo esc_html(
									get_theme_mod(
										'fm_radio_station_edit_no_result_text',
										esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fm-radio-station' )
									)
								);
								?>
							</p>
							<?php get_search_form(); ?>
						<?php endif; ?>

			            <div class="navigation">
			              	<?php
			                   the_posts_pagination( array(
			                       'prev_text'          => esc_html__( 'Previous page', 'fm-radio-station' ),
			                       'next_text'          => esc_html__( 'Next page', 'fm-radio-station' ),
			                       'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'fm-radio-station' ) . ' </span>',
			                   ) );
			              	?>
			                <div class="clearfix"></div>
			            </div>
		          	</div>
		          	<div class="col-lg-3 col-md-3" id="theme-sidebar"><?php dynamic_sidebar('sidebar-2'); ?></div>
		        </div>
		    <?php }else if($fm_radio_station_sidebar_layout == 'four-column'){ ?>
		        <div class="row m-0">
		          	<div class="col-lg-3 col-md-6" id="theme-sidebar"><?php get_sidebar(); ?></div>
		          	<div class="col-lg-3 col-md-6">
			            <?php if ( have_posts() ) :
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/post/content', get_post_format() );
							endwhile;
						else : ?>
							<p>
								<?php
								echo esc_html(
									get_theme_mod(
										'fm_radio_station_edit_no_result_text',
										esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fm-radio-station' )
									)
								);
								?>
							</p>
							<?php get_search_form(); ?>
						<?php endif; ?>
			            <div class="navigation">
			              	<?php
			                   the_posts_pagination( array(
			                       'prev_text'          => esc_html__( 'Previous page', 'fm-radio-station' ),
			                       'next_text'          => esc_html__( 'Next page', 'fm-radio-station' ),
			                       'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'fm-radio-station' ) . ' </span>',
			                   ) );
			              	?>
			                <div class="clearfix"></div>
			            </div>
		          	</div>
		          	<div class="col-lg-3 col-md-6" id="theme-sidebar"><?php dynamic_sidebar('sidebar-2'); ?></div>
		          	<div class="col-lg-3 col-md-6" id="theme-sidebar"><?php dynamic_sidebar('sidebar-3'); ?></div>
		        </div>
		    <?php }else if($fm_radio_station_sidebar_layout == 'grid'){ ?>
		        <div class="row m-0">
		          	<div class="col-lg-9 col-md-9">
		           		<div class="row mb-4">
				            <?php if ( have_posts() ) :
								while ( have_posts() ) : the_post();
									get_template_part( 'template-parts/post/content-grid');
								endwhile;
							else : ?>
								<p>
									<?php
									echo esc_html(
										get_theme_mod(
											'fm_radio_station_edit_no_result_text',
											esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fm-radio-station' )
										)
									);
									?>
								</p>
								<?php get_search_form(); ?>
							<?php endif; ?>
						</div>
			            <div class="navigation">
			              	<?php
			                   the_posts_pagination( array(
			                       'prev_text'          => esc_html__( 'Previous page', 'fm-radio-station' ),
			                       'next_text'          => esc_html__( 'Next page', 'fm-radio-station' ),
			                       'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'fm-radio-station' ) . ' </span>',
			                   ) );
			              	?>
			                <div class="clearfix"></div>
			            </div>
		          	</div>	         
		        	<div class="col-lg-3 col-md-3" id="theme-sidebar"><?php get_sidebar(); ?></div>
		        </div>
		    <?php }else {?>
		    	<div class="row m-0">
		          	<div class="col-lg-8 col-md-8">
			            <?php if ( have_posts() ) :
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/post/content', get_post_format() );
							endwhile;
						else : ?>
							<p>
								<?php
								echo esc_html(
									get_theme_mod(
										'fm_radio_station_edit_no_result_text',
										esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fm-radio-station' )
									)
								);
								?>
							</p>
							<?php get_search_form(); ?>
						<?php endif; ?>

			            <div class="navigation">
			              <?php
			                  the_posts_pagination( array(
			                      'prev_text'          => esc_html__( 'Previous page', 'fm-radio-station' ),
			                      'next_text'          => esc_html__( 'Next page', 'fm-radio-station' ),
			                      'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'fm-radio-station' ) . ' </span>',
			                  ) );
			              ?>
			                <div class="clearfix"></div>
			            </div>
		          	</div>
		          	<div class="col-lg-4 col-md-4" id="theme-sidebar"><?php get_sidebar(); ?></div>
		        </div>
		    <?php } ?>
		</div>
	</main>
</div>

<?php get_footer(); ?>