<?php 
if (isset($_GET['import-demo']) && $_GET['import-demo'] == true) {

    // Function to install and activate plugins
    function fm_radio_station_import_demo_content() {

        // Display the preloader only for plugin installation
        echo '<div id="plugin-loader" style="display: flex; align-items: center; justify-content: center; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255, 255, 255, 0.8); z-index: 9999;">
                <img src="' . esc_url(get_template_directory_uri()) . '/assets/images/loader.png" alt="Loading..." width="60" height="60" />
              </div>';

        // Define the plugins you want to install and activate
        $plugins = array(
            array(
                'slug' => 'advanced-appointment-booking-scheduling',
                'file' => 'advanced-appointment-booking-scheduling/advanced-appointment-booking.php',
                'url'  => 'https://downloads.wordpress.org/plugin/advanced-appointment-booking-scheduling.zip'
            ),
            array(
                'slug' => 'audioigniter',
                'file' => 'audioigniter/audioigniter.php',
                'url'  => 'https://downloads.wordpress.org/plugin/audioigniter.latest-stable.zip'
            ),
        );
        // Include required files for plugin installation
        if (!function_exists('plugins_api')) {
            include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
        }
        if (!function_exists('activate_plugin')) {
            include_once(ABSPATH . 'wp-admin/includes/plugin.php');
        }
        include_once(ABSPATH . 'wp-admin/includes/file.php');
        include_once(ABSPATH . 'wp-admin/includes/misc.php');
        include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

        // Loop through each plugin
        foreach ($plugins as $plugin) {
            $plugin_file = WP_PLUGIN_DIR . '/' . $plugin['file'];

            // Check if the plugin is installed
            if (!file_exists($plugin_file)) {
                // If the plugin is not installed, download and install it
                $upgrader = new Plugin_Upgrader();
                $result = $upgrader->install($plugin['url']);

                // Check for installation errors
                if (is_wp_error($result)) {
                    error_log('Plugin installation failed: ' . $plugin['slug'] . ' - ' . $result->get_error_message());
                    continue;
                }
            }

            // If the plugin folder exists but the plugin is not active, activate it
            if (file_exists($plugin_file) && !is_plugin_active($plugin['file'])) {
                $result = activate_plugin($plugin['file']);

                // Check for activation errors
                if (is_wp_error($result)) {
                    error_log('Plugin activation failed: ' . $plugin['slug'] . ' - ' . $result->get_error_message());
                }
            }
        }

        // Hide the preloader after the process is complete
        echo '<script type="text/javascript">
                document.getElementById("plugin-loader").style.display = "none";
              </script>';

        // Add filter to skip WooCommerce setup wizard after activation
        add_filter('woocommerce_prevent_automatic_wizard_redirect', '__return_true');
    }

    // Call the import function
    fm_radio_station_import_demo_content();
 
    // ------- Create Nav Menu --------
$fm_radio_station_menuname = 'Main Menus';
$fm_radio_station_bpmenulocation = 'primary-menu';
$fm_radio_station_menu_exists = wp_get_nav_menu_object($fm_radio_station_menuname);

if (!$fm_radio_station_menu_exists) {
    $fm_radio_station_menu_id = wp_create_nav_menu($fm_radio_station_menuname);

    // Create Home Page
    $fm_radio_station_home_title = 'Home';
    $fm_radio_station_home = array(
        'post_type' => 'page',
        'post_title' => $fm_radio_station_home_title,
        'post_content' => '',
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'home'
    );
    $fm_radio_station_home_id = wp_insert_post($fm_radio_station_home);

    // Assign Home Page Template
    add_post_meta($fm_radio_station_home_id, '_wp_page_template', 'page-template/front-page.php');

    // Update options to set Home Page as the front page
    update_option('page_on_front', $fm_radio_station_home_id);
    update_option('show_on_front', 'page');

    // Add Home Page to Menu
    wp_update_nav_menu_item($fm_radio_station_menu_id, 0, array(
        'menu-item-title' => __('Home', 'fm-radio-station'),
        'menu-item-classes' => 'home',
        'menu-item-url' => home_url('/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $fm_radio_station_home_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create About Us Page with Dummy Content
    $fm_radio_station_about_title = 'About Us';
    $fm_radio_station_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $fm_radio_station_about = array(
        'post_type' => 'page',
        'post_title' => $fm_radio_station_about_title,
        'post_content' => $fm_radio_station_about_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'about-us'
    );
    $fm_radio_station_about_id = wp_insert_post($fm_radio_station_about);

    // Add About Us Page to Menu
    wp_update_nav_menu_item($fm_radio_station_menu_id, 0, array(
        'menu-item-title' => __('About Us', 'fm-radio-station'),
        'menu-item-classes' => 'about-us',
        'menu-item-url' => home_url('/about-us/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $fm_radio_station_about_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Services Page with Dummy Content
    $fm_radio_station_services_title = 'Services';
    $fm_radio_station_services_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $fm_radio_station_services = array(
        'post_type' => 'page',
        'post_title' => $fm_radio_station_services_title,
        'post_content' => $fm_radio_station_services_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'services'
    );
    $fm_radio_station_services_id = wp_insert_post($fm_radio_station_services);

    // Add Services Page to Menu
    wp_update_nav_menu_item($fm_radio_station_menu_id, 0, array(
        'menu-item-title' => __('Services', 'fm-radio-station'),
        'menu-item-classes' => 'services',
        'menu-item-url' => home_url('/services/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $fm_radio_station_services_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Pages Page with Dummy Content
    $fm_radio_station_pages_title = 'Pages';
    $fm_radio_station_pages_content = '<h2>Our Pages</h2>
    <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>';
    $fm_radio_station_pages = array(
        'post_type' => 'page',
        'post_title' => $fm_radio_station_pages_title,
        'post_content' => $fm_radio_station_pages_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'pages'
    );
    $fm_radio_station_pages_id = wp_insert_post($fm_radio_station_pages);

    // Add Pages Page to Menu
    wp_update_nav_menu_item($fm_radio_station_menu_id, 0, array(
        'menu-item-title' => __('Pages', 'fm-radio-station'),
        'menu-item-classes' => 'pages',
        'menu-item-url' => home_url('/pages/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $fm_radio_station_pages_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Contact Page with Dummy Content
    $fm_radio_station_contact_title = 'Contact';
    $fm_radio_station_contact_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $fm_radio_station_contact = array(
        'post_type' => 'page',
        'post_title' => $fm_radio_station_contact_title,
        'post_content' => $fm_radio_station_contact_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'contact'
    );
    $fm_radio_station_contact_id = wp_insert_post($fm_radio_station_contact);

    // Add Contact Page to Menu
    wp_update_nav_menu_item($fm_radio_station_menu_id, 0, array(
        'menu-item-title' => __('Contact', 'fm-radio-station'),
        'menu-item-classes' => 'contact',
        'menu-item-url' => home_url('/contact/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $fm_radio_station_contact_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Set the menu location if it's not already set
    if (!has_nav_menu($fm_radio_station_bpmenulocation)) {
        $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
        if (empty($locations)) {
            $locations = array();
        }
        $locations[$fm_radio_station_bpmenulocation] = $fm_radio_station_menu_id;
        set_theme_mod('nav_menu_locations', $locations);
    }
}

        //---Header--//
        set_theme_mod('fm_radio_station_header_first_link', '#');

        // Slider Section
        set_theme_mod('fm_radio_station_slider_arrows', true);

        set_theme_mod('fm_radio_station_slider_short_heading', 'Your Music, Your Voice, Your Station');

         for ($i = 1; $i <= 1; $i++) {
            $fm_radio_station_title = 'Hottest Hits, Anytime and Anywhere You Listen.';
            $fm_radio_station_content = 'Discover a world of music, entertainment, and news with our radio station. From the hottest hits to engaging talk shows, we bring you content that keeps you entertained and informed. Listen live anytime, anywhere, and connect with a vibrant community of music lovers. Your soundtrack for every moment starts here—tune in and feel the vibe.';

            // Create post object
            $my_post = array(
                'post_title'    => wp_strip_all_tags($fm_radio_station_title),
                'post_content'  => $fm_radio_station_content,
                'post_status'   => 'publish',
                'post_type'     => 'page',
            );

            /// Insert the post into the database
            $post_id = wp_insert_post($my_post);

            if ($post_id) {
                // Set the theme mod for the slider page
                set_theme_mod('fm_radio_station_slider_page' . $i, $post_id);

                $image_url = get_template_directory_uri() . '/assets/images/slider-img.png';
                $image_id = media_sideload_image($image_url, $post_id, null, 'id');

                if (!is_wp_error($image_id)) {
                    // Set the downloaded image as the post's featured image
                    set_post_thumbnail($post_id, $image_id);
                }
            }
        }

        // Single FM Radio Station - Blues Radio
        $fm_radio_station_content = "Blues Radio - Your favorite station playing the best blues music 24/7.";

        // Create single FM radio station playlist
        $fm_radio_station_my_post = array(
            'post_title'   => 'Blues Radio',
            'post_content' => $fm_radio_station_content,
            'post_status'  => 'publish',
            'post_type'    => 'ai_playlist',
        );

        $fm_radio_station_bwt_post_id = wp_insert_post($fm_radio_station_my_post);
        if (is_wp_error($fm_radio_station_bwt_post_id)) {
            return;
        }

        // Upload station image (track1.png)
        $fm_radio_station_image_url = get_template_directory_uri() . "/assets/images/track1.png";
        $fm_radio_station_image_name = "blues_radio_station.png";

        $fm_radio_station_image_data = @file_get_contents($fm_radio_station_image_url);
        if ($fm_radio_station_image_data === false) {
            return;
        }

        $fm_radio_station_upload_dir = wp_upload_dir();
        $fm_radio_station_unique_file_name = wp_unique_filename($fm_radio_station_upload_dir['path'], $fm_radio_station_image_name);
        $fm_radio_station_filename = basename($fm_radio_station_unique_file_name);

        $fm_radio_station_upload = wp_upload_bits($fm_radio_station_filename, null, $fm_radio_station_image_data);
        if ($fm_radio_station_upload['error']) {
            return;
        }

        $fm_radio_station_file = $fm_radio_station_upload['file'];
        $fm_radio_station_wp_filetype = wp_check_filetype($fm_radio_station_filename, null);
        $fm_radio_station_attachment = array(
            'post_mime_type' => $fm_radio_station_wp_filetype['type'],
            'post_title'     => 'Blues Radio Station Logo',
            'post_content'   => '',
            'post_status'    => 'inherit',
        );

        $fm_radio_station_attach_id = wp_insert_attachment($fm_radio_station_attachment, $fm_radio_station_file, $fm_radio_station_bwt_post_id);
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        $fm_radio_station_attach_data = wp_generate_attachment_metadata($fm_radio_station_attach_id, $fm_radio_station_file);
        wp_update_attachment_metadata($fm_radio_station_attach_id, $fm_radio_station_attach_data);

        // SINGLE STATION STREAM (continuous radio stream)
        $fm_radio_station_player_url = get_template_directory_uri() . '/assets/images/audio/sample.mp3'; // Replace with real radio stream URL
        $fm_radio_station_featured_album_tracks = array(
            array(
                'cover_id'               => $fm_radio_station_attach_id,
                'title'                  => 'Blues Radio',
                'artist'                 => 'Live Stream',
                'track_url'              => $fm_radio_station_player_url,
                'buy_link'               => '#',
                'download_url'           => '',
                'download_uses_track_url' => '0',
            ),
        );

        // Save as AudioIgniter station data
        update_post_meta($fm_radio_station_bwt_post_id, '_audioigniter_tracks', $fm_radio_station_featured_album_tracks);

        // Create single station player page
        $page_title = 'FM Radio Player';
        $page_query = new WP_Query(array(
            'post_type'      => 'page',
            'title'          => $page_title,
            'post_status'    => 'publish',
            'posts_per_page' => 1,
            'fields'         => 'ids'
        ));

        if ($page_query->have_posts()) {
            $existing_page_id = $page_query->posts[0];
            set_theme_mod("fm_radio_station_track_player_page", $existing_page_id);
            wp_reset_postdata();
        } else {
            wp_reset_postdata();

            // SINGLE compact station player shortcode
            $productpage = '[ai_playlist id="' . $fm_radio_station_bwt_post_id . '" skin="compact"]';
            $fm_radio_station_page_content = do_shortcode($productpage);

            $fm_radio_station_page = array(
                'post_type'    => 'page',
                'post_title'   => $page_title,
                'post_content' => $fm_radio_station_page_content,
                'post_status'  => 'publish',
                'post_author'  => 1,
                'post_slug'    => "fm-radio-player"
            );

            $fm_radio_station_page_id = wp_insert_post($fm_radio_station_page);
            if (!is_wp_error($fm_radio_station_page_id)) {
                set_theme_mod("fm_radio_station_track_player_page", $fm_radio_station_page_id);
            }
        }

        // -----------------------live Section-----------------------------
        set_theme_mod('fm_radio_station_live_player_show_hide', true);

        set_theme_mod('fm_radio_station_featured_section_title', 'Listen Live Player');
        set_theme_mod('fm_radio_station_serv_short_heading', 'Hit Play and Enjoy Live Music Now');
        set_theme_mod('fm_radio_station_number_of_stations', '3');
        // Track Player Section - Creates 3 pages with different track images (track1.png, track2.png, track3.png)
        $fm_radio_station_playlist_ids = array();

        for ($fm_radio_station_i = 1; $fm_radio_station_i <= 3; $fm_radio_station_i++) {
            $fm_radio_station_content = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.";

            // Create post object
            $fm_radio_station_my_post = array(
                'post_title'   => 'Featured-album-' . $fm_radio_station_i,
                'post_content' => $fm_radio_station_content,
                'post_status'  => 'publish',
                'post_type'    => 'ai_playlist',
            );

            // Insert the post into the database
            $fm_radio_station_bwt_post_id = wp_insert_post($fm_radio_station_my_post);

            if (is_wp_error($fm_radio_station_bwt_post_id)) {
                continue;
            }

            // DIFFERENT IMAGES: track1.png, track2.png, track3.png
            $fm_radio_station_image_url = get_template_directory_uri() . "/assets/images/track{$fm_radio_station_i}.png";
            $fm_radio_station_image_name = "track_image_{$fm_radio_station_i}.png";
            
            $fm_radio_station_image_data = @file_get_contents($fm_radio_station_image_url);
            if ($fm_radio_station_image_data === false) {
                continue;
            }

            $fm_radio_station_upload_dir = wp_upload_dir();
            $fm_radio_station_unique_file_name = wp_unique_filename($fm_radio_station_upload_dir['path'], $fm_radio_station_image_name);
            $fm_radio_station_filename = basename($fm_radio_station_unique_file_name);
            
            $fm_radio_station_upload = wp_upload_bits($fm_radio_station_filename, null, $fm_radio_station_image_data);
            if ($fm_radio_station_upload['error']) {
                continue;
            }

            $fm_radio_station_file = $fm_radio_station_upload['file'];
            $fm_radio_station_wp_filetype = wp_check_filetype($fm_radio_station_filename, null);
            $fm_radio_station_attachment = array(
                'post_mime_type' => $fm_radio_station_wp_filetype['type'],
                'post_title'     => sanitize_file_name($fm_radio_station_filename),
                'post_content'   => '',
                'post_status'    => 'inherit',
            );

            $fm_radio_station_attach_id = wp_insert_attachment($fm_radio_station_attachment, $fm_radio_station_file, $fm_radio_station_bwt_post_id);
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            $fm_radio_station_attach_data = wp_generate_attachment_metadata($fm_radio_station_attach_id, $fm_radio_station_file);
            wp_update_attachment_metadata($fm_radio_station_attach_id, $fm_radio_station_attach_data);

            // Same audio tracks but different cover images
            $fm_radio_station_player_url = get_template_directory_uri() . '/assets/images/audio/sample.mp3';
            $fm_radio_station_featured_album_tracks = array(
                array(
                    'cover_id'               => $fm_radio_station_attach_id,
                    'title'                  => 'Lorem Ipsum',
                    'artist'                 => 'Mike Hunt',
                    'track_url'              => $fm_radio_station_player_url,
                    'buy_link'               => '#',
                    'download_url'           => $fm_radio_station_player_url,
                    'download_uses_track_url' => '0',
                ),
            );

            // Save track data as metadata (AudioIgniter format)
            update_post_meta($fm_radio_station_bwt_post_id, '_audioigniter_tracks', $fm_radio_station_featured_album_tracks);

            $fm_radio_station_playlist_ids[] = $fm_radio_station_bwt_post_id;
        }

        // Create 3 different pages - WP 6.2+ FIXED (No get_page_by_title)
        $page_titles = array('Player Page 1', 'Player Page 2', 'Player Page 3');
        foreach ($fm_radio_station_playlist_ids as $index => $playlist_id) {
            $page_title = $page_titles[$index];
            
            // WP_Query instead of deprecated get_page_by_title
            $page_query = new WP_Query(array(
                'post_type'      => 'page',
                'title'          => $page_title,
                'post_status'    => 'publish',
                'posts_per_page' => 1,
                'fields'         => 'ids'
            ));
            
            if ($page_query->have_posts()) {
                $existing_page_id = $page_query->posts[0];
                set_theme_mod("fm_radio_station_player_page_" . ($index + 1), $existing_page_id);
                wp_reset_postdata();
                continue;
            }
            wp_reset_postdata();

            $productpage = '[ai_playlist id="' . $playlist_id . '"]';
            $fm_radio_station_content = do_shortcode($productpage);

            $fm_radio_station_page = array(
                'post_type'    => 'page',
                'post_title'   => $page_title,
                'post_content' => $fm_radio_station_content,
                'post_status'  => 'publish',
                'post_author'  => 1,
                'post_slug'    => "player-page-" . ($index + 1)
            );

            $fm_radio_station_page_id = wp_insert_post($fm_radio_station_page);
            if (!is_wp_error($fm_radio_station_page_id)) {
                set_theme_mod("fm_radio_station_player_page_" . ($index + 1), $fm_radio_station_page_id);
            }
        } 

    }
?>