<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function fm_radio_station_categorized_blog() {
	$fm_radio_station_category_count = get_transient( 'fm_radio_station_categories' );

	if ( false === $fm_radio_station_category_count ) {
		// Create an array of all the categories that are attached to posts.
		$fm_radio_station_categories = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$fm_radio_station_category_count = count( $fm_radio_station_categories );

		set_transient( 'fm_radio_station_categories', $fm_radio_station_category_count );
	}

	// Allow viewing case of 0 or 1 categories in post preview.
	if ( is_preview() ) {
		return true;
	}

	return $fm_radio_station_category_count > 1;
}

if ( ! function_exists( 'fm_radio_station_the_custom_logo' ) ) :
/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 * @since FM Radio Station
 */
function fm_radio_station_the_custom_logo() {
	if ( function_exists( 'the_custom_logo' ) ) {
		the_custom_logo();
	}
}
endif;

/**
 * Flush out the transients used in fm_radio_station_categorized_blog.
 */
function fm_radio_station_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'fm_radio_station_categories' );
}
add_action( 'edit_category', 'fm_radio_station_category_transient_flusher' );
add_action( 'save_post',     'fm_radio_station_category_transient_flusher' );