<?php
/**
 * FM Radio Station: Customizer
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function fm_radio_station_customize_register( $wp_customize ) {

	// Pro Version
    class fm_radio_station_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>Unlock Premium <strong>'. esc_html( $this->label ) .'</strong>? </span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( FM_RADIO_STATION_BUY_TEXT,'fm-radio-station' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function fm_radio_station_sanitize_custom_control( $input ) {
        return $input;
    }

	require get_parent_theme_file_path('/inc/controls/range-slider-control.php');

	require get_parent_theme_file_path('/inc/controls/icon-changer.php');
	
	// Register the custom control type.
	$wp_customize->register_control_type( 'Fm_Radio_Station_Toggle_Control' );
	
	//Register the sortable control type.
	$wp_customize->register_control_type( 'Fm_Radio_Station_Control_Sortable' );

	//add home page setting pannel
	$wp_customize->add_panel( 'fm_radio_station_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Custom Home page', 'fm-radio-station' ),
	    'description' => __( 'Description of what this panel does.', 'fm-radio-station' ),
	) );
	
	//TP GENRAL OPTION
	$wp_customize->add_section('fm_radio_station_tp_general_settings',array(
        'title' => __('TP General Option', 'fm-radio-station'),
        'priority' => 1,
        'panel' => 'fm_radio_station_panel_id'
    ) );

    $wp_customize->add_setting('fm_radio_station_tp_body_layout_settings',array(
        'default' => 'Full',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
    $wp_customize->add_control('fm_radio_station_tp_body_layout_settings',array(
        'type' => 'radio',
        'label'     => __('Body Layout Setting', 'fm-radio-station'),
        'description'   => __('This option work for complete body, if you want to set the complete website in container.', 'fm-radio-station'),
        'section' => 'fm_radio_station_tp_general_settings',
        'choices' => array(
            'Full' => __('Full','fm-radio-station'),
            'Container' => __('Container','fm-radio-station'),
            'Container Fluid' => __('Container Fluid','fm-radio-station')
        ),
	) );

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('fm_radio_station_sidebar_post_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_sidebar_post_layout',array(
        'type' => 'radio',
        'label'     => __('Post Sidebar Position', 'fm-radio-station'),
        'description'   => __('This option work for blog page, blog single page, archive page and search page.', 'fm-radio-station'),
        'section' => 'fm_radio_station_tp_general_settings',
        'choices' => array(
            'full' => __('Full','fm-radio-station'),
            'left' => __('Left','fm-radio-station'),
            'right' => __('Right','fm-radio-station'),
            'three-column' => __('Three Columns','fm-radio-station'),
            'four-column' => __('Four Columns','fm-radio-station'),
            'grid' => __('Grid Layout','fm-radio-station')
        ),
	) );

	// Add Settings and Controls for post sidebar Layout
	$wp_customize->add_setting('fm_radio_station_sidebar_single_post_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_sidebar_single_post_layout',array(
        'type' => 'radio',
        'label'     => __('Single Post Sidebar Position', 'fm-radio-station'),
        'description'   => __('This option work for single blog page', 'fm-radio-station'),
        'section' => 'fm_radio_station_tp_general_settings',
        'choices' => array(
            'full' => __('Full','fm-radio-station'),
            'left' => __('Left','fm-radio-station'),
            'right' => __('Right','fm-radio-station'),
        ),
	) );

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('fm_radio_station_sidebar_page_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_sidebar_page_layout',array(
        'type' => 'radio',
        'label'     => __('Page Sidebar Position', 'fm-radio-station'),
        'description'   => __('This option work for pages.', 'fm-radio-station'),
        'section' => 'fm_radio_station_tp_general_settings',
        'choices' => array(
            'full' => __('Full','fm-radio-station'),
            'left' => __('Left','fm-radio-station'),
            'right' => __('Right','fm-radio-station')
        ),
	) );

	$wp_customize->add_setting( 'fm_radio_station_sticky', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_sticky', array(
		'label'       => esc_html__( 'Show Sticky Header', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_tp_general_settings',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_sticky',
	) ) );

	//tp typography option
	$fm_radio_station_font_array = array(
		''                       => 'No Fonts',
		'Abril Fatface'          => 'Abril Fatface',
		'Acme'                   => 'Acme',
		'Anton'                  => 'Anton',
		'Architects Daughter'    => 'Architects Daughter',
		'Arimo'                  => 'Arimo',
		'Arsenal'                => 'Arsenal',
		'Arvo'                   => 'Arvo',
		'Alegreya'               => 'Alegreya',
		'Alfa Slab One'          => 'Alfa Slab One',
		'Averia Serif Libre'     => 'Averia Serif Libre',
		'Bangers'                => 'Bangers',
		'Boogaloo'               => 'Boogaloo',
		'Bad Script'             => 'Bad Script',
		'Bitter'                 => 'Bitter',
		'Bree Serif'             => 'Bree Serif',
		'BenchNine'              => 'BenchNine',
		'Cabin'                  => 'Cabin',
		'Cardo'                  => 'Cardo',
		'Courgette'              => 'Courgette',
		'Cherry Swash'           => 'Cherry Swash',
		'Cormorant Garamond'     => 'Cormorant Garamond',
		'Crimson Text'           => 'Crimson Text',
		'Cuprum'                 => 'Cuprum',
		'Cookie'                 => 'Cookie',
		'Chewy'                  => 'Chewy',
		'Days One'               => 'Days One',
		'Dosis'                  => 'Dosis',
		'Droid Sans'             => 'Droid Sans',
		'Economica'              => 'Economica',
		'Fredoka One'            => 'Fredoka One',
		'Fjalla One'             => 'Fjalla One',
		'Francois One'           => 'Francois One',
		'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
		'Gloria Hallelujah'      => 'Gloria Hallelujah',
		'Great Vibes'            => 'Great Vibes',
		'Handlee'                => 'Handlee',
		'Hammersmith One'        => 'Hammersmith One',
		'Inconsolata'            => 'Inconsolata',
		'Indie Flower'           => 'Indie Flower',
		'Inter'                  => 'Inter',
		'IM Fell English SC'     => 'IM Fell English SC',
		'Julius Sans One'        => 'Julius Sans One',
		'Josefin Slab'           => 'Josefin Slab',
		'Josefin Sans'           => 'Josefin Sans',
		'Kanit'                  => 'Kanit',
		'Karla'                  => 'Karla',
		'Lobster'                => 'Lobster',
		'Lato'                   => 'Lato',
		'Lora'                   => 'Lora',
		'Libre Baskerville'      => 'Libre Baskerville',
		'Lobster Two'            => 'Lobster Two',
		'Manrope'           	 => 'Manrope',
		'Merriweather'           => 'Merriweather',
		'Monda'                  => 'Monda',
		'Montserrat'             => 'Montserrat',
		'Muli'                   => 'Muli',
		'Marck Script'           => 'Marck Script',
		'Noto Serif'             => 'Noto Serif',
		'Open Sans'              => 'Open Sans',
		'Overpass'               => 'Overpass',
		'Overpass Mono'          => 'Overpass Mono',
		'Oxygen'                 => 'Oxygen',
		'Oxanium'                => 'Oxanium',
		'Orbitron'               => 'Orbitron',
		'Patua One'              => 'Patua One',
		'Pacifico'               => 'Pacifico',
		'Padauk'                 => 'Padauk',
		'Playball'               => 'Playball',
		'Playfair Display'       => 'Playfair Display',
		'PT Sans'                => 'PT Sans',
		'Philosopher'            => 'Philosopher',
		'Permanent Marker'       => 'Permanent Marker',
		'Poiret One'             => 'Poiret One',
		'Quicksand'              => 'Quicksand',
		'Quattrocento Sans'      => 'Quattrocento Sans',
		'Raleway'                => 'Raleway',
		'Rubik'                  => 'Rubik',
		'Rokkitt'                => 'Rokkitt',
		'Roboto Serif'           => 'Roboto Serif',
		'Russo One'              => 'Russo One',
		'Righteous'              => 'Righteous',
		'Satisfy'                => 'Satisfy',
		'Slabo'                  => 'Slabo',
		'Source Sans Pro'        => 'Source Sans Pro',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shadows Into Light'     => 'Shadows Into Light',
		'Sacramento'             => 'Sacramento',
		'Shrikhand'              => 'Shrikhand',
		'Tangerine'              => 'Tangerine',
		'Ubuntu'                 => 'Ubuntu',
		'VT323'                  => 'VT323',
		'Varela Round'           => 'Varela Round',
		'Vampiro One'            => 'Vampiro One',
		'Vollkorn'               => 'Vollkorn',
		'Volkhov'                => 'Volkhov',
		'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
	);

	$wp_customize->add_section('fm_radio_station_typography_option',array(
		'title'         => __('TP Typography Option', 'fm-radio-station'),
		'priority' => 1,
		'panel' => 'fm_radio_station_panel_id'
   	));

   	$wp_customize->add_setting('fm_radio_station_heading_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'fm_radio_station_sanitize_choices',
	));
	$wp_customize->add_control(	'fm_radio_station_heading_font_family', array(
		'section' => 'fm_radio_station_typography_option',
		'label'   => __('heading Fonts', 'fm-radio-station'),
		'type'    => 'select',
		'choices' => $fm_radio_station_font_array,
	));

	$wp_customize->add_setting('fm_radio_station_body_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'fm_radio_station_sanitize_choices',
	));
	$wp_customize->add_control(	'fm_radio_station_body_font_family', array(
		'section' => 'fm_radio_station_typography_option',
		'label'   => __('Body Fonts', 'fm-radio-station'),
		'type'    => 'select',
		'choices' => $fm_radio_station_font_array,
	));

	//TP Preloader Option
	$wp_customize->add_section('fm_radio_station_prelaoder_option',array(
		'title'         => __('TP Preloader Option', 'fm-radio-station'),
		'priority' => 1,
		'panel' => 'fm_radio_station_panel_id'
	) );

	$wp_customize->add_setting( 'fm_radio_station_preloader_show_hide', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_preloader_show_hide', array(
		'label'       => esc_html__( 'Show / Hide Preloader Option', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_prelaoder_option',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_preloader_show_hide',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_tp_preloader_color1_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_tp_preloader_color1_option', array(
			'label'     => __('Preloader First Ring Color', 'fm-radio-station'),
	    'description' => __('It will change the complete theme preloader ring 1 color in one click.', 'fm-radio-station'),
	    'section' => 'fm_radio_station_prelaoder_option',
	    'settings' => 'fm_radio_station_tp_preloader_color1_option',
  	)));

  	$wp_customize->add_setting( 'fm_radio_station_tp_preloader_color2_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_tp_preloader_color2_option', array(
			'label'     => __('Preloader Second Ring Color', 'fm-radio-station'),
	    'description' => __('It will change the complete theme preloader ring 2 color in one click.', 'fm-radio-station'),
	    'section' => 'fm_radio_station_prelaoder_option',
	    'settings' => 'fm_radio_station_tp_preloader_color2_option',
  	)));

  	$wp_customize->add_setting( 'fm_radio_station_tp_preloader_bg_color_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_tp_preloader_bg_color_option', array(
			'label'     => __('Preloader Background Color', 'fm-radio-station'),
	    'description' => __('It will change the complete theme preloader bg color in one click.', 'fm-radio-station'),
	    'section' => 'fm_radio_station_prelaoder_option',
	    'settings' => 'fm_radio_station_tp_preloader_bg_color_option',
  	)));

  	// Pro Version
    $wp_customize->add_setting( 'fm_radio_station_preloader_pro_version_logo', array(
        'sanitize_callback' => 'fm_radio_station_sanitize_custom_control'
    ));
    $wp_customize->add_control( new fm_radio_station_Customize_Pro_Version ( $wp_customize,'fm_radio_station_preloader_pro_version_logo', array(
        'section'     => 'fm_radio_station_prelaoder_option',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'fm-radio-station' ),
        'description' => esc_url( FM_RADIO_STATION_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//TP Color Option
	$wp_customize->add_section('fm_radio_station_color_option',array(
     'title'         => __('TP Color Option', 'fm-radio-station'),
     'priority' => 1,
     'panel' => 'fm_radio_station_panel_id'
    ) );
    
	$wp_customize->add_setting( 'fm_radio_station_tp_color_option_first', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_tp_color_option_first', array(
			'label'     => __('Theme First Color', 'fm-radio-station'),
	    'description' => __('It will change the complete theme color in one click.', 'fm-radio-station'),
	    'section' => 'fm_radio_station_color_option',
	    'settings' => 'fm_radio_station_tp_color_option_first',
  	)));

  	$wp_customize->add_setting( 'fm_radio_station_tp_color_option_sec', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_tp_color_option_sec', array(
			'label'     => __('Theme Second Color', 'fm-radio-station'),
	    'description' => __('It will change the complete theme color in one click.', 'fm-radio-station'),
	    'section' => 'fm_radio_station_color_option',
	    'settings' => 'fm_radio_station_tp_color_option_sec',
  	)));

	//TP Blog Option
	$wp_customize->add_section('fm_radio_station_blog_option',array(
        'title' => __('TP Blog Option', 'fm-radio-station'),
        'priority' => 1,
        'panel' => 'fm_radio_station_panel_id'
    ) );

    $wp_customize->add_setting('fm_radio_station_edit_blog_page_title',array(
		'default'=> __('Home','fm-radio-station'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_edit_blog_page_title',array(
		'label'	=> __('Change Blog Page Title','fm-radio-station'),
		'section'=> 'fm_radio_station_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fm_radio_station_edit_blog_page_description',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_edit_blog_page_description',array(
		'label'	=> __('Add Blog Page Description','fm-radio-station'),
		'section'=> 'fm_radio_station_blog_option',
		'type'=> 'text'
	));

	/** Meta Order */
    $wp_customize->add_setting('blog_meta_order', array(
        'default' => array('date', 'author', 'comment','category', 'time'),
        'sanitize_callback' => 'fm_radio_station_sanitize_sortable',
    ));
    $wp_customize->add_control(new Fm_Radio_Station_Control_Sortable($wp_customize, 'blog_meta_order', array(
    	'label' => esc_html__('Meta Order', 'fm-radio-station'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'fm-radio-station') ,
        'section' => 'fm_radio_station_blog_option',
        'choices' => array(
            'date' => __('date', 'fm-radio-station') ,
            'author' => __('author', 'fm-radio-station') ,
            'comment' => __('comment', 'fm-radio-station') ,
            'category' => __('category', 'fm-radio-station') ,
            'time' => __('time', 'fm-radio-station') ,
        ) ,
    )));

    $wp_customize->add_setting( 'fm_radio_station_excerpt_count', array(
		'default'              => 35,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fm_radio_station_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'fm_radio_station_excerpt_count', array(
		'label'       => esc_html__( 'Edit Excerpt Limit','fm-radio-station' ),
		'section'     => 'fm_radio_station_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

    $wp_customize->add_setting('fm_radio_station_read_more_text',array(
		'default'=> __('Read More','fm-radio-station'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_read_more_text',array(
		'label'	=> __('Edit Button Text','fm-radio-station'),
		'section'=> 'fm_radio_station_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fm_radio_station_post_image_round', array(
	  'default' => '0',
      'sanitize_callback' => 'fm_radio_station_sanitize_number_range',
	));
	$wp_customize->add_control(new Fm_Radio_Station_Range_Slider($wp_customize, 'fm_radio_station_post_image_round', array(
       'section' => 'fm_radio_station_blog_option',
      'label' => esc_html__('Edit Post Image Border Radius', 'fm-radio-station'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 180,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('fm_radio_station_post_image_width', array(
	  'default' => '',
      'sanitize_callback' => 'fm_radio_station_sanitize_number_range',
	));
	$wp_customize->add_control(new Fm_Radio_Station_Range_Slider($wp_customize, 'fm_radio_station_post_image_width', array(
       'section' => 'fm_radio_station_blog_option',
      'label' => esc_html__('Edit Post Image Width', 'fm-radio-station'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 367,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('fm_radio_station_post_image_length', array(
	  'default' => '',
      'sanitize_callback' => 'fm_radio_station_sanitize_number_range',
	));
	$wp_customize->add_control(new Fm_Radio_Station_Range_Slider($wp_customize, 'fm_radio_station_post_image_length', array(
       'section' => 'fm_radio_station_blog_option',
      'label' => esc_html__('Edit Post Image height', 'fm-radio-station'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 900,
        'step' => 1
    )
	)));
	
	$wp_customize->add_setting( 'fm_radio_station_remove_read_button', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_remove_read_button', array(
		'label'       => esc_html__( 'Show / Hide Read More Button', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_blog_option',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_remove_read_button',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_remove_tags', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_remove_tags', array(
		'label'       => esc_html__( 'Show / Hide Tags Option', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_blog_option',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_remove_tags',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_remove_category', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_remove_category', array(
		'label'       => esc_html__( 'Show / Hide Category Option', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_blog_option',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_remove_category',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_remove_comment', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
 	) );

	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_remove_comment', array(
	 'label'       => esc_html__( 'Show / Hide Comment Form', 'fm-radio-station' ),
	 'section'     => 'fm_radio_station_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'fm_radio_station_remove_comment',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_remove_related_post', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
 	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_remove_related_post', array(
	 'label'       => esc_html__( 'Show / Hide Related Post', 'fm-radio-station' ),
	 'section'     => 'fm_radio_station_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'fm_radio_station_remove_related_post',
	) ) );

	$wp_customize->add_setting('fm_radio_station_related_post_heading',array(
		'default'=> __('Related Posts','fm-radio-station'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_related_post_heading',array(
		'label'	=> __('Edit Section Title','fm-radio-station'),
		'section'=> 'fm_radio_station_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'fm_radio_station_related_post_per_page', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fm_radio_station_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'fm_radio_station_related_post_per_page', array(
		'label'       => esc_html__( 'Related Post Per Page','fm-radio-station' ),
		'section'     => 'fm_radio_station_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 3,
			'max'              => 9,
		),
	) );

	$wp_customize->add_setting( 'fm_radio_station_related_post_per_columns', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fm_radio_station_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'fm_radio_station_related_post_per_columns', array(
		'label'       => esc_html__( 'Related Post Per Row','fm-radio-station' ),
		'section'     => 'fm_radio_station_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 4,
		),
	) );

	$wp_customize->add_setting('fm_radio_station_post_layout',array(
        'default' => 'image-content',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_post_layout',array(
        'type' => 'radio',
        'label'     => __('Post Layout', 'fm-radio-station'),
        'section' => 'fm_radio_station_blog_option',
        'choices' => array(
            'image-content' => __('Media-Content','fm-radio-station'),
            'content-image' => __('Content-Media','fm-radio-station'),
        ),
	) );

	//TP Single Blog Option
	$wp_customize->add_section('fm_radio_station_single_blog_option',array(
        'title' => __('Single Post Option', 'fm-radio-station'),
        'priority' => 1,
        'panel' => 'fm_radio_station_panel_id'
    ) );

    /** Meta Order */
    $wp_customize->add_setting('fm_radio_station_single_blog_meta_order', array(
        'default' => array('date', 'author', 'comment','category', 'time'),
        'sanitize_callback' => 'fm_radio_station_sanitize_sortable',
    ));
    $wp_customize->add_control(new fm_radio_station_Control_Sortable($wp_customize, 'fm_radio_station_single_blog_meta_order', array(
    	'label' => esc_html__('Meta Order', 'fm-radio-station'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'fm-radio-station') ,
        'section' => 'fm_radio_station_single_blog_option',
        'choices' => array(
            'date' => __('date', 'fm-radio-station') ,
            'author' => __('author', 'fm-radio-station') ,
            'comment' => __('comment', 'fm-radio-station') ,
            'category' => __('category', 'fm-radio-station') ,
            'time' => __('time', 'fm-radio-station') ,
        ) ,
    )));

    $wp_customize->add_setting('fm_radio_station_single_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new fm_radio_station_Icon_Changer(
       $wp_customize,'fm_radio_station_single_post_date_icon',array(
		'label'	=> __('Change Date Icon','fm-radio-station'),
		'transport' => 'refresh',
		'section'	=> 'fm_radio_station_single_blog_option',
		'type'		=> 'fm-radio-station-icon'
	)));

	$wp_customize->add_setting('fm_radio_station_single_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new fm_radio_station_Icon_Changer(
       $wp_customize,'fm_radio_station_single_post_author_icon',array(
		'label'	=> __('Change Author Icon','fm-radio-station'),
		'transport' => 'refresh',
		'section'	=> 'fm_radio_station_single_blog_option',
		'type'		=> 'fm-radio-station-icon'
	)));

	$wp_customize->add_setting('fm_radio_station_single_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new fm_radio_station_Icon_Changer(
       $wp_customize,'fm_radio_station_single_post_comment_icon',array(
		'label'	=> __('Change Comment Icon','fm-radio-station'),
		'transport' => 'refresh',
		'section'	=> 'fm_radio_station_single_blog_option',
		'type'		=> 'fm-radio-station-icon'
	)));

	$wp_customize->add_setting('fm_radio_station_single_post_category_icon',array(
		'default'	=> 'fas fa-list',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new fm_radio_station_Icon_Changer(
       $wp_customize,'fm_radio_station_single_post_category_icon',array(
		'label'	=> __('Change Category Icon','fm-radio-station'),
		'transport' => 'refresh',
		'section'	=> 'fm_radio_station_single_blog_option',
		'type'		=> 'fm-radio-station-icon'
	)));

	$wp_customize->add_setting('fm_radio_station_single_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new fm_radio_station_Icon_Changer(
       $wp_customize,'fm_radio_station_single_post_time_icon',array(
		'label'	=> __('Change Time Icon','fm-radio-station'),
		'transport' => 'refresh',
		'section'	=> 'fm_radio_station_single_blog_option',
		'type'		=> 'fm-radio-station-icon'
	)));

	//MENU TYPOGRAPHY
	$wp_customize->add_section( 'fm_radio_station_menu_typography', array(
    	'title'      => __( 'Menu Typography', 'fm-radio-station' ),
    	'priority' => 2,
		'panel' => 'fm_radio_station_panel_id'
	) );

	$wp_customize->add_setting('fm_radio_station_menu_font_weight',array(
        'default' => '',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_menu_font_weight',array(
     'type' => 'radio',
     'label'     => __('Font Weight', 'fm-radio-station'),
     'section' => 'fm_radio_station_menu_typography',
     'type' => 'select',
     'choices' => array(
         '100' => __('100','fm-radio-station'),
         '200' => __('200','fm-radio-station'),
         '300' => __('300','fm-radio-station'),
         '400' => __('400','fm-radio-station'),
         '500' => __('500','fm-radio-station'),
         '600' => __('600','fm-radio-station'),
         '700' => __('700','fm-radio-station'),
         '800' => __('800','fm-radio-station'),
         '900' => __('900','fm-radio-station')
     ),
	) );

	$wp_customize->add_setting('fm_radio_station_menu_text_tranform',array(
		'default' => '',
		'sanitize_callback' => 'fm_radio_station_sanitize_choices'
 	));
 	$wp_customize->add_control('fm_radio_station_menu_text_tranform',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','fm-radio-station'),
		'section' => 'fm_radio_station_menu_typography',
		'choices' => array(
		   'Uppercase' => __('Uppercase','fm-radio-station'),
		   'Lowercase' => __('Lowercase','fm-radio-station'),
		   'Capitalize' => __('Capitalize','fm-radio-station'),
		),
	) );
	$wp_customize->add_setting('fm_radio_station_menu_font_size', array(
	  'default' => '',
      'sanitize_callback' => 'fm_radio_station_sanitize_number_range',
	));
	$wp_customize->add_control(new Fm_Radio_Station_Range_Slider($wp_customize, 'fm_radio_station_menu_font_size', array(
        'section' => 'fm_radio_station_menu_typography',
        'label' => esc_html__('Font Size', 'fm-radio-station'),
        'input_attrs' => array(
          'min' => 0,
          'max' => 20,
          'step' => 1
    )
	)));

	$wp_customize->add_setting( 'fm_radio_station_menu_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_menu_color', array(
			'label'     => __('Change Menu Color', 'fm-radio-station'),
	    'section' => 'fm_radio_station_menu_typography',
	    'settings' => 'fm_radio_station_menu_color',
  	)));

  	// Pro Version
    $wp_customize->add_setting( 'fm_radio_station_menu_pro_version_logo', array(
        'sanitize_callback' => 'fm_radio_station_sanitize_custom_control'
    ));
    $wp_customize->add_control( new fm_radio_station_Customize_Pro_Version ( $wp_customize,'fm_radio_station_menu_pro_version_logo', array(
        'section'     => 'fm_radio_station_menu_typography',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'fm-radio-station' ),
        'description' => esc_url( FM_RADIO_STATION_PRO_THEME_URL ),
        'priority'    => 100
    )));

	// Header detail
	$wp_customize->add_section( 'fm_radio_station_header_sec', array(
    	'title'      => __( 'Header Details', 'fm-radio-station' ),
    	'description' => __( 'Add your Header details here', 'fm-radio-station' ),
		'panel' => 'fm_radio_station_panel_id',
      'priority' => 2,
	) );

	$wp_customize->add_setting('fm_radio_station_header_first_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('fm_radio_station_header_first_link',array(
		'label'	=> __('Music Library Link','fm-radio-station'),
		'section'=> 'fm_radio_station_header_sec',
		'type'=> 'url'
	));

	// Pro Version
    $wp_customize->add_setting( 'fm_radio_station_header_pro_version_logo', array(
        'sanitize_callback' => 'fm_radio_station_sanitize_custom_control'
    ));
    $wp_customize->add_control( new fm_radio_station_Customize_Pro_Version ( $wp_customize,'fm_radio_station_header_pro_version_logo', array(
        'section'     => 'fm_radio_station_header_sec',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'fm-radio-station' ),
        'description' => esc_url( FM_RADIO_STATION_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//home page slider
	$wp_customize->add_section( 'fm_radio_station_slider_section' , array(
    	'title'      => __( 'Slider Section', 'fm-radio-station' ),
    	'priority' => 2,
		'panel' => 'fm_radio_station_panel_id'
	) );

	$wp_customize->add_setting( 'fm_radio_station_slider_arrows', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_slider_arrows', array(
		'label'       => esc_html__( 'Show / Hide slider', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_slider_section',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_slider_arrows',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_show_slider_title', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_show_slider_title', array(
		'label'       => esc_html__( 'Show / Hide Slider Heading', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_slider_section',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_show_slider_title',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_show_slider_content', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_show_slider_content', array(
		'label'       => esc_html__( 'Show / Hide Slider Content', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_slider_section',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_show_slider_content',
	) ) );

	for ( $fm_radio_station_count = 1; $fm_radio_station_count <= 1; $fm_radio_station_count++ ) {

		$wp_customize->add_setting( 'fm_radio_station_slider_page' . $fm_radio_station_count, array(
			'default'           => '',
			'sanitize_callback' => 'fm_radio_station_sanitize_dropdown_pages'
		) );

		$wp_customize->add_control( 'fm_radio_station_slider_page' . $fm_radio_station_count, array(
			'label'    => __( 'Select Slide Image Page', 'fm-radio-station' ),
			'section'  => 'fm_radio_station_slider_section',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('fm_radio_station_slider_short_heading',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_slider_short_heading',array(
		'label'	=> __('Add short Heading','fm-radio-station'),
		'section'=> 'fm_radio_station_slider_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'fm_radio_station_track_player_page', array(
		'default'           => '',
		'sanitize_callback' => 'fm_radio_station_sanitize_dropdown_pages'
	) );
	$wp_customize->add_control( 'fm_radio_station_track_player_page', array(
		'label'    => __( 'Select Page of Player', 'fm-radio-station' ),
		'section'  => 'fm_radio_station_slider_section',
		'type'     => 'dropdown-pages'
	) );

	//Slider excerpt
	$wp_customize->add_setting( 'fm_radio_station_slider_excerpt_length', array(
		'default'              => 50,
		'sanitize_callback'	=> 'absint',
	) );
	$wp_customize->add_control( 'fm_radio_station_slider_excerpt_length', array(
		'label'       => esc_html__( 'Slider Content length','fm-radio-station' ),
		'section'     => 'fm_radio_station_slider_section',
		'type'        => 'number',
		'settings'    => 'fm_radio_station_slider_excerpt_length',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 100,
		),
	) );

	// Pro Version
    $wp_customize->add_setting( 'fm_radio_station_slider_pro_version_logo', array(
        'sanitize_callback' => 'fm_radio_station_sanitize_custom_control'
    ));
    $wp_customize->add_control( new fm_radio_station_Customize_Pro_Version ( $wp_customize,'fm_radio_station_slider_pro_version_logo', array(
        'section'     => 'fm_radio_station_slider_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'fm-radio-station' ),
        'description' => esc_url( FM_RADIO_STATION_PRO_THEME_URL ),
        'priority'    => 100
    )));

	/*=========================================
	liver player Section
	=========================================*/
	$wp_customize->add_section(
		'fm_radio_station_live_player_section', array(
			'title' => esc_html__( 'Live Player Section', 'fm-radio-station' ),
			'priority' => 3,
			'panel' => 'fm_radio_station_panel_id',
		)
	);

	$wp_customize->add_setting( 'fm_radio_station_live_player_show_hide', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_live_player_show_hide', array(
		'label'       => esc_html__( 'Show / Hide Live Player Content', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_live_player_section',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_live_player_show_hide',
	) ) );

	$wp_customize->add_setting('fm_radio_station_featured_section_title', array(
	  'default' => '',
	  'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_featured_section_title', array(
	  'label' => __('Add Small Heading', 'fm-radio-station'),
	  'section' => 'fm_radio_station_live_player_section',
	  'type' => 'text'
	));

	$wp_customize->add_setting('fm_radio_station_serv_short_heading',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_serv_short_heading',array(
		'label'	=> __('Add Heading','fm-radio-station'),
		'section'=> 'fm_radio_station_live_player_section',
		'type'=> 'text'
	));

	// Number of stations (UNLIMITED, 1-100)
	$wp_customize->add_setting( 'fm_radio_station_number_of_stations', array(
	    'default'           => '3',
	    'sanitize_callback' => 'absint'
	) );
	$wp_customize->add_control( 'fm_radio_station_number_of_stations', array(
	    'label'    => __( 'Number of FM Radio Stations to Display', 'fm-radio-station' ),
	    'section'  => 'fm_radio_station_live_player_section',
	    'type'     => 'number',
	    'input_attrs' => array(
	        'min'  => 1,
	        'step' => 1
	    ),
	    'description' => __( 'Enter Number of FM Radio Stations to Display (Default: 3)', 'fm-radio-station' )
	) );

	// Read current value from DB (fallback 3)
    $fm_radio_station_number_of_stations = absint( get_theme_mod( 'fm_radio_station_number_of_stations', 3 ) );
    
    $fm_radio_station_number_of_stations = min( $fm_radio_station_number_of_stations, 100 ); // safety limit

    for ( $i = 1; $i <= $fm_radio_station_number_of_stations; $i++ ) {
        $wp_customize->add_setting( 'fm_radio_station_player_page_' . $i, array(
            'default'           => '',
            'sanitize_callback' => 'absint',
        ) );

        $wp_customize->add_control( 'fm_radio_station_player_page_' . $i, array(
            'label'   => sprintf( __( 'Select FM Radio Station Page #%d', 'fm-radio-station' ), $i ),
            'section' => 'fm_radio_station_live_player_section',
            'type'    => 'dropdown-pages',
        ) );
    }

    // Pro Version
    $wp_customize->add_setting( 'fm_radio_station_about_pro_version_logo', array(
        'sanitize_callback' => 'fm_radio_station_sanitize_custom_control'
    ));
    $wp_customize->add_control( new fm_radio_station_Customize_Pro_Version ( $wp_customize,'fm_radio_station_about_pro_version_logo', array(
        'section'     => 'fm_radio_station_live_player_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'fm-radio-station' ),
        'description' => esc_url( FM_RADIO_STATION_PRO_THEME_URL ),
    )));

	//----------------------------footer------------------------
	$wp_customize->add_section('fm_radio_station_footer_section',array(
		'title'	=> __('Footer Widget Settings','fm-radio-station'),
		'panel' => 'fm_radio_station_panel_id',
		'priority' => 4,
	));

	$wp_customize->add_setting('fm_radio_station_footer_columns',array(
		'default'	=> 4,
		'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_footer_columns',array(
		'label'	=> __('Footer Widget Columns','fm-radio-station'),
		'section'	=> 'fm_radio_station_footer_section',
		'setting'	=> 'fm_radio_station_footer_columns',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 4,
		),
	));
	$wp_customize->add_setting( 'fm_radio_station_tp_footer_bg_color_option', array(
		'default' => '#151515',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_tp_footer_bg_color_option', array(
		'label'     => __('Footer Widget Background Color', 'fm-radio-station'),
		'description' => __('It will change the complete footer widget backgorund color.', 'fm-radio-station'),
		'section' => 'fm_radio_station_footer_section',
		'settings' => 'fm_radio_station_tp_footer_bg_color_option',
	)));

	$wp_customize->add_setting('fm_radio_station_footer_widget_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'fm_radio_station_footer_widget_image',array(
       'label' => __('Footer Widget Background Image','fm-radio-station'),
       'section' => 'fm_radio_station_footer_section'
	)));

	//footer widget title font size
	$wp_customize->add_setting('fm_radio_station_footer_widget_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_footer_widget_title_font_size',array(
		'label'	=> __('Change Footer Widget Title Font Size in PX','fm-radio-station'),
		'section'	=> 'fm_radio_station_footer_section',
	    'setting'	=> 'fm_radio_station_footer_widget_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'fm_radio_station_footer_widget_title_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_footer_widget_title_color', array(
			'label'     => __('Change Footer Widget Title Color', 'fm-radio-station'),
	    'section' => 'fm_radio_station_footer_section',
	    'settings' => 'fm_radio_station_footer_widget_title_color',
  	)));

  	$wp_customize->add_setting('fm_radio_station_footer_widget_title_font_weight',array(
        'default' => '',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_footer_widget_title_font_weight',array(
     'type' => 'radio',
     'label'     => __('Change Footer Widget Title Font Weight', 'fm-radio-station'),
     'section' => 'fm_radio_station_footer_section',
     'type' => 'select',
     'choices' => array(
         '100' => __('100','fm-radio-station'),
         '200' => __('200','fm-radio-station'),
         '300' => __('300','fm-radio-station'),
         '400' => __('400','fm-radio-station'),
         '500' => __('500','fm-radio-station'),
         '600' => __('600','fm-radio-station'),
         '700' => __('700','fm-radio-station'),
         '800' => __('800','fm-radio-station'),
         '900' => __('900','fm-radio-station')
     ),
	) );

	$wp_customize->add_setting('fm_radio_station_footer_widget_title_text_tranform',array(
		'default' => '',
		'sanitize_callback' => 'fm_radio_station_sanitize_choices'
 	));
 	$wp_customize->add_control('fm_radio_station_footer_widget_title_text_tranform',array(
		'type' => 'select',
		'label' => __('Change Footer Widget Title Letter Case','fm-radio-station'),
		'section' => 'fm_radio_station_footer_section',
		'choices' => array(
		   'Uppercase' => __('Uppercase','fm-radio-station'),
		   'Lowercase' => __('Lowercase','fm-radio-station'),
		   'Capitalize' => __('Capitalize','fm-radio-station'),
		),
	) );

	// Add Settings and Controls for position
	$wp_customize->add_setting('fm_radio_station_footer_widget_title_position',array(
        'default' => '',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_footer_widget_title_position',array(
        'type' => 'radio',
        'label'     => __('Change Footer Widget Position', 'fm-radio-station'),
        'description'   => __('This option work for Footer Widget', 'fm-radio-station'),
        'section' => 'fm_radio_station_footer_section',
        'choices' => array(
            'Right' => __('Right','fm-radio-station'),
            'Left' => __('Left','fm-radio-station'),
            'Center' => __('Center','fm-radio-station')
        ),
	) );
  	
	$wp_customize->add_setting( 'fm_radio_station_return_to_header', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_return_to_header', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_footer_section',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_return_to_header',
	) ) );

	$wp_customize->add_setting('fm_radio_station_return_icon',array(
		'default'	=> 'fas fa-arrow-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fm_Radio_Station_Icon_Changer(
       $wp_customize,'fm_radio_station_return_icon',array(
		'label'	=> __('Return to header Icon','fm-radio-station'),
		'transport' => 'refresh',
		'section'	=> 'fm_radio_station_footer_section',
		'type'		=> 'fm-radio-station-icon'
	)));


    // Add Settings and Controls for Scroll top
	$wp_customize->add_setting('fm_radio_station_scroll_top_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_scroll_top_position',array(
        'type' => 'radio',
        'label'     => __('Scroll to top Position', 'fm-radio-station'),
        'description'   => __('This option work for scroll to top', 'fm-radio-station'),
        'section' => 'fm_radio_station_footer_section',
        'choices' => array(
            'Right' => __('Right','fm-radio-station'),
            'Left' => __('Left','fm-radio-station'),
            'Center' => __('Center','fm-radio-station')
        ),
	) );

	// Pro Version
    $wp_customize->add_setting( 'fm_radio_station_footer_widget_pro_version_logo', array(
        'sanitize_callback' => 'fm_radio_station_sanitize_custom_control'
    ));
    $wp_customize->add_control( new fm_radio_station_Customize_Pro_Version ( $wp_customize,'fm_radio_station_footer_widget_pro_version_logo', array(
        'section'     => 'fm_radio_station_footer_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'fm-radio-station' ),
        'description' => esc_url( FM_RADIO_STATION_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//footer
	$wp_customize->add_section('fm_radio_station_footer_copyright_section',array(
		'title'	=> __('Footer Copyright Settings','fm-radio-station'),
		'description'	=> __('Add copyright text.','fm-radio-station'),
		'panel' => 'fm_radio_station_panel_id',
		'priority' => 5,
	));

	$wp_customize->add_setting('fm_radio_station_footer_text',array(
		'default' => __( 'FM Radio Station WordPress Theme', 'fm-radio-station' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_footer_text',array(
		'label'	=> __('Copyright Text','fm-radio-station'),
		'section'	=> 'fm_radio_station_footer_copyright_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('fm_radio_station_footer_copyright_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_footer_copyright_font_size',array(
		'label'	=> __('Change Footer Copyright Font Size in PX','fm-radio-station'),
		'section'	=> 'fm_radio_station_footer_copyright_section',
	    'setting'	=> 'fm_radio_station_footer_copyright_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'fm_radio_station_footer_copyright_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_footer_copyright_text_color', array(
			'label'     => __('Change Footer Copyright Text Color', 'fm-radio-station'),
	    'section' => 'fm_radio_station_footer_copyright_section',
	    'settings' => 'fm_radio_station_footer_copyright_text_color',
  	)));

  	$wp_customize->add_setting('fm_radio_station_footer_copyright_top_bottom_padding',array(
		'default'	=> '',
		'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_footer_copyright_top_bottom_padding',array(
		'label'	=> __('Change Footer Copyright Padding in PX','fm-radio-station'),
		'section'	=> 'fm_radio_station_footer_copyright_section',
	    'setting'	=> 'fm_radio_station_footer_copyright_top_bottom_padding',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	// Add Settings and Controls for Scroll top
	$wp_customize->add_setting('fm_radio_station_copyright_text_position',array(
        'default' => 'Center',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_copyright_text_position',array(
        'type' => 'radio',
        'label'     => __('Copyright Text Position', 'fm-radio-station'),
        'description'   => __('This option work for Copyright', 'fm-radio-station'),
        'section' => 'fm_radio_station_footer_copyright_section',
        'choices' => array(
            'Right' => __('Right','fm-radio-station'),
            'Left' => __('Left','fm-radio-station'),
            'Center' => __('Center','fm-radio-station')
        ),
	) );

	// Pro Version
    $wp_customize->add_setting( 'fm_radio_station_copyright_pro_version_logo', array(
        'sanitize_callback' => 'fm_radio_station_sanitize_custom_control'
    ));
    $wp_customize->add_control( new fm_radio_station_Customize_Pro_Version ( $wp_customize,'fm_radio_station_copyright_pro_version_logo', array(
        'section'     => 'fm_radio_station_footer_copyright_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'fm-radio-station' ),
        'description' => esc_url( FM_RADIO_STATION_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//Mobile resposnsive
	$wp_customize->add_section('fm_radio_station_mobile_media_option',array(
		'title'         => __('Mobile Responsive media', 'fm-radio-station'),
		'description' => __('Control will not function if the toggle in the main settings is off.', 'fm-radio-station'),
		'priority' => 5,
		'panel' => 'fm_radio_station_panel_id'
	) );

	$wp_customize->add_setting( 'fm_radio_station_mobile_blog_description', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_mobile_blog_description', array(
		'label'       => esc_html__( 'Show / Hide Blog Page Description', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_mobile_blog_description',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_return_to_header_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_return_to_header_mob', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_return_to_header_mob',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_slider_buttom_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_slider_buttom_mob', array(
		'label'       => esc_html__( 'Show / Hide Slider Button', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_slider_buttom_mob',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_related_post_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_related_post_mob', array(
		'label'       => esc_html__( 'Show / Hide Related Post', 'fm-radio-station' ),
		'section'     => 'fm_radio_station_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_related_post_mob',
	) ) );

	// Pro Version
    $wp_customize->add_setting( 'fm_radio_station_responsive_pro_version_logo', array(
        'sanitize_callback' => 'fm_radio_station_sanitize_custom_control'
    ));
    $wp_customize->add_control( new fm_radio_station_Customize_Pro_Version ( $wp_customize,'fm_radio_station_responsive_pro_version_logo', array(
        'section'     => 'fm_radio_station_mobile_media_option',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'fm-radio-station' ),
        'description' => esc_url( FM_RADIO_STATION_PRO_THEME_URL ),
        'priority'    => 100
    )));

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';

	//site Title
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'fm_radio_station_customize_partial_blogname',
	) );

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'fm_radio_station_customize_partial_blogdescription',
	) );

	$wp_customize->add_setting( 'fm_radio_station_site_title', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_site_title', array(
		'label'       => esc_html__( 'Show / Hide Site Title', 'fm-radio-station' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_site_title',
	) ) );

	// logo site title size
	$wp_customize->add_setting('fm_radio_station_site_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_site_title_font_size',array(
		'label'	=> __('Site Title Font Size in PX','fm-radio-station'),
		'section'	=> 'title_tagline',
		'setting'	=> 'fm_radio_station_site_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
		    'step'             => 1,
			'min'              => 0,
			'max'              => 30,
			),
	));

	$wp_customize->add_setting( 'fm_radio_station_site_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_site_tagline_color', array(
			'label'     => __('Change Site Title Color', 'fm-radio-station'),
	    'section' => 'title_tagline',
	    'settings' => 'fm_radio_station_site_tagline_color',
  	)));

	$wp_customize->add_setting( 'fm_radio_station_site_tagline', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_site_tagline', array(
		'label'       => esc_html__( 'Show / Hide Site Tagline', 'fm-radio-station' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_site_tagline',
	) ) );

	// logo site tagline size
	$wp_customize->add_setting('fm_radio_station_site_tagline_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_site_tagline_font_size',array(
		'label'	=> __('Site Tagline Font Size in PX','fm-radio-station'),
		'section'	=> 'title_tagline',
		'setting'	=> 'fm_radio_station_site_tagline_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 30,
		),
	));

	$wp_customize->add_setting( 'fm_radio_station_logo_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_logo_tagline_color', array(
			'label'     => __('Change Site Tagline Color', 'fm-radio-station'),
	    'section' => 'title_tagline',
	    'settings' => 'fm_radio_station_logo_tagline_color',
  	)));

    $wp_customize->add_setting('fm_radio_station_logo_width',array(
	   'default' => 80,
	   'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_logo_width',array(
		'label'	=> esc_html__('Here You Can Customize Your Logo Size','fm-radio-station'),
		'section'	=> 'title_tagline',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('fm_radio_station_per_columns',array(
		'default'=> 3,
		'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_per_columns',array(
		'label'	=> __('Product Per Row','fm-radio-station'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));

	$wp_customize->add_setting('fm_radio_station_product_per_page',array(
		'default'=> 9,
		'sanitize_callback'	=> 'fm_radio_station_sanitize_number_absint'
	));
	$wp_customize->add_control('fm_radio_station_product_per_page',array(
		'label'	=> __('Product Per Page','fm-radio-station'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));

	$wp_customize->add_setting( 'fm_radio_station_product_sidebar', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Shop Page Sidebar', 'fm-radio-station' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_product_sidebar',
	) ) );
	$wp_customize->add_setting('fm_radio_station_sale_tag_position',array(
        'default' => 'right',
        'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
	$wp_customize->add_control('fm_radio_station_sale_tag_position',array(
        'type' => 'radio',
        'label'     => __('Sale Badge Position', 'fm-radio-station'),
        'description'   => __('This option work for Archieve Products', 'fm-radio-station'),
        'section' => 'woocommerce_product_catalog',
        'choices' => array(
            'left' => __('Left','fm-radio-station'),
            'right' => __('Right','fm-radio-station'),
        ),
	) );
	$wp_customize->add_setting( 'fm_radio_station_single_product_sidebar', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_single_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Product Page Sidebar', 'fm-radio-station' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_single_product_sidebar',
	) ) );

	$wp_customize->add_setting( 'fm_radio_station_related_product', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_related_product', array(
		'label'       => esc_html__( 'Show / Hide related product', 'fm-radio-station' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'fm_radio_station_related_product',
	) ) );

	
	//Page template settings
	$wp_customize->add_panel( 'fm_radio_station_page_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Page Template Settings', 'fm-radio-station' ),
	    'description' => __( 'Description of what this panel does.', 'fm-radio-station' ),
	) );

	// 404 PAGE
	$wp_customize->add_section('fm_radio_station_404_page_section',array(
		'title'         => __('404 Page', 'fm-radio-station'),
		'description'   => __('Here you can customize 404 Page content.', 'fm-radio-station'),
		'panel' => 'fm_radio_station_page_panel_id'
	) );

	$wp_customize->add_setting('fm_radio_station_edit_404_title',array(
		'default'=> __('Oops! That page cant be found.','fm-radio-station'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('fm_radio_station_edit_404_title',array(
		'label'	=> __('Edit Title','fm-radio-station'),
		'section'=> 'fm_radio_station_404_page_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('fm_radio_station_edit_404_text',array(
		'default'=> __('It looks like nothing was found at this location. Maybe try a search?','fm-radio-station'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_edit_404_text',array(
		'label'	=> __('Edit Text','fm-radio-station'),
		'section'=> 'fm_radio_station_404_page_section',
		'type'=> 'text'
	));

	// Search Results
	$wp_customize->add_section('fm_radio_station_no_result_section',array(
		'title'         => __('Search Results', 'fm-radio-station'),
		'description'  => __('Here you can customize Search Result content.', 'fm-radio-station'),
		'panel' => 'fm_radio_station_page_panel_id'
	) );

	$wp_customize->add_setting('fm_radio_station_edit_no_result_title',array(
		'default'=> __('Nothing Found','fm-radio-station'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('fm_radio_station_edit_no_result_title',array(
		'label'	=> __('Edit Title','fm-radio-station'),
		'section'=> 'fm_radio_station_no_result_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('fm_radio_station_edit_no_result_text',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','fm-radio-station'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fm_radio_station_edit_no_result_text',array(
		'label'	=> __('Edit Text','fm-radio-station'),
		'section'=> 'fm_radio_station_no_result_section',
		'type'=> 'text'
	));

	 // Header Image Height
    $wp_customize->add_setting(
        'fm_radio_station_header_image_height',
        array(
            'default'           => 500,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'fm_radio_station_header_image_height',
        array(
            'label'       => esc_html__( 'Header Image Height', 'fm-radio-station' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the height of the header image. Default is 350px.', 'fm-radio-station' ),
            'input_attrs' => array(
                'min'  => 220,
                'max'  => 1000,
                'step' => 1,
            ),
        )
    );

    // Header Background Position
    $wp_customize->add_setting(
        'fm_radio_station_header_background_position',
        array(
            'default'           => 'center',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'fm_radio_station_header_background_position',
        array(
            'label'       => esc_html__( 'Header Background Position', 'fm-radio-station' ),
            'section'     => 'header_image',
            'type'        => 'select',
            'choices'     => array(
                'top'    => esc_html__( 'Top', 'fm-radio-station' ),
                'center' => esc_html__( 'Center', 'fm-radio-station' ),
                'bottom' => esc_html__( 'Bottom', 'fm-radio-station' ),
            ),
            'description' => esc_html__( 'Choose how you want to position the header image.', 'fm-radio-station' ),
        )
    );

    // Header Image Parallax Effect
    $wp_customize->add_setting(
        'fm_radio_station_header_background_attachment',
        array(
            'default'           => 1,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'fm_radio_station_header_background_attachment',
        array(
            'label'       => esc_html__( 'Header Image Parallax', 'fm-radio-station' ),
            'section'     => 'header_image',
            'type'        => 'checkbox',
            'description' => esc_html__( 'Add a parallax effect on page scroll.', 'fm-radio-station' ),
        )
    );

        //Opacity
	$wp_customize->add_setting('fm_radio_station_header_banner_opacity_color',array(
       'default'              => '0.5',
       'sanitize_callback' => 'fm_radio_station_sanitize_choices'
	));
    $wp_customize->add_control( 'fm_radio_station_header_banner_opacity_color', array(
		'label'       => esc_html__( 'Header Image Opacity','fm-radio-station' ),
		'section'     => 'header_image',
		'type'        => 'select',
		'settings'    => 'fm_radio_station_header_banner_opacity_color',
		'choices' => array(
           '0' =>  esc_attr(__('0','fm-radio-station')),
           '0.1' =>  esc_attr(__('0.1','fm-radio-station')),
           '0.2' =>  esc_attr(__('0.2','fm-radio-station')),
           '0.3' =>  esc_attr(__('0.3','fm-radio-station')),
           '0.4' =>  esc_attr(__('0.4','fm-radio-station')),
           '0.5' =>  esc_attr(__('0.5','fm-radio-station')),
           '0.6' =>  esc_attr(__('0.6','fm-radio-station')),
           '0.7' =>  esc_attr(__('0.7','fm-radio-station')),
           '0.8' =>  esc_attr(__('0.8','fm-radio-station')),
           '0.9' =>  esc_attr(__('0.9','fm-radio-station'))
		), 
	) );

   $wp_customize->add_setting( 'fm_radio_station_header_banner_image_overlay', array(
	    'default'   => true,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'fm_radio_station_sanitize_checkbox',
	));
	$wp_customize->add_control( new Fm_Radio_Station_Toggle_Control( $wp_customize, 'fm_radio_station_header_banner_image_overlay', array(
	    'label'   => esc_html__( 'Show / Hide Header Image Overlay', 'fm-radio-station' ),
	    'section' => 'header_image',
	)));

    $wp_customize->add_setting('fm_radio_station_header_banner_image_ooverlay_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fm_radio_station_header_banner_image_ooverlay_color', array(
		'label'    => __('Header Image Overlay Color', 'fm-radio-station'),
		'section'  => 'header_image',
	)));

    $wp_customize->add_setting(
        'fm_radio_station_header_image_title_font_size',
        array(
            'default'           => 40,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'fm_radio_station_header_image_title_font_size',
        array(
            'label'       => esc_html__( 'Change Header Image Title Font Size', 'fm-radio-station' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the font Size of the header image title. Default is 40px.', 'fm-radio-station' ),
            'input_attrs' => array(
                'min'  => 10,
                'max'  => 200,
                'step' => 1,
            ),
        )
    );

	$wp_customize->add_setting( 'fm_radio_station_header_image_title_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fm_radio_station_header_image_title_text_color', array(
			'label'     => __('Change Header Image Title Color', 'fm-radio-station'),
	    'section' => 'header_image',
	    'settings' => 'fm_radio_station_header_image_title_text_color',
  	)));

}
add_action( 'customize_register', 'fm_radio_station_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @since FM Radio Station 1.0
 * @see fm_radio_station_customize_register()
 *
 * @return void
 */
function fm_radio_station_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since FM Radio Station 1.0
 * @see fm_radio_station_customize_register()
 *
 * @return void
 */
function fm_radio_station_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if ( ! defined( 'FM_RADIO_STATION_PRO_THEME_NAME' ) ) {
	define( 'FM_RADIO_STATION_PRO_THEME_NAME', esc_html__( 'FM Radio Station Pro', 'fm-radio-station'));
}
if ( ! defined( 'FM_RADIO_STATION_PRO_THEME_URL' ) ) {
	define( 'FM_RADIO_STATION_PRO_THEME_URL', esc_url('https://www.themespride.com/products/radio-station-wordpress-theme', 'fm-radio-station'));
}

if ( ! defined( 'FM_RADIO_STATION_DOCS_URL' ) ) {
	define( 'FM_RADIO_STATION_DOCS_URL', esc_url('https://page.themespride.com/demo/docs/fm-radio-station-free/'));
}
if ( ! defined( 'FM_RADIO_STATION_TEXT' ) ) {
    define( 'FM_RADIO_STATION_TEXT', __( 'FM Radio Station Pro','fm-radio-station' ));
}
if ( ! defined( 'FM_RADIO_STATION_BUY_TEXT' ) ) {
    define( 'FM_RADIO_STATION_BUY_TEXT', __( 'Upgrade Pro','fm-radio-station' ));
}

add_action( 'customize_register', function( $manager ) {

// Load custom sections.
load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

    $manager->register_section_type( fm_radio_station_Button::class );

    $manager->add_section(
        new fm_radio_station_Button( $manager, 'fm_radio_station_pro', [
            'title'       => esc_html( FM_RADIO_STATION_TEXT,'fm-radio-station' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'fm-radio-station' ),
            'button_url'  => esc_url( FM_RADIO_STATION_PRO_THEME_URL )
        ] )
    );

    // Register sections.
	$manager->add_section(
		new fm_radio_station_Customize_Section_Pro(
			$manager,
			'fm_radio_station_documentation',
			array(
				'priority'   => 500,
				'title'    => esc_html__( 'Theme Documentation', 'fm-radio-station' ),
				'pro_text' => esc_html__( 'Click Here', 'fm-radio-station' ),
				'pro_url'  => esc_url( FM_RADIO_STATION_DOCS_URL, 'fm-radio-station'),
			)
		)
	);

} );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Fm_Radio_Station_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Fm_Radio_Station_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Fm_Radio_Station_Customize_Section_Pro(
				$manager,
				'fm_radio_station_section_pro',
				array(
					'priority'   => 9,
					'title'    => FM_RADIO_STATION_PRO_THEME_NAME,
					'pro_text' => esc_html__( 'Upgrade Pro', 'fm-radio-station' ),
					'pro_url'  => esc_url( FM_RADIO_STATION_PRO_THEME_URL, 'fm-radio-station' ),
				)
			)
		);

	}
	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'fm-radio-station-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'fm-radio-station-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Fm_Radio_Station_Customize::get_instance();