<?php
/**
 * Custom header implementation
 *
 * @link https://codex.wordpress.org/Custom_Headers
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

function fm_radio_station_custom_header_setup() {
    register_default_headers( array(
        'default-image' => array(
            'url'           => get_template_directory_uri() . '/assets/images/sliderimage.png',
            'thumbnail_url' => get_template_directory_uri() . '/assets/images/sliderimage.png',
            'description'   => __( 'Default Header Image', 'fm-radio-station' ),
        ),
    ) );
}
add_action( 'after_setup_theme', 'fm_radio_station_custom_header_setup' );

/**
 * Styles the header image based on Customizer settings.
 */
function fm_radio_station_header_style() {
    $fm_radio_station_header_image = get_header_image() ? get_header_image() : get_template_directory_uri() . '/assets/images/sliderimage.png';

    $fm_radio_station_height     = get_theme_mod( 'fm_radio_station_header_image_height', 350 );
    $fm_radio_station_position   = get_theme_mod( 'fm_radio_station_header_background_position', 'center' );
    $fm_radio_station_attachment = get_theme_mod( 'fm_radio_station_header_background_attachment', 1 ) ? 'fixed' : 'scroll';

    $fm_radio_station_custom_css = "
        .header-img, .single-page-img, .external-div .box-image img, .external-div {
            background-image: url('" . esc_url( $fm_radio_station_header_image ) . "');
            background-size: cover;
            height: " . esc_attr( $fm_radio_station_height ) . "px;
            background-position: " . esc_attr( $fm_radio_station_position ) . ";
            background-attachment: " . esc_attr( $fm_radio_station_attachment ) . ";
        }
        @media (max-width: 1000px) {
            .header-img, .single-page-img, .external-div .box-image-page img,.external-div,.featured-image{
                height: 250px !important;
            }
            .box-text h2{
                font-size: 27px;
            }
        }
    ";

    wp_add_inline_style( 'fm-radio-station-style', $fm_radio_station_custom_css );
}
add_action( 'wp_enqueue_scripts', 'fm_radio_station_header_style' );

/**
 * Enqueue the main theme stylesheet.
 */
function fm_radio_station_enqueue_styles() {
    wp_enqueue_style( 'fm-radio-station-style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'fm_radio_station_enqueue_styles' );