<?php
/**
 * FM Radio Station functions and definitions
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

function fm_radio_station_setup() {

	load_theme_textdomain( 'fm-radio-station', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'title-tag' );
	add_theme_support( "responsive-embeds" );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'fm-radio-station-featured-image', 2000, 1200, true );
	add_image_size( 'fm-radio-station-thumbnail-avatar', 100, 100, true );

	// Set the default content width.
	$GLOBALS['content_width'] = 525;

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'primary-menu'    => __( 'Primary Menu', 'fm-radio-station' ),
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'       => 250,
		'height'      => 250,
		'flex-width'  => true,
    	'flex-height' => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );

	/*
	 * Enable support for Post Formats.
	 *
	 * See: https://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

	add_theme_support( 'html5', array('comment-form','comment-list','gallery','caption',) );

	add_theme_support( 'custom-header', apply_filters( 'fm_radio_station_custom_header_args', array(
        'default-text-color' => 'fff',
        'header-text'        => false,
        'width'              => 1600,
        'height'             => 400,
        'flex-width'         => true,
        'flex-height'        => true,
        'wp-head-callback'   => 'fm_radio_station_header_style',
        'default-image'      => get_template_directory_uri() . '/assets/images/sliderimage.png',
    ) ) );

	/**
	 * Implement the Custom Header feature.
	 */
	require get_parent_theme_file_path( '/inc/custom-header.php' );

}
add_action( 'after_setup_theme', 'fm_radio_station_setup' );

// Add function after setup:
function fm_radio_station_conditional_editor_styles() {
    if ( is_admin() && ( wp_doing_ajax() || isset( $_GET['page'] ) && $_GET['page'] === 'widgets.php' ) ) {
        return;
    }
	add_editor_style( array( 'assets/css/editor-style.css', fm_radio_station_fonts_url() ) );
}
add_action( 'after_setup_theme', 'fm_radio_station_conditional_editor_styles', 11 );

/**
 * Register custom fonts.
 */
function fm_radio_station_fonts_url(){
	$fm_radio_station_font_url = '';
	$fm_radio_station_font_family = array();
	$fm_radio_station_font_family[] = 'Gochi Hand';
	$fm_radio_station_font_family[] = 'Outfit:wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Satisfy';
	$fm_radio_station_font_family[] = 'League Spartan:wght@100..900';
	$fm_radio_station_font_family[] = 'Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900';
	$fm_radio_station_font_family[] = 'Manrope:wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Oxanium:wght@200;300;400;500;600;700;800';
	$fm_radio_station_font_family[] = 'Oswald:200,300,400,500,600,700';
	$fm_radio_station_font_family[] = 'Roboto Serif:wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Bad Script';
	$fm_radio_station_font_family[] = 'Bebas Neue';
	$fm_radio_station_font_family[] = 'Fjalla One';
	$fm_radio_station_font_family[] = 'PT Sans:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'PT Serif:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900';
	$fm_radio_station_font_family[] = 'Roboto Condensed:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700';
	$fm_radio_station_font_family[] = 'Roboto+Flex:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Alex Brush';
	$fm_radio_station_font_family[] = 'Overpass:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Playball';
	$fm_radio_station_font_family[] = 'Alegreya:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Julius Sans One';
	$fm_radio_station_font_family[] = 'Arsenal:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Slabo 13px';
	$fm_radio_station_font_family[] = 'Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900';
	$fm_radio_station_font_family[] = 'Overpass Mono:wght@300;400;500;600;700';
	$fm_radio_station_font_family[] = 'Source Sans Pro:ital,wght@0,200;0,300;0,400;0,600;0,700;0,900;1,200;1,300;1,400;1,600;1,700;1,900';
	$fm_radio_station_font_family[] = 'Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Merriweather:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900';
	$fm_radio_station_font_family[] = 'Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Lora:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700';
	$fm_radio_station_font_family[] = 'Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700';
	$fm_radio_station_font_family[] = 'Cabin:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700';
	$fm_radio_station_font_family[] = 'Arimo:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700';
	$fm_radio_station_font_family[] = 'Playfair Display:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Quicksand:wght@300;400;500;600;700';
	$fm_radio_station_font_family[] = 'Padauk:wght@400;700';
	$fm_radio_station_font_family[] = 'Mulish:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;0,1000;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900;1,1000';
	$fm_radio_station_font_family[] = 'Inconsolata:wght@200;300;400;500;600;700;800;900&family=Mulish:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;0,1000;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900;1,1000';
	$fm_radio_station_font_family[] = 'Bitter:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Mulish:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;0,1000;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900;1,1000';
	$fm_radio_station_font_family[] = 'Pacifico';
	$fm_radio_station_font_family[] = 'Indie Flower';
	$fm_radio_station_font_family[] = 'VT323';
	$fm_radio_station_font_family[] = 'Dosis:wght@200;300;400;500;600;700;800';
	$fm_radio_station_font_family[] = 'Frank Ruhl Libre:wght@300;400;500;700;900';
	$fm_radio_station_font_family[] = 'Fjalla One';
	$fm_radio_station_font_family[] = 'Figtree:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Oxygen:wght@300;400;700';
	$fm_radio_station_font_family[] = 'Arvo:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Noto Serif:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Lobster';
	$fm_radio_station_font_family[] = 'Crimson Text:ital,wght@0,400;0,600;0,700;1,400;1,600;1,700';
	$fm_radio_station_font_family[] = 'Yanone Kaffeesatz:wght@200;300;400;500;600;700';
	$fm_radio_station_font_family[] = 'Anton';
	$fm_radio_station_font_family[] = 'Libre Baskerville:ital,wght@0,400;0,700;1,400';
	$fm_radio_station_font_family[] = 'Bree Serif';
	$fm_radio_station_font_family[] = 'Gloria Hallelujah';
	$fm_radio_station_font_family[] = 'Abril Fatface';
	$fm_radio_station_font_family[] = 'Varela Round';
	$fm_radio_station_font_family[] = 'Vampiro One';
	$fm_radio_station_font_family[] = 'Shadows Into Light';
	$fm_radio_station_font_family[] = 'Cuprum:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700';
	$fm_radio_station_font_family[] = 'Rokkitt:wght@100;200;300;400;500;600;700;800;900';
	$fm_radio_station_font_family[] = 'Vollkorn:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Francois One';
	$fm_radio_station_font_family[] = 'Orbitron:wght@400;500;600;700;800;900';
	$fm_radio_station_font_family[] = 'Patua One';
	$fm_radio_station_font_family[] = 'Acme';
	$fm_radio_station_font_family[] = 'Satisfy';
	$fm_radio_station_font_family[] = 'Josefin Slab:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700';
	$fm_radio_station_font_family[] = 'Quattrocento Sans:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Architects Daughter';
	$fm_radio_station_font_family[] = 'Russo One';
	$fm_radio_station_font_family[] = 'Monda:wght@400;700';
	$fm_radio_station_font_family[] = 'Righteous';
	$fm_radio_station_font_family[] = 'Lobster Two:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Hammersmith One';
	$fm_radio_station_font_family[] = 'Courgette';
	$fm_radio_station_font_family[] = 'Permanent Marke';
	$fm_radio_station_font_family[] = 'Cherry Swash:wght@400;700';
	$fm_radio_station_font_family[] = 'Cormorant Garamond:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700';
	$fm_radio_station_font_family[] = 'Poiret One';
	$fm_radio_station_font_family[] = 'BenchNine:wght@300;400;700';
	$fm_radio_station_font_family[] = 'Economica:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Handlee';
	$fm_radio_station_font_family[] = 'Cardo:ital,wght@0,400;0,700;1,400';
	$fm_radio_station_font_family[] = 'Alfa Slab One';
	$fm_radio_station_font_family[] = 'Averia Serif Libre:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700';
	$fm_radio_station_font_family[] = 'Cookie';
	$fm_radio_station_font_family[] = 'Chewy';
	$fm_radio_station_font_family[] = 'Great Vibes';
	$fm_radio_station_font_family[] = 'Coming Soon';
	$fm_radio_station_font_family[] = 'Philosopher:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Days One';
	$fm_radio_station_font_family[] = 'Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Shrikhand';
	$fm_radio_station_font_family[] = 'Tangerine:wght@400;700';
	$fm_radio_station_font_family[] = 'IM Fell English SC';
	$fm_radio_station_font_family[] = 'Boogaloo';
	$fm_radio_station_font_family[] = 'Bangers';
	$fm_radio_station_font_family[] = 'Fredoka One';
	$fm_radio_station_font_family[] = 'Volkhov:ital,wght@0,400;0,700;1,400;1,700';
	$fm_radio_station_font_family[] = 'Shadows Into Light Two';
	$fm_radio_station_font_family[] = 'Marck Script';
	$fm_radio_station_font_family[] = 'Sacramento';
	$fm_radio_station_font_family[] = 'Unica One';
	$fm_radio_station_font_family[] = 'Dancing Script:wght@400;500;600;700';
	$fm_radio_station_font_family[] = 'Exo 2:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Archivo:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'Jost:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	$fm_radio_station_font_family[] = 'DM Serif Display:ital@0;1';
	$fm_radio_station_font_family[] = 'Open Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800';
	$fm_radio_station_font_family[] = 'Karla:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,200;1,300;1,400;1,500;1,600;1,700;1,800';

	$fm_radio_station_query_args = array(
		'family'	=> rawurlencode(implode('|',$fm_radio_station_font_family)),
	);
	$fm_radio_station_font_url = add_query_arg($fm_radio_station_query_args,'//fonts.googleapis.com/css');
	return $fm_radio_station_font_url;
	$contents = wptt_get_webfont_url( esc_url_raw( $fm_radio_station_font_url ) );
}

/**
 * Register widget area.
 */
function fm_radio_station_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'fm-radio-station' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'fm-radio-station' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'fm-radio-station' ),
		'id'            => 'sidebar-2',
		'description'   => __( 'Add widgets here to appear in your sidebar on pages.', 'fm-radio-station' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 3', 'fm-radio-station' ),
		'id'            => 'sidebar-3',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'fm-radio-station' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 1', 'fm-radio-station' ),
		'id'            => 'footer-1',
		'description'   => __( 'Add widgets here to appear in your footer.', 'fm-radio-station' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 2', 'fm-radio-station' ),
		'id'            => 'footer-2',
		'description'   => __( 'Add widgets here to appear in your footer.', 'fm-radio-station' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 3', 'fm-radio-station' ),
		'id'            => 'footer-3',
		'description'   => __( 'Add widgets here to appear in your footer.', 'fm-radio-station' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 4', 'fm-radio-station' ),
		'id'            => 'footer-4',
		'description'   => __( 'Add widgets here to appear in your footer.', 'fm-radio-station' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'fm_radio_station_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function fm_radio_station_scripts() {

	// Add custom fonts, used in the main stylesheet.
	wp_enqueue_style( 'fm-radio-station-fonts', fm_radio_station_fonts_url(), array(), null );

	// Owl Carousel.
	wp_enqueue_style( 'owl-carousel-css', get_theme_file_uri( '/assets/css/owl.carousel.css' ) );

	// Bootstrap.
	wp_enqueue_style( 'bootstrap-css', get_theme_file_uri( '/assets/css/bootstrap.css' ) );

	// Theme stylesheet.
	wp_enqueue_style( 'fm-radio-station-style', get_stylesheet_uri() );
	wp_style_add_data( 'fm-radio-station-style', 'rtl', 'replace' );

	/* ---------- THEME COLOR CSS (INLINE) ---------- */
	$fm_radio_station_tp_theme_css = '';
	if ( file_exists( get_parent_theme_file_path( '/tp-theme-color.php' ) ) ) {
		require get_parent_theme_file_path( '/tp-theme-color.php' );
	}
	if ( ! empty( $fm_radio_station_tp_theme_css ) ) {
		wp_add_inline_style( 'fm-radio-station-style', $fm_radio_station_tp_theme_css );
	}

	/* ---------- BODY WIDTH / LAYOUT CSS (INLINE) ---------- */
	$fm_radio_station_tp_layout_css = '';
	if ( file_exists( get_parent_theme_file_path( '/tp-body-width-layout.php' ) ) ) {
		require get_parent_theme_file_path( '/tp-body-width-layout.php' );
	}
	if ( ! empty( $fm_radio_station_tp_layout_css ) ) {
		wp_add_inline_style( 'fm-radio-station-style', $fm_radio_station_tp_layout_css );
	}

	// Theme block stylesheet.
	wp_enqueue_style(
		'fm-radio-station-block-style',
		get_theme_file_uri( '/assets/css/blocks.css' ),
		array( 'fm-radio-station-style' ),
		'1.0'
	);

	// Font Awesome.
	wp_enqueue_style( 'fontawesome-css', get_theme_file_uri( '/assets/css/fontawesome-all.css' ) );

	// Scripts.
	wp_enqueue_script(
		'fm-radio-station-custom-scripts',
		get_template_directory_uri() . '/assets/js/fm-radio-station-custom.js',
		array( 'jquery' ),
		null,
		true
	);

	wp_enqueue_script(
		'bootstrap-js',
		get_theme_file_uri( '/assets/js/bootstrap.js' ),
		array( 'jquery' ),
		null,
		true
	);

	wp_enqueue_script(
		'owl-carousel-js',
		get_theme_file_uri( '/assets/js/owl.carousel.js' ),
		array( 'jquery' ),
		null,
		true
	);

	wp_enqueue_script(
		'fm-radio-station-focus-nav',
		get_template_directory_uri() . '/assets/js/focus-nav.js',
		array( 'jquery' ),
		null,
		true
	);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	/* ---------- DYNAMIC TYPOGRAPHY CSS (INLINE) ---------- */
	$fm_radio_station_body_font_family    = get_theme_mod( 'fm_radio_station_body_font_family', '' );
	$fm_radio_station_heading_font_family = get_theme_mod( 'fm_radio_station_heading_font_family', '' );

	$fm_radio_station_dynamic_typography_css = '
		body, p.simplep, .more-btn a {
			font-family: ' . esc_html( $fm_radio_station_body_font_family ) . ';
		}
		h1, h2, h3, h4, h5, h6, .menubar, .logo h1, .logo p.site-title, p.simplep a,
		#main-slider p.slidertop-title, .more-btn a,
		.wc-block-checkout__actions_row .wc-block-components-checkout-place-order-button,
		.wc-block-cart__submit-container a,
		.woocommerce #respond input#submit,
		.woocommerce a.button,
		.woocommerce button.button,
		.woocommerce input.button,
		.woocommerce #respond input#submit.alt,
		.woocommerce a.button.alt,
		.woocommerce button.button.alt,
		.woocommerce input.button.alt,
		#theme-sidebar button[type="submit"],
		#footer button[type="submit"] {
			font-family: ' . esc_html( $fm_radio_station_heading_font_family ) . ';
		}
	';

	if ( ! empty( trim( $fm_radio_station_dynamic_typography_css ) ) ) {
		wp_add_inline_style( 'fm-radio-station-style', $fm_radio_station_dynamic_typography_css );
	}
}
add_action( 'wp_enqueue_scripts', 'fm_radio_station_scripts' );


/*radio button sanitization*/
function fm_radio_station_sanitize_choices( $input, $setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $setting->id );
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

// Sanitize Sortable control.
function fm_radio_station_sanitize_sortable( $val, $setting ) {
	if ( is_string( $val ) || is_numeric( $val ) ) {
		return array(
			esc_attr( $val ),
		);
	}
	$sanitized_value = array();
	foreach ( $val as $item ) {
		if ( isset( $setting->manager->get_control( $setting->id )->choices[ $item ] ) ) {
			$sanitized_value[] = esc_attr( $item );
		}
	}
	return $sanitized_value;
}
/* Excerpt Limit Begin */
function fm_radio_station_excerpt_function($excerpt_count = 35) {
    $fm_radio_station_excerpt = get_the_excerpt();

    $FM_RADIO_STATION_TEXT_excerpt = wp_strip_all_tags($fm_radio_station_excerpt);

    $fm_radio_station_excerpt_limit = esc_attr(get_theme_mod('fm_radio_station_excerpt_count', $excerpt_count));

    $fm_radio_station_theme_excerpt = implode(' ', array_slice(explode(' ', $FM_RADIO_STATION_TEXT_excerpt), 0, $fm_radio_station_excerpt_limit));

    return $fm_radio_station_theme_excerpt;
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'fm_radio_station_loop_columns');
if (!function_exists('fm_radio_station_loop_columns')) {
	function fm_radio_station_loop_columns() {
		$columns = get_theme_mod( 'fm_radio_station_per_columns', 3 );
		return $columns;
	}
}

function fm_radio_station_sanitize_dropdown_pages( $page_id, $setting ) {
  // Ensure $input is an absolute integer.
  $page_id = absint( $page_id );
  // If $page_id is an ID of a published page, return it; otherwise, return the default.
  return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

// Category count 
function fm_radio_station_display_post_category_count() {
    $fm_radio_station_category = get_the_category();
    $fm_radio_station_category_count = ($fm_radio_station_category) ? count($fm_radio_station_category) : 0;
    $fm_radio_station_category_text = ($fm_radio_station_category_count === 1) ? 'category' : 'categories'; // Check for pluralization
    echo $fm_radio_station_category_count . ' ' . $fm_radio_station_category_text;
}

//post tag
function fm_radio_station_custom_tags_filter($fm_radio_station_tag_list) {
    // Replace the comma (,) with an empty string
    $fm_radio_station_tag_list = str_replace(', ', '', $fm_radio_station_tag_list);

    return $fm_radio_station_tag_list;
}
add_filter('the_tags', 'fm_radio_station_custom_tags_filter');

function fm_radio_station_custom_output_tags() {
    $fm_radio_station_tags = get_the_tags();

    if ($fm_radio_station_tags) {
        $fm_radio_station_tags_output = '<div class="post_tag">Tags: ';

        $fm_radio_station_first_tag = reset($fm_radio_station_tags);

        foreach ($fm_radio_station_tags as $tag) {
            $fm_radio_station_tags_output .= '<a href="' . esc_url(get_tag_link($tag)) . '" rel="tag" class="me-2">' . esc_html($tag->name) . '</a>';
            if ($tag !== $fm_radio_station_first_tag) {
                $fm_radio_station_tags_output .= ' ';
            }
        }

        $fm_radio_station_tags_output .= '</div>';

        echo $fm_radio_station_tags_output;
    }
}
//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'fm_radio_station_per_page', 20 );
function fm_radio_station_per_page( $fm_radio_station_cols ) {
  	$fm_radio_station_cols = get_theme_mod( 'fm_radio_station_product_per_page', 9 );
	return $fm_radio_station_cols;
}

function fm_radio_station_sanitize_number_range( $number, $setting ) {

	// Ensure input is an absolute integer.
	$number = absint( $number );

	// Get the input attributes associated with the setting.
	$atts = $setting->manager->get_control( $setting->id )->input_attrs;

	// Get minimum number in the range.
	$min = ( isset( $atts['min'] ) ? $atts['min'] : $number );

	// Get maximum number in the range.
	$max = ( isset( $atts['max'] ) ? $atts['max'] : $number );

	// Get step.
	$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );

	// If the number is within the valid range, return it; otherwise, return the default
	return ( $min <= $number && $number <= $max && is_int( $number / $step ) ? $number : $setting->default );
}
function fm_radio_station_string_limit_words($string, $word_limit) {
    $string = wp_strip_all_tags($string); // Remove HTML tags
    $words = explode(' ', $string);
    if (count($words) > $word_limit) {
        return implode(' ', array_slice($words, 0, $word_limit)) . '...';
    }
    return implode(' ', $words);
}

function fm_radio_station_sanitize_checkbox( $input ) {
	// Boolean check
	return ( ( isset( $input ) && true == $input ) ? true : false );
}

function fm_radio_station_sanitize_number_absint( $number, $setting ) {
	// Ensure $number is an absolute integer (whole number, zero or greater).
	$number = absint( $number );

	// If the input is an absolute integer, return it; otherwise, return the default
	return ( $number ? $number : $setting->default );
}

/**
 * Use front-page.php when Front page displays is set to a static page.
 */
function fm_radio_station_front_page_template( $template ) {
	return is_home() ? '' : $template;
}
add_filter( 'frontpage_template','fm_radio_station_front_page_template' );

// logo
function fm_radio_station_logo_width(){

	$fm_radio_station_logo_width   = get_theme_mod( 'fm_radio_station_logo_width', 80 );

	echo "<style type='text/css' media='all'>"; ?>
		img.custom-logo{
		    width: <?php echo absint( $fm_radio_station_logo_width ); ?>px;
		    max-width: 100%;
		}
	<?php echo "</style>";
}

add_action( 'wp_head', 'fm_radio_station_logo_width' );

function fm_radio_station_theme_setup() {

	define('FM_RADIO_STATION_CREDIT',__('https://www.themespride.com/products/fm-radio-station','fm-radio-station') );
	if ( ! function_exists( 'fm_radio_station_credit' ) ) {
		function fm_radio_station_credit(){
			echo "<a href=".esc_url(FM_RADIO_STATION_CREDIT)." target='_blank'>".esc_html__(get_theme_mod('fm_radio_station_footer_text',__('FM Radio Station WordPress Theme','fm-radio-station')))."</a>";
		}
	}

	/**
	 * Custom template tags for this theme.
	 */
	require get_parent_theme_file_path( '/inc/template-tags.php' );

	/**
	 * Additional features to allow styling of the templates.
	 */
	require get_parent_theme_file_path( '/inc/template-functions.php' );

	/**
	 * Customizer additions.
	 */
	require get_parent_theme_file_path( '/inc/customizer.php' );

	/**
	 * Load Theme Web File
	 */
	require get_parent_theme_file_path('/inc/wptt-webfont-loader.php' );
	/**
	 * Load Theme Web File
	 */
	require get_parent_theme_file_path( '/inc/controls/customize-control-toggle.php' );
	/**
	 * load sortable file
	 */
	require get_parent_theme_file_path( '/inc/controls/sortable-control.php' );

	/**
	 * About Theme Page
	 */
	require get_parent_theme_file_path( '/inc/about-theme.php' );

	/**
	 * TGM Recommendation
	 */
	require get_parent_theme_file_path( '/inc/TGM/tgm.php' );

}
add_action( 'after_setup_theme', 'fm_radio_station_theme_setup' );


//Admin Enqueue for Admin
function fm_radio_station_admin_enqueue_scripts(){
	wp_enqueue_style('fm-radio-station-admin-style', get_template_directory_uri() . '/assets/css/admin.css');
	wp_register_script( 'fm-radio-station-admin-script', get_template_directory_uri() . '/assets/js/fm-radio-station-admin.js', array( 'jquery' ), '', true );

	wp_localize_script(
		'fm-radio-station-admin-script',
		'fm_radio_station',
		array(
			'admin_ajax'	=>	admin_url('admin-ajax.php'),
			'wpnonce'			=>	wp_create_nonce('fm_radio_station_dismissed_notice_nonce')
		)
	);
	wp_enqueue_script('fm-radio-station-admin-script');

    wp_localize_script( 'fm-radio-station-admin-script', 'fm_radio_station_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'fm_radio_station_admin_enqueue_scripts' );


// get started
add_action( 'wp_ajax_fm_radio_station_dismissed_notice_handler', 'fm_radio_station_ajax_notice_handler' );

function fm_radio_station_ajax_notice_handler() {
	if (!wp_verify_nonce($_POST['wpnonce'], 'fm_radio_station_dismissed_notice_nonce')) {
		exit;
	}
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function fm_radio_station_activation_notice() { 

	if ( ! get_option('dismissed-get_started', FALSE ) ) { ?>

    <div class="fm-radio-station-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
        <div class="fm-radio-station-getting-started-notice clearfix">
        	<div class="row-top">
	            <div class="fm-radio-station-theme-notice-content">
	                <h2 class="fm-radio-station-notice-h2">
	                    <?php
	                printf(
	                /* translators: 1: welcome page link starting html tag, 2: welcome page link ending html tag. */
	                    esc_html__( 'Install the Demo Import Plugin now to instantly set up your site like the live preview.', 'fm-radio-station' ), '<strong>'. wp_get_theme()->get('Name'). '</strong>' );
	                ?>
	                </h2>
	                <a class="fm-radio-station-btn-get-started button button-primary button-hero fm-radio-station-button-padding" href="<?php echo esc_url( admin_url( 'themes.php?page=fm-radio-station-about' )); ?>" ><?php esc_html_e( 'Get Started with FM Radio Station', 'fm-radio-station' ) ?></a>
	            </div>
	            <div class="image-box">
			    	<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/theme-notice.png' ); ?>" alt="<?php echo esc_attr__( 'FM Radio Station', 'fm-radio-station' ); ?>" />
				</div>
	        </div>
        </div>
    </div>
<?php }

}
add_action( 'admin_notices', 'fm_radio_station_activation_notice' );

add_action('after_switch_theme', 'fm_radio_station_setup_options');
function fm_radio_station_setup_options () {
    update_option('dismissed-get_started', FALSE );
}