<?php
/**
 * The template for displaying comments
 *
 * @package FM Radio Station
 * @subpackage fm_radio_station
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) : ?>
		<h2 class="comments-title">
			<?php
			$fm_radio_station_comments_number = get_comments_number();

			if ( '1' === $fm_radio_station_comments_number ) {
				/* translators: %s: Post title. */
				printf(
					esc_html__( 'One Reply to &ldquo;%s&rdquo;', 'fm-radio-station' ),
					'<span>' . esc_html( get_the_title() ) . '</span>'
				);
			} else {
				/* translators: 1: Number of comments, 2: Post title. */
				printf(
					esc_html(
						_nx(
							'%1$s Reply to &ldquo;%2$s&rdquo;',
							'%1$s Replies to &ldquo;%2$s&rdquo;',
							$fm_radio_station_comments_number,
							'comments title',
							'fm-radio-station'
						)
					),
					number_format_i18n( $fm_radio_station_comments_number ),
					'<span>' . esc_html( get_the_title() ) . '</span>'
				);
			}
			?>
		</h2>
		<ol class="comment-list">
			<?php
				wp_list_comments( array(
					'avatar_size' => 100,
					'style'       => 'ol',
					'short_ping'  => true,
				) );
			?>
		</ol>

		<?php the_comments_pagination( array(
			'prev_text' => '<span class="screen-reader-text">' . esc_html__( 'Previous', 'fm-radio-station' ) . '</span>',
			'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next', 'fm-radio-station' ) . '</span>',
		) ); ?>

	<?php endif; // Check for have_comments(). ?>

	<?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'fm-radio-station' ); ?></p>
	<?php endif; ?>

	<?php comment_form(); ?>

</div><!-- #comments -->