( function( window, document ) {
  function fm_radio_station_keepFocusInMenu() {
    document.addEventListener( 'keydown', function( e ) {
      const fm_radio_station_nav = document.querySelector( '.sidenav' );
      if ( ! fm_radio_station_nav || ! fm_radio_station_nav.classList.contains( 'open' ) ) {
        return;
      }
      const elements = [...fm_radio_station_nav.querySelectorAll( 'input, a, button' )],
        fm_radio_station_lastEl = elements[ elements.length - 1 ],
        fm_radio_station_firstEl = elements[0],
        fm_radio_station_activeEl = document.activeElement,
        tabKey = e.keyCode === 9,
        shiftKey = e.shiftKey;
      if ( ! shiftKey && tabKey && fm_radio_station_lastEl === fm_radio_station_activeEl ) {
        e.preventDefault();
        fm_radio_station_firstEl.focus();
      }
      if ( shiftKey && tabKey && fm_radio_station_firstEl === fm_radio_station_activeEl ) {
        e.preventDefault();
        fm_radio_station_lastEl.focus();
      }
    } );
  }
  fm_radio_station_keepFocusInMenu();
} )( window, document );