jQuery(function($) {
    "use strict";

    // Scroll to top functionality
    $(window).on('scroll', function() {
        if ($(this).scrollTop() >= 50) {
            $('#return-to-top').fadeIn(200);
        } else {
            $('#return-to-top').fadeOut(200);
        }
    });

    $('#return-to-top').on('click', function() {
        $('body,html').animate({ scrollTop: 0 }, 500);
    });

    // Side navigation toggle
    $('.gb_toggle').on('click', function() {
        fm_radio_station_Keyboard_loop($('.side_gb_nav'));
    });

    // Preloader fade out
    setTimeout(function() {
        $(".loader").fadeOut("slow");
    }, 1000);

});

// Mobile responsive menu
function fm_radio_station_menu_open_nav() {
    jQuery(".sidenav").addClass('open');
}

function fm_radio_station_menu_close_nav() {
    jQuery(".sidenav").removeClass('open');
}

// audio track
document.addEventListener('DOMContentLoaded', function () {
  const aiProgress = document.querySelector('.ai-track-progress');   // from screenshot
  const dot        = document.querySelector('.tp-dot-main');
  const line       = document.querySelector('.track-progress-left');

  if (!aiProgress || !dot || !line) return;

  // Poll periodically because AudioIgniter updates inline style
  setInterval(function () {
    const w = aiProgress.style.width; // e.g. "16.6814%"

    if (!w) return;

    const percent = parseFloat(w);    // 0–100
    const width   = line.clientWidth;
    const x       = (percent / 100) * width;

    dot.style.left = x + 'px';
  }, 100); // every 100ms
});

// second sec
jQuery(document).ready(function($) {
  // Initialize Owl Carousel
  $(".radio-carousel").owlCarousel({
    loop: false,                    // Loop infinitely
    margin: 20,                    // Space between items
    nav: true,                     // Show next/prev buttons
    dots: false,                    // Show dot indicators
    autoplay: false,                // Auto-play carousel
    autoplayTimeout: 5000,         // 5 seconds per slide
    autoplayHoverPause: true,      // Pause on hover
    responsive: {
      0: {
        items: 1                   // Mobile: 1 item
      },
      600: {
        items: 2                   // Tablet: 2 items
      },
      1000: {
        items: 3                   // Desktop: 3 items
      }
    },
    navText: ['<i class="fa fa-chevron-left"></i>', '<i class="fa fa-chevron-right"></i>'],
    autoHeight: false
  });
});

// music paused
document.addEventListener('DOMContentLoaded', function () {
  // sab play/pause buttons
  const buttons = document.querySelectorAll('.ai-audio-controls-main .ai-audio-control');

  if (!buttons.length) return;

  buttons.forEach(function (btn) {
    btn.addEventListener('click', function () {

      // jis player pe click hua
      const currentControls = btn.closest('.ai-audio-controls-main');

      // sab players ke play buttons
      const allButtons = document.querySelectorAll('.ai-audio-controls-main .ai-audio-control');

      allButtons.forEach(function (otherBtn) {
        const otherControls = otherBtn.closest('.ai-audio-controls-main');

        // current ko chhod ke baaki sab ko "pause" state me force karo
        if (otherControls !== currentControls) {
          if (otherBtn.classList.contains('ai-audio-playing')) {
            otherBtn.click();   // AudioIgniter ka hi pause toggle call karega
          }
        }
      });

    });
  });
});