<?php
	if(!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly!');
		
	if(post_password_required()){
?>
	<p class="nocomments">This post is password protected. Enter the password to view comments.</p>
<?php
	return;
	}
?>

	<div class="comment-area">
		<h3 id="comments">
			<?php comments_number('No Response', 'One Response', '% Responses');?> to &#8220;<?php the_title(); ?>&#8221;
		</h3>
		<?php if(have_comments()): ?>
		<div class="navigation">
			<div class="alignleft"><?php previous_comments_link(); ?></div>
			<div class="alignright"><?php next_comments_link(); ?></div>
		</div>
		<ol class="commentlist">
		<?php wp_list_comments(); ?>
		</ol>
		<div class="navigation">
			<div class="alignleft"><?php previous_comments_link(); ?></div>
			<div class="alignright"><?php next_comments_link(); ?></div>
		</div>
		<?php else: ?>
			<?php if('open' == $post->comment_status): ?>
				<!--no need to <p class="nocomments">No comments so far!</p>-->
			<?php else: ?>
				<p class="nocomments">Sorry! Comments are closed.</p>
			<?php endif; ?>
		<?php endif; ?>
		<?php if('open' == $post->comment_status): ?>
			<div id="respond">
				<h3 id="formtitle">
					<?php comment_form_title('Leave a Reply', 'Leave a Reply to %s'); ?>
				</h3>
				<?php if(get_option('comment_registration') && !$user_ID): ?>
					<p>You must be <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>">logged in</a> to post a comment.</p>
				<?php else: ?>
					<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
					<?php if($user_ID): ?>
						<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Log out &raquo;</a></p>
					<?php else: ?>
						<p><input type="text" id="author" name="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" /><label for="author">Name <?php if($req) echo "required"; ?></label></p>
						<p><input type="text" id="email" name="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" /><label for="email">Mail ( will not be published. ) <?php if($req) echo "required"; ?></label></p>
						<p><input type="text" id="url" name="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" /><label for="url">Website</label></p>
					<?php endif; ?>
						<p><textarea id="comment" name="comment" cols="57%" rows="10" tabindex="4"></textarea></p>
						<p><small><strong>XHTML:</strong> You can use these tags: <code><?php echo allowed_tags(); ?></code></small></p>
						<p><input type="submit" id="submit" name="submit" value="Submit Comment" tabindex="5" /><?php comment_id_fields(); ?></p>
					<?php do_action('comment_form', $post->ID); ?>
					</form>
				<?php endif; ?>
			</div>
		<?php endif; ?>
	</div>