<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.3.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<form role="search" method="get" class="woocommerce-product-search search-form form-inline" action="<?php echo esc_url( home_url( '/'  ) ); ?>">

	<div class="form-group">

		<label class="screen-reader-text sr-only" for="woocommerce-product-search-field"><?php esc_html_e( 'Search for:', 'flowershop' ); ?></label>

		<input type="search" id="woocommerce-product-search-field" class="form-control" placeholder="<?php echo esc_attr_x( 'Search products &hellip;', 'placeholder', 'flowershop' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'flowershop' ); ?>" />

		<button class="btn btn-link" type="submit" aria-label="<?php echo esc_attr_x( 'Search', 'submit button', 'flowershop' ); ?>" title="<?php echo esc_attr_x( 'Search', 'submit button', 'flowershop' ); ?>">
	      <i class="glyphicon glyphicon-search"></i>
	  </button>

	</div>



	<input type="hidden" name="post_type" value="product" />

</form>
