<?php
/**
 * Function describe for fLibrary 
 * 
 * @package flibrary
 */

/**
 * Set a constant that holds the theme's minimum supported PHP version.
 */
define( 'FLIBRARY_MIN_PHP_VERSION', '7.0' );

/**
 * Immediately after theme switch is fired we we want to check php version and
 * revert to previously active theme if version is below our minimum.
 */
add_action( 'after_switch_theme', 'flibrary_test_for_min_php' );

/**
 * Switches back to the previous theme if the minimum PHP version is not met.
 */
function flibrary_test_for_min_php() {

	// Compare versions.
	if ( version_compare( PHP_VERSION, FLIBRARY_MIN_PHP_VERSION, '<' ) ) {
		// Site doesn't meet themes min php requirements, add notice...
		add_action( 'admin_notices', 'flibrary_min_php_not_met_notice' );
		// ... and switch back to previous theme.
		switch_theme( get_option( 'theme_switched' ) );
		return false;

	};
}

if ( ! function_exists( 'wp_body_open' ) ) {
        function wp_body_open() {
                do_action( 'wp_body_open' );
        }
}

/**
 * An error notice that can be displayed if the Minimum PHP version is not met.
 */
function flibrary_min_php_not_met_notice() {
	?>
	<div class="notice notice-error is_dismissable">
		<p>
			<?php esc_html_e( 'You need to update your PHP version to run this theme.', 'flibrary' ); ?> <br />
			<?php
			printf(
				/* translators: 1 is the current PHP version string, 2 is the minmum supported php version string of the theme */
				esc_html__( 'Actual version is: %1$s, required version is: %2$s.', 'flibrary' ),
				PHP_VERSION,
				FLIBRARY_MIN_PHP_VERSION
			); // phpcs: XSS ok.
			?>
		</p>
	</div>
	<?php
}


if ( ! function_exists( 'flibrary_load_css_and_scripts' ) ) :

	function flibrary_load_css_and_scripts() {

		wp_enqueue_style( 'fstore-stylesheet', get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'flibrary-child-style', get_stylesheet_uri(), array( 'flibrary-stylesheet' ) );
	}

endif; // flibrary_load_css_and_scripts

add_action( 'wp_enqueue_scripts', 'flibrary_load_css_and_scripts' );

if ( ! class_exists( 'flibrary_Customize' ) ) :
	/**
	 * Singleton class for handling the theme's customizer integration.
	 */
	final class flibrary_Customize {

		// Returns the instance.
		public static function get_instance() {

			static $instance = null;

			if ( is_null( $instance ) ) {
				$instance = new self;
				$instance->setup_actions();
			}

			return $instance;
		}

		// Constructor method.
		private function __construct() {}

		// Sets up initial actions.
		private function setup_actions() {

			// Register panels, sections, settings, controls, and partials.
			add_action( 'customize_register', array( $this, 'sections' ) );

			// Register scripts and styles for the controls.
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
		}

		// Sets up the customizer sections.
		public function sections( $manager ) {

			// Load custom sections.

			// Register custom section types.
			$manager->register_section_type( 'flibrary_Customize_Section_Pro' );

			// Register sections.
			$manager->add_section(
				new flibrary_Customize_Section_Pro(
					$manager,
					'flibrary',
					array(
						'title'    => esc_html__( 'tLibrary', 'flibrary' ),
						'pro_text' => esc_html__( 'Upgrade', 'flibrary' ),
						'pro_url'  => esc_url( 'https://tishonator.com/product/tlibrary' )
					)
				)
			);
		}

		// Loads theme customizer CSS.
		public function enqueue_control_scripts() {

			wp_enqueue_script( 'fstore-customize-controls', trailingslashit( get_template_directory_uri() ) . 'js/customize-controls.js', array( 'customize-controls' ) );

			wp_enqueue_style( 'fstore-customize-controls', trailingslashit( get_template_directory_uri() ) . 'css/customize-controls.css' );
		}
	}
endif; // flibrary_Customize

// Doing this customizer thang!
flibrary_Customize::get_instance();

/**
 * Remove Parent theme Customize Up-Selling Section
 */
if ( ! function_exists( 'flibrary_remove_parent_theme_upsell_section' ) ) :

	function flibrary_remove_parent_theme_upsell_section( $wp_customize ) {

		// Remove Parent-Theme Upsell section
		$wp_customize->remove_section('fstore');
	}

endif; // flibrary_remove_parent_theme_upsell_section
add_action( 'customize_register', 'flibrary_remove_parent_theme_upsell_section', 100 );

/**
 * Display Header Image Content
 */
if ( ! function_exists( 'flibrary_display_header_image_content' ) ) :

	function flibrary_display_header_image_content() {

		$title = get_theme_mod( 'flibrary_header_image_title' );
		$content = get_theme_mod( 'flibrary_header_image_content' );
?>
		<div id="header-landing-section-content">
			<?php if ($title) : ?>
					<h2>
						<?php echo esc_html($title); ?>
					</h2>
			<?php endif; ?>

			<?php if ($content) : ?>
					<div class="landing-content">
						<?php echo esc_html($content); ?>
					</div>
			<?php endif; ?>
		</div>
<?php
	}

endif; // flibrary_display_header_image_content

if ( ! function_exists( 'flibrary_customize_register' ) ) :

	/**
	 * Register theme settings in the customizer
	 */
	function flibrary_customize_register( $wp_customize ) {

		// Add Header Image Section Title
		$wp_customize->add_setting(
			'flibrary_header_image_title',
			array(
			    'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_header_image_title',
	        array(
	            'label'          => __( 'Title', 'flibrary' ),
	            'section'        => 'header_image',
	            'settings'       => 'flibrary_header_image_title',
	            'type'           => 'text',
	            )
	        )
		);

		// Add Header Image Section Content
		$wp_customize->add_setting(
			'flibrary_header_image_content',
			array(
			    'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_header_image_content',
	        array(
	            'label'          => __( 'Content', 'flibrary' ),
	            'section'        => 'header_image',
	            'settings'       => 'flibrary_header_image_content',
	            'type'           => 'textarea',
	            )
	        )
		);

		/**
	 * Add Social Sites Section
	 */
	$wp_customize->add_section(
		'flibrary_social_section',
		array(
			'title'       => __( 'Social Sites', 'flibrary' ),
			'capability'  => 'edit_theme_options',
		)
	);
	
	// Add facebook url
	$wp_customize->add_setting(
		'flibrary_social_facebook',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_facebook',
        array(
            'label'          => __( 'Facebook Page URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_facebook',
            'type'           => 'text',
            )
        )
	);

	// Add Twitter url
	$wp_customize->add_setting(
		'flibrary_social_twitter',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_twitter',
        array(
            'label'          => __( 'Twitter URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_twitter',
            'type'           => 'text',
            )
        )
	);

	// Add LinkedIn url
	$wp_customize->add_setting(
		'flibrary_social_linkedin',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_linkedin',
        array(
            'label'          => __( 'LinkedIn URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_linkedin',
            'type'           => 'text',
            )
        )
	);

	// Add Instagram url
	$wp_customize->add_setting(
		'flibrary_social_instagram',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_instagram',
        array(
            'label'          => __( 'LinkedIn URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_instagram',
            'type'           => 'text',
            )
        )
	);

	// Add RSS Feeds url
	$wp_customize->add_setting(
		'flibrary_social_rss',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_rss',
        array(
            'label'          => __( 'RSS Feeds URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_rss',
            'type'           => 'text',
            )
        )
	);

	// Add Tumblr url
	$wp_customize->add_setting(
		'flibrary_social_tumblr',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_tumblr',
        array(
            'label'          => __( 'Tumblr URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_tumblr',
            'type'           => 'text',
            )
        )
	);

	// Add YouTube channel url
	$wp_customize->add_setting(
		'flibrary_social_youtube',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_youtube',
        array(
            'label'          => __( 'YouTube channel URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_youtube',
            'type'           => 'text',
            )
        )
	);

	// Add Pinterest url
	$wp_customize->add_setting(
		'flibrary_social_pinterest',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_pinterest',
        array(
            'label'          => __( 'Pinterest URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_pinterest',
            'type'           => 'text',
            )
        )
	);

	// Add VK url
	$wp_customize->add_setting(
		'flibrary_social_vk',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_vk',
        array(
            'label'          => __( 'VK URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_vk',
            'type'           => 'text',
            )
        )
	);

	// Add Flickr url
	$wp_customize->add_setting(
		'flibrary_social_flickr',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_flickr',
        array(
            'label'          => __( 'Flickr URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_flickr',
            'type'           => 'text',
            )
        )
	);

	// Add Vine url
	$wp_customize->add_setting(
		'flibrary_social_vine',
		array(
		    'sanitize_callback' => 'flibrary_sanitize_url',
		)
	);

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_social_vine',
        array(
            'label'          => __( 'Vine URL', 'flibrary' ),
            'section'        => 'flibrary_social_section',
            'settings'       => 'flibrary_social_vine',
            'type'           => 'text',
            )
        )
	);
	}

endif; // flibrary_customize_register

add_action('customize_register', 'flibrary_customize_register');

if ( ! function_exists( 'flibrary_custom_header_setup' ) ) :
  /**
   * Set up the WordPress core custom header feature.
   *
   * @uses flibrary_header_style()
   */
  function flibrary_custom_header_setup() {

  	add_theme_support( 'custom-header', array (
                         'default-image'          => get_stylesheet_directory_uri()
                         								. '/images/header-image.jpg',
                         'flex-height'            => true,
                         'flex-width'             => true,
                         'uploads'                => true,
                         'width'                  => 1200,
                         'height'                 => 560,
                         'default-text-color'     => '#000000',
                         'wp-head-callback'       => 'flibrary_header_style',
                      ) );
  }
endif; // flibrary_custom_header_setup
add_action( 'after_setup_theme', 'flibrary_custom_header_setup' );

if ( ! function_exists( 'flibrary_header_style' ) ) :

  /**
   * Styles the header image and text displayed on the blog.
   *
   * @see flibrary_custom_header_setup().
   */
  function flibrary_header_style() {

  	$header_text_color = get_header_textcolor();

      if ( ! has_header_image()
          && ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color
               || 'blank' === $header_text_color ) ) {

          return;
      }

      $headerImage = get_header_image();
  ?>
      <style id="flibrary-custom-header-styles" type="text/css">

          <?php if ( has_header_image() ) : ?>

                  #header-landing-section {background-image: url("<?php echo esc_url( $headerImage ); ?>");}

          <?php endif; ?>

          <?php if ( get_theme_support( 'custom-header', 'default-text-color' ) !== $header_text_color
                      && 'blank' !== $header_text_color ) : ?>

                  #header-landing-section, #header-landing-section h1.entry-title {color: #<?php echo sanitize_hex_color_no_hash( $header_text_color ); ?>;}

          <?php endif; ?>
      </style>
  <?php
  }
endif; // End of flibrary_header_style.


function flibrary_display_social_sites() {

	echo '<ul class="header-social-widget">';

	$socialURL = get_theme_mod('flibrary_social_facebook');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on Facebook', 'flibrary') . '" class="facebook16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_twitter');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on Twitter', 'flibrary') . '" class="twitter16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_linkedin');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on LinkedIn', 'flibrary') . '" class="linkedin16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_instagram');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on Instagram', 'flibrary') . '" class="instagram16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_rss');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow our RSS Feeds', 'flibrary') . '" class="rss16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_tumblr');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on Tumblr', 'flibrary') . '" class="tumblr16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_youtube');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on Youtube', 'flibrary') . '" class="youtube16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_pinterest');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on Pinterest', 'flibrary') . '" class="pinterest16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_vk');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on VK', 'flibrary') . '" class="vk16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_flickr');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on Flickr', 'flibrary') . '" class="flickr16"></a></li>';
	}

	$socialURL = get_theme_mod('flibrary_social_vine');
	if ( !empty($socialURL) ) {

		echo '<li><a href="' . esc_url( $socialURL ) . '" title="' . __('Follow us on Vine', 'flibrary') . '" class="vine16"></a></li>';
	}

	echo '</ul>';
}

if ( ! function_exists( 'flibrary_setup' ) ) {
	/**
	 * fLibrary setup.
	 *
	 * Set up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support post thumbnails.
	 *
	 */
	function flibrary_setup() {

		// Define and register starter content to showcase the theme on new sites.
		$starter_content = array(

			'widgets' => array(
				'sidebar-widget-area' => array(
					'search',
					'recent-posts',
					'categories',
					'archives',
				),



				'footer-column-1-widget-area' => array(
					'recent-comments'
				),

				'footer-column-2-widget-area' => array(
					'recent-posts'
				),

				'footer-column-3-widget-area' => array(
					'calendar'
				),
			),

			'posts' => array(
				'home',
				'blog',
				'about',
				'contact'
			),

			// Default to a static front page and assign the front and posts pages.
			'options' => array(
				'show_on_front' => 'page',
				'page_on_front' => '{{home}}',
				'page_for_posts' => '{{blog}}',
			),

			// Set the front page section theme mods to the IDs of the core-registered pages.
			'theme_mods' => array(
				'flibrary_social_facebook' => _x( '#', 'Theme starter content', 'flibrary' ),
				'flibrary_social_twitter' => _x( '#', 'Theme starter content', 'flibrary' ),
				'flibrary_social_linkedin' => _x( '#', 'Theme starter content', 'flibrary' ),
				'flibrary_social_instagram' => _x( '#', 'Theme starter content', 'flibrary' ),
			),

			'nav_menus' => array(

				// Assign a menu to the "primary" location.
				'primary' => array(
					'name' => __( 'Primary Menu', 'flibrary' ),
					'items' => array(
						'link_home',
						'page_blog',
						'page_contact',
						'page_about',
					),
				),

				// Assign a menu to the "footer" location.
				'footer' => array(
					'name' => __( 'Footer Menu', 'flibrary' ),
					'items' => array(
						'link_home',
						'page_about',
						'page_blog',
						'page_contact',
					),
				),
			),
		);

		$starter_content = apply_filters( 'flibrary_starter_content', $starter_content );
		add_theme_support( 'starter-content', $starter_content );
	}
} // flibrary_setup
add_action( 'after_setup_theme', 'flibrary_setup' );


if ( class_exists('WP_Customize_Section') ) {
	class flibrary_Customize_Section_Pro extends WP_Customize_Section {

		// The type of customize section being rendered.
		public $type = 'flibrary';

		// Custom button text to output.
		public $pro_text = '';

		// Custom pro button URL.
		public $pro_url = '';

		// Add custom parameters to pass to the JS via JSON.
		public function json() {
			$json = parent::json();

			$json['pro_text'] = $this->pro_text;
			$json['pro_url']  = esc_url( $this->pro_url );

			return $json;
		}

		// Outputs the template
		protected function render_template() {
?>

			<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

				<h3 class="accordion-section-title">
					{{ data.title }}

					<# if ( data.pro_text && data.pro_url ) { #>
						<a href="{{ data.pro_url }}" class="button button-primary alignright" target="_blank">{{ data.pro_text }}</a>
					<# } #>
				</h3>
			</li>
		<?php }
	}
}

/**
 * Singleton class for handling the theme's customizer integration.
 */
final class flibrary_Customize {

	// Returns the instance.
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	// Constructor method.
	private function __construct() {}

	// Sets up initial actions.
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	// Sets up the customizer sections.
	public function sections( $manager ) {

		// Load custom sections.

		// Register custom section types.
		$manager->register_section_type( 'flibrary_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new flibrary_Customize_Section_Pro(
				$manager,
				'flibrary',
				array(
					'title'    => esc_html__( 'tStore', 'flibrary' ),
					'pro_text' => esc_html__( 'Upgrade to Pro', 'flibrary' ),
					'pro_url'  => esc_url( 'https://tishonator.com/product/tlibrary' )
				)
			)
		);
	}

	// Loads theme customizer CSS.
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'flibrary-customize-controls', trailingslashit( get_template_directory_uri() ) . 'js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'flibrary-customize-controls', trailingslashit( get_template_directory_uri() ) . 'css/customize-controls.css' );
	}
}

// Doing this customizer thang!
flibrary_Customize::get_instance();

if ( ! function_exists( 'flibrary_customize_register' ) ) :
	/**
	 * Add postMessage support for site title and description for the Theme Customizer.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	function flibrary_customize_register( $wp_customize ) {

		/**
		 * Add Footer Section
		 */
		$wp_customize->add_section(
			'flibrary_footer_section',
			array(
				'title'       => __( 'Footer', 'flibrary' ),
				'capability'  => 'edit_theme_options',
			)
		);
		
		// Add Footer Copyright Text
		$wp_customize->add_setting(
			'flibrary_footer_copyright',
			array(
			    'default'           => '',
			    'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'flibrary_footer_copyright',
	        array(
	            'label'          => __( 'Copyright Text', 'flibrary' ),
	            'section'        => 'flibrary_footer_section',
	            'settings'       => 'flibrary_footer_copyright',
	            'type'           => 'text',
	            )
	        )
		);

		/**
		 * Add Animations Section
		 */
		$wp_customize->add_section(
			'flibrary_animations_display',
			array(
				'title'       => __( 'Animations', 'flibrary' ),
				'capability'  => 'edit_theme_options',
			)
		);

		// Add display Animations option
		$wp_customize->add_setting(
				'flibrary_animations_display',
				array(
						'default'           => 0,
						'sanitize_callback' => 'flibrary_sanitize_checkbox',
				)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize,
							'flibrary_animations_display',
								array(
									'label'          => __( 'Enable Animations', 'flibrary' ),
									'section'        => 'flibrary_animations_display',
									'settings'       => 'flibrary_animations_display',
									'type'           => 'checkbox',
								)
							)
		);
	}
endif; // flibrary_customize_register
add_action( 'customize_register', 'flibrary_customize_register' );
