<?php
/**
 * Title: Pricing
 * Slug: flexia/pricing
 * Categories: flexia
 */
?>
<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|60","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
<div id="pricing" class="wp-block-group" style="padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--30)"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center","style":{"typography":{"letterSpacing":"4px","textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|primary"}}}},"textColor":"primary","fontSize":"small"} -->
<p class="has-text-align-center has-primary-color has-text-color has-link-color has-small-font-size" style="letter-spacing:4px;text-transform:uppercase"><?php echo esc_html_x( 'pricing', 'Message to convey pricing content', 'flexia' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"center","style":{"typography":{"textTransform":"capitalize"}},"textColor":"Heading","fontSize":"large-plus"} -->
<h2 class="wp-block-heading has-text-align-center has-heading-color has-text-color has-large-plus-font-size" style="text-transform:capitalize"><?php echo esc_html_x( 'Flexible Pricing Plan', 'Message to convey pricing content', 'flexia' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"20px"} -->
<div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->

<!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|40","left":"0","right":"0"}},"border":{"radius":"4px"}},"className":"hover-box-shadow is-style-flexia-hover-shadow","layout":{"type":"constrained"}} -->
<div class="wp-block-group hover-box-shadow is-style-flexia-hover-shadow" style="border-radius:4px;padding-right:0;padding-bottom:var(--wp--preset--spacing--40);padding-left:0"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|x-small","bottom":"var:preset|spacing|x-small","left":"var:preset|spacing|x-small","right":"var:preset|spacing|x-small"}},"border":{"radius":"4px"}},"backgroundColor":"button-background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-button-background-background-color has-background" style="border-radius:4px;padding-top:var(--wp--preset--spacing--x-small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--x-small)"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri( "/assets/images/pricing-bg-1.png" ) ); ?>","dimRatio":0,"customOverlayColor":"#d9d9d9","isUserOverlayColor":true,"focalPoint":{"x":1,"y":1},"minHeight":180,"isDark":false,"style":{"border":{"radius":"16px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light" style="border-radius:16px;min-height:180px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#d9d9d9"></span><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_theme_file_uri( "/assets/images/pricing-bg-1.png" ) ); ?>" style="object-position:100% 100%" data-object-fit="cover" data-object-position="100% 100%"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:heading {"level":4,"textColor":"body-white","fontSize":"medium"} -->
<h4 class="wp-block-heading has-body-white-color has-text-color has-medium-font-size"><?php echo esc_html_x( 'Standard', 'Message to convey pricing content', 'flexia' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small","margin":{"bottom":"var:preset|spacing|xx-small"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"textColor":"body-white","fontSize":"large"} -->
<h2 class="wp-block-heading has-body-white-color has-text-color has-large-font-size"><?php echo esc_html_x( '$49', 'Message to convey pricing content', 'flexia' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"textColor":"body-white","fontSize":"small"} -->
<p class="has-body-white-color has-text-color has-small-font-size"><?php echo esc_html_x( '/month', 'Message to convey pricing content', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"textColor":"body-alt","fontSize":"small"} -->
<p class="has-body-alt-color has-text-color has-small-font-size"><?php echo esc_html_x( 'Get started with basic features and kickstart your journey', 'Message to convey pricing content', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|30","left":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:list {"style":{"typography":{"lineHeight":"2.8"}},"className":"is-style-checkmark-list is-style-flexia-list-style-hide is-style-flexia-checkmark-list","fontSize":"small"} -->
<ul style="line-height:2.8" class="is-style-checkmark-list is-style-flexia-list-style-hide is-style-flexia-checkmark-list has-small-font-size"><!-- wp:list-item -->
<li><?php echo esc_html_x( 'Customization Options', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Responsive Design', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'SEO Optimization', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Blog Integration', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( '24/7 Live Chat Support', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Priority Updates', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"Heading","textColor":"body-white","width":100,"style":{"elements":{"link":{"color":{"text":"var:preset|color|body-white"}}}}} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-body-white-color has-heading-background-color has-text-color has-background has-link-color wp-element-button"><?php esc_html_e( 'Get Started', 'flexia' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|40","left":"0","right":"0","top":"0"}},"border":{"radius":"4px"}},"className":"is-style-flexia-hover-shadow","layout":{"type":"constrained"}} -->
<div class="wp-block-group is-style-flexia-hover-shadow" style="border-radius:4px;padding-top:0;padding-right:0;padding-bottom:var(--wp--preset--spacing--40);padding-left:0"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|x-small","bottom":"var:preset|spacing|x-small","left":"var:preset|spacing|x-small","right":"var:preset|spacing|x-small"}},"border":{"radius":"4px"}},"backgroundColor":"primary","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-primary-background-color has-background" style="border-radius:4px;padding-top:var(--wp--preset--spacing--x-small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--x-small)"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri( "/assets/images/pricing-bg-2.png" ) ); ?>","dimRatio":0,"customOverlayColor":"#d9d9d9","isUserOverlayColor":true,"focalPoint":{"x":0.78,"y":0.08},"minHeight":180,"contentPosition":"center center","isDark":false,"style":{"border":{"radius":"16px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light" style="border-radius:16px;min-height:180px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#d9d9d9"></span><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_theme_file_uri( "/assets/images/pricing-bg-2.png" ) ); ?>" style="object-position:78% 8%" data-object-fit="cover" data-object-position="78% 8%"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"padding":{"right":"0","left":"0","top":"0"},"blockGap":"var:preset|spacing|xx-small"}},"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group" style="padding-top:0;padding-right:0;padding-left:0"><!-- wp:columns {"verticalAlignment":"top","isStackedOnMobile":false} -->
<div class="wp-block-columns are-vertically-aligned-top is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"top"} -->
<div class="wp-block-column is-vertically-aligned-top"><!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":4,"textColor":"body-white","fontSize":"medium"} -->
<h4 class="wp-block-heading has-body-white-color has-text-color has-medium-font-size"><?php echo esc_html_x( 'Premium', 'Message to convey pricing content', 'flexia' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small","margin":{"bottom":"var:preset|spacing|xx-small"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"textColor":"body-white","fontSize":"large"} -->
<h2 class="wp-block-heading has-body-white-color has-text-color has-large-font-size"><?php echo esc_html_x( '$149', 'Message to convey pricing content', 'flexia' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"textColor":"body-white","fontSize":"small"} -->
<p class="has-body-white-color has-text-color has-small-font-size"><?php echo esc_html_x( '/month', 'Message to convey pricing content', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"110px"} -->
<div class="wp-block-column is-vertically-aligned-top" style="flex-basis:110px"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:0;padding-bottom:0"><!-- wp:group {"style":{"border":{"radius":"26px"},"position":{"type":""},"spacing":{"blockGap":"0","padding":{"top":"6px","bottom":"6px","left":"2px","right":"2px"}},"dimensions":{"minHeight":""}},"backgroundColor":"luminous-vivid-amber","className":"is-style-default","layout":{"type":"flex","orientation":"vertical","justifyContent":"center","flexWrap":"wrap"}} -->
<div class="wp-block-group is-style-default has-luminous-vivid-amber-background-color has-background" style="border-radius:26px;padding-top:6px;padding-right:2px;padding-bottom:6px;padding-left:2px"><!-- wp:paragraph {"align":"center","style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}},"layout":{"selfStretch":"fit","flexSize":""}},"textColor":"black","fontSize":"small"} -->
<p class="has-text-align-center has-black-color has-text-color has-small-font-size" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><?php echo esc_html_x( 'Popular', 'Message to convey pricing content', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:paragraph {"textColor":"body-white","fontSize":"small"} -->
<p class="has-body-white-color has-text-color has-small-font-size"><?php echo esc_html_x( 'Unlock advanced tools for greater results & elevate experience', 'Message to convey pricing content', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|30","left":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:list {"style":{"typography":{"lineHeight":"2.8"}},"className":"is-style-checkmark-list is-style-flexia-list-style-hide is-style-flexia-checkmark-list","fontSize":"small"} -->
<ul style="line-height:2.8" class="is-style-checkmark-list is-style-flexia-list-style-hide is-style-flexia-checkmark-list has-small-font-size"><!-- wp:list-item -->
<li><?php echo esc_html_x( 'Customization Options', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Responsive Design', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'SEO Optimization', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Blog Integration', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( '24/7 Live Chat Support', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Priority Updates', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"Heading","textColor":"body-white","width":100,"style":{"elements":{"link":{"color":{"text":"var:preset|color|body-white"}}}}} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-body-white-color has-heading-background-color has-text-color has-background has-link-color wp-element-button"><?php esc_html_e( 'Get Started', 'flexia' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0","bottom":"var:preset|spacing|40","left":"0","right":"0"}},"border":{"radius":"4px"}},"className":"hover-box-shadow is-style-flexia-hover-shadow","layout":{"type":"constrained"}} -->
<div class="wp-block-group hover-box-shadow is-style-flexia-hover-shadow" style="border-radius:4px;padding-top:0;padding-right:0;padding-bottom:var(--wp--preset--spacing--40);padding-left:0"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|x-small","bottom":"var:preset|spacing|x-small","left":"var:preset|spacing|x-small","right":"var:preset|spacing|x-small"}},"border":{"radius":"4px"}},"backgroundColor":"button-background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-button-background-background-color has-background" style="border-radius:4px;padding-top:var(--wp--preset--spacing--x-small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--x-small)"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri( "/assets/images/pricing-bg-1.png" ) ); ?>","dimRatio":0,"customOverlayColor":"#d9d9d9","isUserOverlayColor":true,"focalPoint":{"x":1,"y":1},"minHeight":180,"isDark":false,"style":{"border":{"radius":"16px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover is-light" style="border-radius:16px;min-height:180px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim" style="background-color:#d9d9d9"></span><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_theme_file_uri( "/assets/images/pricing-bg-1.png" ) ); ?>" style="object-position:100% 100%" data-object-fit="cover" data-object-position="100% 100%"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"padding":{"right":"0","left":"0","top":"0"},"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:0;padding-right:0;padding-left:0"><!-- wp:heading {"level":4,"textColor":"body-white","fontSize":"medium"} -->
<h4 class="wp-block-heading has-body-white-color has-text-color has-medium-font-size"><?php echo esc_html_x( 'Enterprise', 'Message to convey pricing content', 'flexia' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small","margin":{"bottom":"var:preset|spacing|xx-small"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--xx-small)"><!-- wp:heading {"textColor":"body-white","fontSize":"large"} -->
<h2 class="wp-block-heading has-body-white-color has-text-color has-large-font-size"><?php echo esc_html_x( '$200', 'Message to convey pricing content', 'flexia' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"textColor":"body-white","fontSize":"small"} -->
<p class="has-body-white-color has-text-color has-small-font-size"><?php echo esc_html_x( '/month', 'Message to convey pricing content', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"textColor":"body-alt","fontSize":"small"} -->
<p class="has-body-alt-color has-text-color has-small-font-size"><?php echo esc_html_x( 'Get started with basic features and kickstart your journey', 'Message to convey pricing content', 'flexia' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|30","left":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:list {"style":{"typography":{"lineHeight":"2.8"}},"className":"is-style-checkmark-list is-style-flexia-list-style-hide is-style-flexia-checkmark-list","fontSize":"small"} -->
<ul style="line-height:2.8" class="is-style-checkmark-list is-style-flexia-list-style-hide is-style-flexia-checkmark-list has-small-font-size"><!-- wp:list-item -->
<li><?php echo esc_html_x( 'Customization Options', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Responsive Design', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'SEO Optimization', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Blog Integration', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( '24/7 Live Chat Support', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html_x( 'Priority Updates', 'Message to convey pricing content', 'flexia' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"Heading","textColor":"body-white","width":100,"style":{"elements":{"link":{"color":{"text":"var:preset|color|body-white"}}}}} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-body-white-color has-heading-background-color has-text-color has-background has-link-color wp-element-button"><?php esc_html_e( 'Get Started', 'flexia' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->